/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.fluent;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.plist.PropertyListConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigurations {
    private static final String TEST_PROPERTIES = "test.properties";
    private static final String TEST_XML = "test.xml";
    private static final String TEST_INI = "test.ini";
    private static final String TEST_COMBINED = "testDigesterConfiguration.xml";
    private static final String TEST_PLIST = "test.plist";

    private static String absolutePath(String name) {
        return ConfigurationAssert.getTestFile(name).getAbsolutePath();
    }

    private static void checkCombined(Configuration config) {
        TestConfigurations.checkProperties(config);
        TestConfigurations.checkXML(config);
    }

    private static void checkINI(INIConfiguration config) {
        Assertions.assertEquals((Object)"yes", (Object)config.getProperty("testini.loaded"));
    }

    private static void checkPList(Configuration config) {
        Assertions.assertEquals((Object)"string1", (Object)config.getProperty("simple-string"));
    }

    private static void checkProperties(Configuration config) {
        Assertions.assertEquals((Object)"true", (Object)config.getString("configuration.loaded"));
    }

    private static void checkXML(Configuration config) {
        Assertions.assertEquals((Object)"value", (Object)config.getProperty("element"));
    }

    @Test
    void testCombinedBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfigurationBuilder builder = configs.combinedBuilder(ConfigurationAssert.getTestFile(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)builder.getConfiguration());
    }

    @Test
    void testCombinedBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfigurationBuilder builder = configs.combinedBuilder(TestConfigurations.absolutePath(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)builder.getConfiguration());
    }

    @Test
    void testCombinedBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfigurationBuilder builder = configs.combinedBuilder(ConfigurationAssert.getTestURL(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)builder.getConfiguration());
    }

    @Test
    void testCombinedFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfiguration config = configs.combined(ConfigurationAssert.getTestFile(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)config);
    }

    @Test
    void testCombinedFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfiguration config = configs.combined(TestConfigurations.absolutePath(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)config);
    }

    @Test
    void testCombinedFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfiguration config = configs.combined(ConfigurationAssert.getTestURL(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)config);
    }

    @Test
    void testDefaultParameters() {
        Configurations configs = new Configurations();
        Assertions.assertNotNull((Object)configs.getParameters());
    }

    @Test
    void testFileBasedBuilderWithFile() {
        Configurations configs = new Configurations();
        File file = ConfigurationAssert.getTestFile(TEST_PROPERTIES);
        FileBasedConfigurationBuilder builder = configs.fileBasedBuilder(PropertiesConfiguration.class, file);
        Assertions.assertEquals((Object)file.toURI(), (Object)builder.getFileHandler().getFile().toURI());
    }

    @Test
    void testFileBasedBuilderWithPath() {
        Configurations configs = new Configurations();
        String filePath = TestConfigurations.absolutePath(TEST_PROPERTIES);
        FileBasedConfigurationBuilder builder = configs.fileBasedBuilder(PropertiesConfiguration.class, filePath);
        Assertions.assertEquals((Object)filePath, (Object)builder.getFileHandler().getFileName());
    }

    @Test
    void testFileBasedBuilderWithURL() {
        Configurations configs = new Configurations();
        URL url = ConfigurationAssert.getTestURL(TEST_PROPERTIES);
        FileBasedConfigurationBuilder builder = configs.fileBasedBuilder(PropertiesConfiguration.class, url);
        Assertions.assertEquals((Object)url, (Object)builder.getFileHandler().getURL());
    }

    @Test
    void testFileBasedFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertyListConfiguration config = (PropertyListConfiguration)configs.fileBased(PropertyListConfiguration.class, ConfigurationAssert.getTestFile(TEST_PLIST));
        TestConfigurations.checkPList((Configuration)config);
    }

    @Test
    void testFileBasedPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertyListConfiguration config = (PropertyListConfiguration)configs.fileBased(PropertyListConfiguration.class, TestConfigurations.absolutePath(TEST_PLIST));
        TestConfigurations.checkPList((Configuration)config);
    }

    @Test
    void testFileBasedURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertyListConfiguration config = (PropertyListConfiguration)configs.fileBased(PropertyListConfiguration.class, ConfigurationAssert.getTestURL(TEST_PLIST));
        TestConfigurations.checkPList((Configuration)config);
    }

    @Test
    void testINIBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.iniBuilder(ConfigurationAssert.getTestFile(TEST_INI));
        TestConfigurations.checkINI((INIConfiguration)builder.getConfiguration());
    }

    @Test
    void testINIBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.iniBuilder(TestConfigurations.absolutePath(TEST_INI));
        TestConfigurations.checkINI((INIConfiguration)builder.getConfiguration());
    }

    @Test
    void testINIBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.iniBuilder(ConfigurationAssert.getTestURL(TEST_INI));
        TestConfigurations.checkINI((INIConfiguration)builder.getConfiguration());
    }

    @Test
    void testINIFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        INIConfiguration config = configs.ini(ConfigurationAssert.getTestFile(TEST_INI));
        TestConfigurations.checkINI(config);
    }

    @Test
    void testINIFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        INIConfiguration config = configs.ini(TestConfigurations.absolutePath(TEST_INI));
        TestConfigurations.checkINI(config);
    }

    @Test
    void testINIFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        INIConfiguration config = configs.ini(ConfigurationAssert.getTestURL(TEST_INI));
        TestConfigurations.checkINI(config);
    }

    @Test
    void testInitWithParameters() {
        Parameters params = new Parameters();
        Configurations configs = new Configurations(params);
        Assertions.assertSame((Object)params, (Object)configs.getParameters());
    }

    @Test
    void testPropertiesBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(ConfigurationAssert.getTestFile(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)builder.getConfiguration());
    }

    @Test
    void testPropertiesBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(TestConfigurations.absolutePath(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)builder.getConfiguration());
    }

    @Test
    void testPropertiesBuilderFromPathIncludeNotFoundFail() {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(TestConfigurations.absolutePath("include-not-found.properties"));
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileBasedConfigurationBuilder)builder).getConfiguration());
    }

    @Test
    void testPropertiesBuilderFromPathIncludeNotFoundPass() throws ConfigurationException {
        Configurations configs = new Configurations();
        String absPath = TestConfigurations.absolutePath("include-not-found.properties");
        FileBasedConfigurationBuilder builderFail = configs.propertiesBuilder(absPath);
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileBasedConfigurationBuilder)builderFail).getConfiguration());
        Assertions.assertThrows(ConfigurationException.class, () -> configs.properties(absPath));
        Map map = ((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setPath(absPath)).setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER)).getParameters();
        BasicConfigurationBuilder builderOk = configs.propertiesBuilder(absPath).addParameters(map);
        Assertions.assertEquals((Object)"valueA", (Object)((PropertiesConfiguration)builderOk.getConfiguration()).getString("keyA"));
        FileBasedConfigurationBuilder builderOk2 = configs.propertiesBuilder((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setPath(absPath)).setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER));
        Assertions.assertEquals((Object)"valueA", (Object)((PropertiesConfiguration)builderOk2.getConfiguration()).getString("keyA"));
    }

    @Test
    void testPropertiesBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(ConfigurationAssert.getTestURL(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)builder.getConfiguration());
    }

    @Test
    void testPropertiesFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertiesConfiguration config = configs.properties(ConfigurationAssert.getTestFile(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)config);
    }

    @Test
    void testPropertiesFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertiesConfiguration config = configs.properties(TestConfigurations.absolutePath(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)config);
    }

    @Test
    void testPropertiesFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertiesConfiguration config = configs.properties(ConfigurationAssert.getTestURL(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)config);
    }

    @Test
    void testXMLBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.xmlBuilder(ConfigurationAssert.getTestFile(TEST_XML));
        TestConfigurations.checkXML((Configuration)builder.getConfiguration());
    }

    @Test
    void testXMLBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.xmlBuilder(TestConfigurations.absolutePath(TEST_XML));
        TestConfigurations.checkXML((Configuration)builder.getConfiguration());
    }

    @Test
    void testXMLBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.xmlBuilder(ConfigurationAssert.getTestURL(TEST_XML));
        TestConfigurations.checkXML((Configuration)builder.getConfiguration());
    }

    @Test
    void testXMLFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        XMLConfiguration config = configs.xml(ConfigurationAssert.getTestFile(TEST_XML));
        TestConfigurations.checkXML((Configuration)config);
    }

    @Test
    void testXMLFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        XMLConfiguration config = configs.xml(TestConfigurations.absolutePath(TEST_XML));
        TestConfigurations.checkXML((Configuration)config);
    }

    @Test
    void testXMLFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        XMLConfiguration config = configs.xml(ConfigurationAssert.getTestURL(TEST_XML));
        TestConfigurations.checkXML((Configuration)config);
    }
}

