/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbcp2.DelegatingCallableStatement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.TesterCallableStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingCallableStatement {
    private TesterConnection conn;
    private DelegatingCallableStatement delegate;
    private CallableStatement obj;

    @BeforeEach
    public void setUp() throws Exception {
        this.conn = new TesterConnection("test", "test");
        this.obj = (CallableStatement)Mockito.mock(CallableStatement.class);
        DelegatingConnection delegatingConnection = new DelegatingConnection((Connection)this.conn);
        this.delegate = new DelegatingCallableStatement(delegatingConnection, this.obj);
    }

    @Test
    public void testExecuteQueryReturnsNotNull() throws Exception {
        TesterCallableStatement delegateStmt = new TesterCallableStatement(this.conn, "select * from foo");
        this.obj = new DelegatingCallableStatement(new DelegatingConnection((Connection)this.conn), (CallableStatement)delegateStmt);
        Assertions.assertNotNull((Object)this.obj.executeQuery());
    }

    @Test
    public void testExecuteQueryReturnsNull() throws Exception {
        TesterCallableStatement delegateStmt = new TesterCallableStatement(this.conn, "null");
        this.obj = new DelegatingCallableStatement(new DelegatingConnection((Connection)this.conn), (CallableStatement)delegateStmt);
        Assertions.assertNull((Object)this.obj.executeQuery());
    }

    @Test
    public void testGetArrayInteger() throws Exception {
        try {
            this.delegate.getArray(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getArray(1);
    }

    @Test
    public void testGetArrayString() throws Exception {
        try {
            this.delegate.getArray("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getArray("foo");
    }

    @Test
    public void testGetBigDecimalInteger() throws Exception {
        try {
            this.delegate.getBigDecimal(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBigDecimal(1);
    }

    @Test
    public void testGetBigDecimalIntegerInteger() throws Exception {
        try {
            this.delegate.getBigDecimal(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBigDecimal(1, 1);
    }

    @Test
    public void testGetBigDecimalString() throws Exception {
        try {
            this.delegate.getBigDecimal("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBigDecimal("foo");
    }

    @Test
    public void testGetBlobInteger() throws Exception {
        try {
            this.delegate.getBlob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBlob(1);
    }

    @Test
    public void testGetBlobString() throws Exception {
        try {
            this.delegate.getBlob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBlob("foo");
    }

    @Test
    public void testGetBooleanInteger() throws Exception {
        try {
            this.delegate.getBoolean(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBoolean(1);
    }

    @Test
    public void testGetBooleanString() throws Exception {
        try {
            this.delegate.getBoolean("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBoolean("foo");
    }

    @Test
    public void testGetByteInteger() throws Exception {
        try {
            this.delegate.getByte(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getByte(1);
    }

    @Test
    public void testGetBytesInteger() throws Exception {
        try {
            this.delegate.getBytes(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBytes(1);
    }

    @Test
    public void testGetBytesString() throws Exception {
        try {
            this.delegate.getBytes("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getBytes("foo");
    }

    @Test
    public void testGetByteString() throws Exception {
        try {
            this.delegate.getByte("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getByte("foo");
    }

    @Test
    public void testGetCharacterStreamInteger() throws Exception {
        try {
            this.delegate.getCharacterStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCharacterStream(1);
    }

    @Test
    public void testGetCharacterStreamString() throws Exception {
        try {
            this.delegate.getCharacterStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getCharacterStream("foo");
    }

    @Test
    public void testGetClobInteger() throws Exception {
        try {
            this.delegate.getClob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getClob(1);
    }

    @Test
    public void testGetClobString() throws Exception {
        try {
            this.delegate.getClob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getClob("foo");
    }

    @Test
    public void testGetDateInteger() throws Exception {
        try {
            this.delegate.getDate(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate(1);
    }

    @Test
    public void testGetDateIntegerCalendar() throws Exception {
        try {
            this.delegate.getDate(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate(1, (Calendar)null);
    }

    @Test
    public void testGetDateString() throws Exception {
        try {
            this.delegate.getDate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate("foo");
    }

    @Test
    public void testGetDateStringCalendar() throws Exception {
        try {
            this.delegate.getDate("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDate("foo", (Calendar)null);
    }

    @Test
    public void testGetDelegate() throws Exception {
        TesterCallableStatement delegateStmt = new TesterCallableStatement(this.conn, "select * from foo");
        this.obj = new DelegatingCallableStatement(new DelegatingConnection((Connection)this.conn), (CallableStatement)delegateStmt);
        Assertions.assertEquals((Object)delegateStmt, (Object)((DelegatingCallableStatement)this.obj).getDelegate());
    }

    @Test
    public void testGetDoubleInteger() throws Exception {
        try {
            this.delegate.getDouble(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDouble(1);
    }

    @Test
    public void testGetDoubleString() throws Exception {
        try {
            this.delegate.getDouble("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getDouble("foo");
    }

    @Test
    public void testGetFloatInteger() throws Exception {
        try {
            this.delegate.getFloat(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFloat(1);
    }

    @Test
    public void testGetFloatString() throws Exception {
        try {
            this.delegate.getFloat("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getFloat("foo");
    }

    @Test
    public void testGetIntInteger() throws Exception {
        try {
            this.delegate.getInt(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getInt(1);
    }

    @Test
    public void testGetIntString() throws Exception {
        try {
            this.delegate.getInt("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getInt("foo");
    }

    @Test
    public void testGetLongInteger() throws Exception {
        try {
            this.delegate.getLong(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getLong(1);
    }

    @Test
    public void testGetLongString() throws Exception {
        try {
            this.delegate.getLong("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getLong("foo");
    }

    @Test
    public void testGetNCharacterStreamInteger() throws Exception {
        try {
            this.delegate.getNCharacterStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNCharacterStream(1);
    }

    @Test
    public void testGetNCharacterStreamString() throws Exception {
        try {
            this.delegate.getNCharacterStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNCharacterStream("foo");
    }

    @Test
    public void testGetNClobInteger() throws Exception {
        try {
            this.delegate.getNClob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNClob(1);
    }

    @Test
    public void testGetNClobString() throws Exception {
        try {
            this.delegate.getNClob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNClob("foo");
    }

    @Test
    public void testGetNStringInteger() throws Exception {
        try {
            this.delegate.getNString(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNString(1);
    }

    @Test
    public void testGetNStringString() throws Exception {
        try {
            this.delegate.getNString("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getNString("foo");
    }

    @Test
    public void testGetObjectInteger() throws Exception {
        try {
            this.delegate.getObject(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject(1);
    }

    @Test
    public void testGetObjectIntegerClass() throws Exception {
        try {
            this.delegate.getObject(1, Object.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject(1, Object.class);
    }

    @Test
    public void testGetObjectIntegerMap() throws Exception {
        try {
            this.delegate.getObject(1, (Map)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject(1, (Map)null);
    }

    @Test
    public void testGetObjectString() throws Exception {
        try {
            this.delegate.getObject("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject("foo");
    }

    @Test
    public void testGetObjectStringClass() throws Exception {
        try {
            this.delegate.getObject("foo", Object.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject("foo", Object.class);
    }

    @Test
    public void testGetObjectStringMap() throws Exception {
        try {
            this.delegate.getObject("foo", (Map)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getObject("foo", (Map)null);
    }

    @Test
    public void testGetRefInteger() throws Exception {
        try {
            this.delegate.getRef(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRef(1);
    }

    @Test
    public void testGetRefString() throws Exception {
        try {
            this.delegate.getRef("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRef("foo");
    }

    @Test
    public void testGetRowIdInteger() throws Exception {
        try {
            this.delegate.getRowId(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRowId(1);
    }

    @Test
    public void testGetRowIdString() throws Exception {
        try {
            this.delegate.getRowId("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getRowId("foo");
    }

    @Test
    public void testGetShortInteger() throws Exception {
        try {
            this.delegate.getShort(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getShort(1);
    }

    @Test
    public void testGetShortString() throws Exception {
        try {
            this.delegate.getShort("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getShort("foo");
    }

    @Test
    public void testGetSQLXMLInteger() throws Exception {
        try {
            this.delegate.getSQLXML(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLXML(1);
    }

    @Test
    public void testGetSQLXMLString() throws Exception {
        try {
            this.delegate.getSQLXML("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getSQLXML("foo");
    }

    @Test
    public void testGetStringInteger() throws Exception {
        try {
            this.delegate.getString(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getString(1);
    }

    @Test
    public void testGetStringString() throws Exception {
        try {
            this.delegate.getString("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getString("foo");
    }

    @Test
    public void testGetTimeInteger() throws Exception {
        try {
            this.delegate.getTime(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime(1);
    }

    @Test
    public void testGetTimeIntegerCalendar() throws Exception {
        try {
            this.delegate.getTime(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime(1, (Calendar)null);
    }

    @Test
    public void testGetTimestampInteger() throws Exception {
        try {
            this.delegate.getTimestamp(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp(1);
    }

    @Test
    public void testGetTimestampIntegerCalendar() throws Exception {
        try {
            this.delegate.getTimestamp(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp(1, (Calendar)null);
    }

    @Test
    public void testGetTimestampString() throws Exception {
        try {
            this.delegate.getTimestamp("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp("foo");
    }

    @Test
    public void testGetTimestampStringCalendar() throws Exception {
        try {
            this.delegate.getTimestamp("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTimestamp("foo", (Calendar)null);
    }

    @Test
    public void testGetTimeString() throws Exception {
        try {
            this.delegate.getTime("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime("foo");
    }

    @Test
    public void testGetTimeStringCalendar() throws Exception {
        try {
            this.delegate.getTime("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getTime("foo", (Calendar)null);
    }

    @Test
    public void testGetURLInteger() throws Exception {
        try {
            this.delegate.getURL(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getURL(1);
    }

    @Test
    public void testGetURLString() throws Exception {
        try {
            this.delegate.getURL("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).getURL("foo");
    }

    @Test
    public void testRegisterOutParameterIntegerInteger() throws Exception {
        try {
            this.delegate.registerOutParameter(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 1);
    }

    @Test
    public void testRegisterOutParameterIntegerIntegerInteger() throws Exception {
        try {
            this.delegate.registerOutParameter(1, 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 1, 1);
    }

    @Test
    public void testRegisterOutParameterIntegerIntegerString() throws Exception {
        try {
            this.delegate.registerOutParameter(1, 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, 1, "foo");
    }

    @Test
    public void testRegisterOutParameterIntegerSQLType() throws Exception {
        try {
            this.delegate.registerOutParameter(1, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, (SQLType)null);
    }

    @Test
    public void testRegisterOutParameterIntegerSQLTypeInteger() throws Exception {
        try {
            this.delegate.registerOutParameter(1, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, (SQLType)null, 1);
    }

    @Test
    public void testRegisterOutParameterIntegerSQLTypeString() throws Exception {
        try {
            this.delegate.registerOutParameter(1, (SQLType)null, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter(1, (SQLType)null, "foo");
    }

    @Test
    public void testRegisterOutParameterStringInteger() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", 1);
    }

    @Test
    public void testRegisterOutParameterStringIntegerInteger() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", 1, 1);
    }

    @Test
    public void testRegisterOutParameterStringIntegerString() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", 1, "foo");
    }

    @Test
    public void testRegisterOutParameterStringSQLType() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", (SQLType)null);
    }

    @Test
    public void testRegisterOutParameterStringSQLTypeInteger() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", (SQLType)null, 1);
    }

    @Test
    public void testRegisterOutParameterStringSQLTypeString() throws Exception {
        try {
            this.delegate.registerOutParameter("foo", (SQLType)null, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).registerOutParameter("foo", (SQLType)null, "foo");
    }

    @Test
    public void testSetAsciiStreamStringInputStream() throws Exception {
        try {
            this.delegate.setAsciiStream("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream("foo", (InputStream)null);
    }

    @Test
    public void testSetAsciiStreamStringInputStreamInteger() throws Exception {
        try {
            this.delegate.setAsciiStream("foo", (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream("foo", (InputStream)null, 1);
    }

    @Test
    public void testSetAsciiStreamStringInputStreamLong() throws Exception {
        try {
            this.delegate.setAsciiStream("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setAsciiStream("foo", (InputStream)null, 1L);
    }

    @Test
    public void testSetBigDecimalStringBigDecimal() throws Exception {
        try {
            this.delegate.setBigDecimal("foo", BigDecimal.valueOf(1.0));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBigDecimal("foo", BigDecimal.valueOf(1.0));
    }

    @Test
    public void testSetBinaryStreamStringInputStream() throws Exception {
        try {
            this.delegate.setBinaryStream("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream("foo", (InputStream)null);
    }

    @Test
    public void testSetBinaryStreamStringInputStreamInteger() throws Exception {
        try {
            this.delegate.setBinaryStream("foo", (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream("foo", (InputStream)null, 1);
    }

    @Test
    public void testSetBinaryStreamStringInputStreamLong() throws Exception {
        try {
            this.delegate.setBinaryStream("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBinaryStream("foo", (InputStream)null, 1L);
    }

    @Test
    public void testSetBlobStringBlob() throws Exception {
        try {
            this.delegate.setBlob("foo", (Blob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob("foo", (Blob)null);
    }

    @Test
    public void testSetBlobStringInputStream() throws Exception {
        try {
            this.delegate.setBlob("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob("foo", (InputStream)null);
    }

    @Test
    public void testSetBlobStringInputStreamLong() throws Exception {
        try {
            this.delegate.setBlob("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBlob("foo", (InputStream)null, 1L);
    }

    @Test
    public void testSetBooleanStringBoolean() throws Exception {
        try {
            this.delegate.setBoolean("foo", Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBoolean("foo", (boolean)Boolean.TRUE);
    }

    @Test
    public void testSetBytesStringByteArray() throws Exception {
        try {
            this.delegate.setBytes("foo", new byte[]{1});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setBytes("foo", new byte[]{1});
    }

    @Test
    public void testSetByteStringByte() throws Exception {
        try {
            this.delegate.setByte("foo", (byte)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setByte("foo", (byte)1);
    }

    @Test
    public void testSetCharacterStreamStringReader() throws Exception {
        try {
            this.delegate.setCharacterStream("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream("foo", (Reader)null);
    }

    @Test
    public void testSetCharacterStreamStringReaderInteger() throws Exception {
        try {
            this.delegate.setCharacterStream("foo", (Reader)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream("foo", (Reader)null, 1);
    }

    @Test
    public void testSetCharacterStreamStringReaderLong() throws Exception {
        try {
            this.delegate.setCharacterStream("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setCharacterStream("foo", (Reader)null, 1L);
    }

    @Test
    public void testSetClobStringClob() throws Exception {
        try {
            this.delegate.setClob("foo", (Clob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob("foo", (Clob)null);
    }

    @Test
    public void testSetClobStringReader() throws Exception {
        try {
            this.delegate.setClob("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob("foo", (Reader)null);
    }

    @Test
    public void testSetClobStringReaderLong() throws Exception {
        try {
            this.delegate.setClob("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setClob("foo", (Reader)null, 1L);
    }

    @Test
    public void testSetDateStringSqlDate() throws Exception {
        try {
            this.delegate.setDate("foo", new Date(1529827548745L));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDate("foo", new Date(1529827548745L));
    }

    @Test
    public void testSetDateStringSqlDateCalendar() throws Exception {
        try {
            this.delegate.setDate("foo", new Date(1529827548745L), (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDate("foo", new Date(1529827548745L), (Calendar)null);
    }

    @Test
    public void testSetDoubleStringDouble() throws Exception {
        try {
            this.delegate.setDouble("foo", 1.0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setDouble("foo", 1.0);
    }

    @Test
    public void testSetFloatStringFloat() throws Exception {
        try {
            this.delegate.setFloat("foo", 1.0f);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setFloat("foo", 1.0f);
    }

    @Test
    public void testSetIntStringInteger() throws Exception {
        try {
            this.delegate.setInt("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setInt("foo", 1);
    }

    @Test
    public void testSetLongStringLong() throws Exception {
        try {
            this.delegate.setLong("foo", 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setLong("foo", 1L);
    }

    @Test
    public void testSetNCharacterStreamStringReader() throws Exception {
        try {
            this.delegate.setNCharacterStream("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNCharacterStream("foo", (Reader)null);
    }

    @Test
    public void testSetNCharacterStreamStringReaderLong() throws Exception {
        try {
            this.delegate.setNCharacterStream("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNCharacterStream("foo", (Reader)null, 1L);
    }

    @Test
    public void testSetNClobStringNClob() throws Exception {
        try {
            this.delegate.setNClob("foo", (NClob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob("foo", (NClob)null);
    }

    @Test
    public void testSetNClobStringReader() throws Exception {
        try {
            this.delegate.setNClob("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob("foo", (Reader)null);
    }

    @Test
    public void testSetNClobStringReaderLong() throws Exception {
        try {
            this.delegate.setNClob("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNClob("foo", (Reader)null, 1L);
    }

    @Test
    public void testSetNStringStringString() throws Exception {
        try {
            this.delegate.setNString("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNString("foo", "foo");
    }

    @Test
    public void testSetNullStringInteger() throws Exception {
        try {
            this.delegate.setNull("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNull("foo", 1);
    }

    @Test
    public void testSetNullStringIntegerString() throws Exception {
        try {
            this.delegate.setNull("foo", 1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setNull("foo", 1, "foo");
    }

    @Test
    public void testSetObjectStringObject() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err);
    }

    @Test
    public void testSetObjectStringObjectInteger() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, 1);
    }

    @Test
    public void testSetObjectStringObjectIntegerInteger() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, 1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, 1, 1);
    }

    @Test
    public void testSetObjectStringObjectSQLType() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, (SQLType)null);
    }

    @Test
    public void testSetObjectStringObjectSQLTypeInteger() throws Exception {
        try {
            this.delegate.setObject("foo", (Object)System.err, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setObject("foo", (Object)System.err, (SQLType)null, 1);
    }

    @Test
    public void testSetRowIdStringRowId() throws Exception {
        try {
            this.delegate.setRowId("foo", (RowId)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setRowId("foo", (RowId)null);
    }

    @Test
    public void testSetShortStringShort() throws Exception {
        try {
            this.delegate.setShort("foo", (short)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setShort("foo", (short)1);
    }

    @Test
    public void testSetSQLXMLStringSQLXML() throws Exception {
        try {
            this.delegate.setSQLXML("foo", (SQLXML)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setSQLXML("foo", (SQLXML)null);
    }

    @Test
    public void testSetStringStringString() throws Exception {
        try {
            this.delegate.setString("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setString("foo", "foo");
    }

    @Test
    public void testSetTimestampStringTimestamp() throws Exception {
        try {
            this.delegate.setTimestamp("foo", (Timestamp)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTimestamp("foo", (Timestamp)null);
    }

    @Test
    public void testSetTimestampStringTimestampCalendar() throws Exception {
        try {
            this.delegate.setTimestamp("foo", (Timestamp)null, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTimestamp("foo", (Timestamp)null, (Calendar)null);
    }

    @Test
    public void testSetTimeStringTime() throws Exception {
        try {
            this.delegate.setTime("foo", (Time)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTime("foo", (Time)null);
    }

    @Test
    public void testSetTimeStringTimeCalendar() throws Exception {
        try {
            this.delegate.setTime("foo", (Time)null, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setTime("foo", (Time)null, (Calendar)null);
    }

    @Test
    public void testSetURLStringUrl() throws Exception {
        try {
            this.delegate.setURL("foo", (URL)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).setURL("foo", (URL)null);
    }

    @Test
    public void testWasNull() throws Exception {
        try {
            this.delegate.wasNull();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((CallableStatement)Mockito.verify((Object)this.obj, (VerificationMode)Mockito.times((int)1))).wasNull();
    }
}

