/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.util.Iterator;
import org.apache.commons.fileupload2.core.FileItemHeadersImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileItemHeadersTest {
    FileItemHeadersTest() {
    }

    @Test
    void testFileItemHeaders() throws Exception {
        FileItemHeadersImpl mutableFileItemHeaders = new FileItemHeadersImpl();
        mutableFileItemHeaders.addHeader("Content-Disposition", "form-data; name=\"FileItem\"; filename=\"file1.txt\"");
        mutableFileItemHeaders.addHeader("Content-Type", "text/plain");
        mutableFileItemHeaders.addHeader("TestHeader", "headerValue1");
        mutableFileItemHeaders.addHeader("TestHeader", "headerValue2");
        mutableFileItemHeaders.addHeader("TestHeader", "headerValue3");
        mutableFileItemHeaders.addHeader("testheader", "headerValue4");
        Iterator headerNameIterator = mutableFileItemHeaders.getHeaderNames();
        Assertions.assertEquals((Object)"content-disposition", headerNameIterator.next());
        Assertions.assertEquals((Object)"content-type", headerNameIterator.next());
        Assertions.assertEquals((Object)"testheader", headerNameIterator.next());
        Assertions.assertFalse((boolean)headerNameIterator.hasNext());
        Assertions.assertEquals((Object)mutableFileItemHeaders.getHeader("Content-Disposition"), (Object)"form-data; name=\"FileItem\"; filename=\"file1.txt\"");
        Assertions.assertEquals((Object)mutableFileItemHeaders.getHeader("Content-Type"), (Object)"text/plain");
        Assertions.assertEquals((Object)mutableFileItemHeaders.getHeader("content-type"), (Object)"text/plain");
        Assertions.assertEquals((Object)mutableFileItemHeaders.getHeader("TestHeader"), (Object)"headerValue1");
        Assertions.assertNull((Object)mutableFileItemHeaders.getHeader("DummyHeader"));
        Iterator headerValueEnumeration = mutableFileItemHeaders.getHeaders("Content-Type");
        Assertions.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assertions.assertEquals(headerValueEnumeration.next(), (Object)"text/plain");
        Assertions.assertFalse((boolean)headerValueEnumeration.hasNext());
        headerValueEnumeration = mutableFileItemHeaders.getHeaders("content-type");
        Assertions.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assertions.assertEquals(headerValueEnumeration.next(), (Object)"text/plain");
        Assertions.assertFalse((boolean)headerValueEnumeration.hasNext());
        headerValueEnumeration = mutableFileItemHeaders.getHeaders("TestHeader");
        Assertions.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assertions.assertEquals(headerValueEnumeration.next(), (Object)"headerValue1");
        Assertions.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assertions.assertEquals(headerValueEnumeration.next(), (Object)"headerValue2");
        Assertions.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assertions.assertEquals(headerValueEnumeration.next(), (Object)"headerValue3");
        Assertions.assertTrue((boolean)headerValueEnumeration.hasNext());
        Assertions.assertEquals(headerValueEnumeration.next(), (Object)"headerValue4");
        Assertions.assertFalse((boolean)headerValueEnumeration.hasNext());
        headerValueEnumeration = mutableFileItemHeaders.getHeaders("DummyHeader");
        Assertions.assertFalse((boolean)headerValueEnumeration.hasNext());
    }
}

