/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.io.input.ReversedLinesFileReaderParamBlockSizeTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ReversedLinesFileReaderSimpleTest {
    ReversedLinesFileReaderSimpleTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.ReversedLinesFileReaderParamBlockSizeTest#blockSizes"})
    @Disabled
    void testEmptyFirstLine(int blockSize) throws Exception {
        File testFileEmptyFirstLine = TestResources.getFile("/empty-first-line.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFileEmptyFirstLine, 10, StandardCharsets.US_ASCII.name());){
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("test2", reversedLinesFileReader.readLine());
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("", reversedLinesFileReader.readLine());
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("test1", reversedLinesFileReader.readLine());
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("", reversedLinesFileReader.readLine());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.ReversedLinesFileReaderParamBlockSizeTest#blockSizes"})
    void testFileSizeIsExactMultipleOfBlockSize(int blockSize) throws URISyntaxException, IOException {
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, blockSize, StandardCharsets.ISO_8859_1.name());){
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("987654321", reversedLinesFileReader.readLine());
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("123456789", reversedLinesFileReader.readLine());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.ReversedLinesFileReaderParamBlockSizeTest#blockSizes"})
    void testLineCount(int blockSize) throws URISyntaxException, IOException {
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, blockSize, StandardCharsets.ISO_8859_1.name());){
            Assertions.assertThrows(IllegalArgumentException.class, () -> reversedLinesFileReader.readLines(-1));
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(0).isEmpty());
            List lines = reversedLinesFileReader.readLines(2);
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("987654321", (String)lines.get(0));
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("123456789", (String)lines.get(1));
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(0).isEmpty());
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(10000).isEmpty());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.ReversedLinesFileReaderParamBlockSizeTest#blockSizes"})
    void testToString(int blockSize) throws URISyntaxException, IOException {
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, blockSize, StandardCharsets.ISO_8859_1.name());){
            Assertions.assertThrows(IllegalArgumentException.class, () -> reversedLinesFileReader.toString(-1));
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(0).isEmpty());
            String lines = reversedLinesFileReader.toString(2);
            Assertions.assertEquals((Object)("123456789" + System.lineSeparator() + "987654321" + System.lineSeparator()), (Object)lines);
            Assertions.assertTrue((boolean)reversedLinesFileReader.toString(0).isEmpty());
            Assertions.assertTrue((boolean)reversedLinesFileReader.toString(10000).isEmpty());
        }
    }

    @Test
    void testUnsupportedEncodingBig5() throws URISyntaxException {
        File testFileEncodingBig5 = TestResources.getFile("/test-file-empty.bin");
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEncodingBig5, 8192, "Big5").close());
    }

    @Test
    void testUnsupportedEncodingUTF16() throws URISyntaxException {
        File testFileEmpty = TestResources.getFile("/test-file-empty.bin");
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEmpty, 8192, StandardCharsets.UTF_16.name()).close());
    }
}

