/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComposePermissionsTest
extends JexlTestCase {
    static final String SAMPLE_JSON = "src/test/scripts/sample.json";

    public ComposePermissionsTest() {
        super("PermissionsTest");
    }

    void runComposePermissions(JexlPermissions p) throws Exception {
        Object json;
        String check = "http://example.com/content.jpg";
        File jsonFile = new File(SAMPLE_JSON);
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(jsonFile);){
            json = gson.fromJson((Reader)reader, Object.class);
            Assertions.assertNotNull((Object)json);
        }
        JexlEngine j0 = ComposePermissionsTest.createEngine(false, p);
        JexlScript s0 = j0.createScript("json.pageInfo.pagePic", new String[]{"json"});
        Object r0 = s0.execute(null, new Object[]{json});
        Assertions.assertEquals((Object)"http://example.com/content.jpg", (Object)r0);
        JexlEngine j1 = ComposePermissionsTest.createEngine(false, p.compose(new String[]{"com.google.gson.internal {}"}));
        JexlScript s1 = j1.createScript("json.pageInfo.pagePic", new String[]{"json"});
        JexlException.Property xproperty = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> s1.execute(null, new Object[]{json}));
        Assertions.assertEquals((Object)"pageInfo", (Object)xproperty.getProperty());
        j1 = ComposePermissionsTest.createEngine(false, p.compose(new String[]{"com.google.gson.internal { LinkedTreeMap {} }"}));
        JexlScript s2 = j1.createScript("json.pageInfo.pagePic", new String[]{"json"});
        xproperty = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> s2.execute(null, new Object[]{json}));
        Assertions.assertEquals((Object)"pageInfo", (Object)xproperty.getProperty());
        j1 = ComposePermissionsTest.createEngine(false, JexlPermissions.RESTRICTED);
        JexlScript s3 = j1.createScript("json.pageInfo.pagePic", new String[]{"json"});
        s3.execute(null, new Object[]{json});
        Assertions.assertEquals((Object)"http://example.com/content.jpg", (Object)r0);
    }

    @Test
    public void testComposePermissions() throws Exception {
        this.runComposePermissions(JexlPermissions.UNRESTRICTED);
    }

    @Test
    public void testComposePermissions1() throws Exception {
        this.runComposePermissions((JexlPermissions)new JexlPermissions.Delegate(JexlPermissions.UNRESTRICTED){

            public String toString() {
                return "delegate:" + this.base.toString();
            }
        });
    }

    @Test
    public void testComposePermissions2() throws Exception {
        this.runComposePermissions((JexlPermissions)new JexlPermissions.ClassPermissions(JexlPermissions.UNRESTRICTED, Collections.emptySet()));
    }
}

