/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Script;
import org.apache.commons.jexl3.internal.Source;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.JexlScriptParser;
import org.apache.commons.jexl3.parser.Parser;

public class Util {
    private static String checkEquals(JexlNode lhs, JexlNode rhs) {
        if (lhs != rhs) {
            ArrayList<JexlNode> lhsl = Util.flatten(lhs);
            ArrayList<JexlNode> rhsl = Util.flatten(rhs);
            if (lhsl.size() != rhsl.size()) {
                return "size: " + lhsl.size() + " != " + rhsl.size();
            }
            for (int n = 0; n < lhsl.size(); ++n) {
                lhs = lhsl.get(n);
                rhs = rhsl.get(n);
                if (lhs.getClass() != rhs.getClass()) {
                    return "class: " + lhs.getClass() + " != " + rhs.getClass();
                }
                String lhss = lhs.toString();
                String rhss = rhs.toString();
                if (lhss == null && rhss != null || lhss != null && rhss == null) {
                    return "image: " + lhss + " != " + rhss;
                }
                if (lhss == null || lhss.equals(rhss)) continue;
                return "image: " + lhss + " != " + rhss;
            }
        }
        return null;
    }

    public static void debuggerCheck(JexlEngine ijexl) throws Exception {
        Engine jexl = (Engine)ijexl;
        if (jexl == null || jexl.cache == null) {
            return;
        }
        Engine jdbg = new Engine();
        JexlScriptParser jexlp = jdbg.parser;
        if (!(jexlp instanceof Parser)) {
            return;
        }
        Parser parser = (Parser)jexlp;
        parser.allowRegisters(true);
        Debugger dbg = new Debugger();
        for (Map.Entry entry : jexl.cache.entries()) {
            JexlNode node = (JexlNode)entry.getValue();
            dbg.debug(node);
            String expressiondbg = dbg.toString();
            JexlFeatures features = ((Source)entry.getKey()).getFeatures();
            try {
                Script exprdbg = jdbg.createScript(features, null, expressiondbg, new String[0]);
                ASTJexlScript root = exprdbg.script;
                while (root.jjtGetParent() != null) {
                    root = root.jjtGetParent();
                }
                String reason = Util.checkEquals((JexlNode)root, node);
                if (reason == null) continue;
                throw new IllegalStateException("check equal failed: " + expressiondbg + " /**** " + reason + " **** */ " + entry.getKey());
            }
            catch (JexlException xjexl) {
                throw new IllegalStateException("check parse failed: " + expressiondbg + " /*********/ " + entry.getKey(), xjexl);
            }
        }
    }

    protected static ArrayList<JexlNode> flatten(JexlNode node) {
        ArrayList<JexlNode> list = new ArrayList<JexlNode>();
        Util.flatten(list, node);
        return list;
    }

    private static void flatten(List<JexlNode> list, JexlNode node) {
        int nc = node.jjtGetNumChildren();
        list.add(node);
        for (int c = 0; c < nc; ++c) {
            Util.flatten(list, node.jjtGetChild(c));
        }
    }

    protected static String flattenedStr(JexlScript e) {
        return "";
    }

    private static String indent(JexlNode node) {
        StringBuilder strb = new StringBuilder();
        while (node != null) {
            strb.append("  ");
            node = node.jjtGetParent();
        }
        return strb.toString();
    }

    private String flattenedStr(JexlNode node) {
        ArrayList<JexlNode> flattened = Util.flatten(node);
        StringBuilder strb = new StringBuilder();
        for (JexlNode flat : flattened) {
            strb.append(Util.indent(flat));
            strb.append(flat.getClass().getSimpleName());
            String sflat = flat.toString();
            if (sflat != null) {
                strb.append(" = ");
                strb.append(sflat);
            }
            strb.append("\n");
        }
        return strb.toString();
    }
}

