/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.junit;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.junit.jupiter.api.Assertions;

public class Asserter {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final JexlEvalContext context = new JexlEvalContext(this.variables);
    private final JexlEngine engine;

    public Asserter(JexlEngine jexl) {
        this.engine = jexl;
    }

    public void assertExpression(String expression, Object expected, Object ... args) throws Exception {
        JexlScript exp = this.engine.createScript(expression);
        Object value = exp.execute((JexlContext)this.context, args);
        if (expected instanceof BigDecimal) {
            JexlArithmetic jexla = this.engine.getArithmetic();
            Assertions.assertEquals((int)0, (int)((BigDecimal)expected).compareTo(jexla.toBigDecimal(value)), () -> "expression: " + expression);
        } else if (expected instanceof BigInteger) {
            JexlArithmetic jexla = this.engine.getArithmetic();
            Assertions.assertEquals((int)0, (int)((BigInteger)expected).compareTo(jexla.toBigInteger(value)), () -> "expression: " + expression);
        } else if (expected != null && value != null) {
            if (expected.getClass().isArray() && value.getClass().isArray()) {
                int esz = Array.getLength(expected);
                int vsz = Array.getLength(value);
                String report = "expression: " + expression;
                Assertions.assertEquals((int)esz, (int)vsz, () -> report + ", array size");
                for (int i = 0; i < vsz; ++i) {
                    Assertions.assertEquals((Object)Array.get(expected, i), (Object)Array.get(value, i), (String)(report + ", value@[]" + i));
                }
            } else {
                Assertions.assertEquals((Object)expected, (Object)value, () -> "expression: " + expression + ", " + expected.getClass().getSimpleName() + " ?= " + value.getClass().getSimpleName());
            }
        } else {
            Assertions.assertEquals((Object)expected, (Object)value, () -> "expression: " + expression);
        }
    }

    public void failExpression(String expression, String matchException) throws Exception {
        this.failExpression(expression, matchException, String::matches);
    }

    public void failExpression(String expression, String matchException, BiPredicate<String, String> predicate) throws Exception {
        JexlException xjexl = (JexlException)Assertions.assertThrows(JexlException.class, () -> this.engine.createScript(expression).execute((JexlContext)this.context));
        if (matchException != null && !predicate.test(xjexl.getMessage(), matchException)) {
            Assertions.fail((String)("expression: " + expression + ", expected: " + matchException + ", got " + xjexl.getMessage()));
        }
    }

    public JexlContext getContext() {
        return this.context;
    }

    public JexlEngine getEngine() {
        return this.engine;
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object removeVariable(String name) {
        return this.variables.remove(name);
    }

    public void setSilent(boolean silent) {
        this.context.getEngineOptions().setSilent(silent);
    }

    public void setStrict(boolean s) {
        this.context.getEngineOptions().setStrict(s);
    }

    public void setStrict(boolean es, boolean as) {
        this.context.getEngineOptions().setStrict(es);
        this.context.getEngineOptions().setStrictArithmetic(as);
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }
}

