/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGenericObjectPoolConfig {
    private GenericObjectPoolConfig<TestObject> config;

    @BeforeEach
    void beforeEach() {
        this.config = new GenericObjectPoolConfig();
    }

    @Test
    void testSetEvictionPolicy() {
        TestEvictionPolicy evictionPolicy = new TestEvictionPolicy();
        this.config.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        Assertions.assertEquals((Object)evictionPolicy, (Object)this.config.getEvictionPolicy());
    }

    @Test
    void testSetEvictionPolicyClassName() {
        this.config.setEvictionPolicyClassName(TestEvictionPolicy.class.getName());
        Assertions.assertEquals((Object)TestEvictionPolicy.class.getName(), (Object)this.config.getEvictionPolicyClassName());
    }

    @Test
    void testSetEvictorShutdownTimeoutDuration() {
        this.config.setEvictorShutdownTimeout(Duration.ofSeconds(10L));
        Assertions.assertEquals((Object)Duration.ofSeconds(10L), (Object)this.config.getEvictorShutdownTimeoutDuration());
    }

    @Test
    void testSetEvictorShutdownTimeoutMillis() {
        this.config.setEvictorShutdownTimeoutMillis(100000L);
        Assertions.assertEquals((long)100000L, (long)this.config.getEvictorShutdownTimeoutMillis());
    }

    @Test
    void testSetJmxNamePrefix() {
        this.config.setJmxNamePrefix("prefix");
        Assertions.assertEquals((Object)"prefix", (Object)this.config.getJmxNamePrefix());
    }

    @Test
    void testSetMaxWaitMillis() {
        this.config.setMaxWaitMillis(100000L);
        Assertions.assertEquals((long)100000L, (long)this.config.getMaxWaitMillis());
    }

    @Test
    void testSetSoftMinEvictableIdleDuration() {
        this.config.setSoftMinEvictableIdleDuration(Duration.ofSeconds(10L));
        Assertions.assertEquals((Object)Duration.ofSeconds(10L), (Object)this.config.getSoftMinEvictableIdleDuration());
    }

    @Test
    void testSetSoftMinEvictableIdleTime() {
        this.config.setSoftMinEvictableIdleTime(Duration.ofSeconds(10L));
        Assertions.assertEquals((Object)Duration.ofSeconds(10L), (Object)this.config.getSoftMinEvictableIdleTime());
    }

    @Test
    void testSetSoftMinEvictableIdleTimeMillis() {
        this.config.setSoftMinEvictableIdleTimeMillis(100000L);
        Assertions.assertEquals((long)100000L, (long)this.config.getSoftMinEvictableIdleTimeMillis());
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)this.config.toString().isEmpty());
    }

    @Test
    void testToStringAppendFields() {
        StringBuilder builder = new StringBuilder();
        this.config.toStringAppendFields(builder);
        Assertions.assertFalse((boolean)builder.toString().isEmpty());
    }

    public static final class TestEvictionPolicy
    implements EvictionPolicy<TestObject> {
        public boolean evict(EvictionConfig config, PooledObject<TestObject> underTest, int idleCount) {
            return false;
        }
    }

    public static final class TestObject {
    }
}

