/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.properties.SortedProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.release.plugin.SharedFunctions;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="detach-distributions", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, aggregator=true)
public class CommonsDistributionDetachmentMojo
extends AbstractMojo {
    private static final Set<String> ARTIFACT_TYPES_TO_DETACH;
    private final List<Artifact> detachedArtifacts = new ArrayList<Artifact>();
    private final SortedProperties artifactSha512s = new SortedProperties();
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", property="commons.outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="", property="commons.distSvnStagingUrl")
    private String distSvnStagingUrl;
    @Parameter(defaultValue="false", property="commons.release.isDistModule")
    private Boolean isDistModule;

    private void copyRemovedArtifactsToWorkingDirectory() throws MojoExecutionException {
        String wdAbsolutePath = this.workingDirectory.getAbsolutePath();
        this.getLog().info((CharSequence)("Copying " + this.detachedArtifacts.size() + " detached artifacts to working directory " + wdAbsolutePath));
        for (Artifact artifact : this.detachedArtifacts) {
            File artifactFile = artifact.getFile();
            StringBuilder copiedArtifactAbsolutePath = new StringBuilder(wdAbsolutePath);
            copiedArtifactAbsolutePath.append("/");
            copiedArtifactAbsolutePath.append(artifactFile.getName());
            File copiedArtifact = new File(copiedArtifactAbsolutePath.toString());
            this.getLog().info((CharSequence)("Copying: " + artifactFile.getName()));
            SharedFunctions.copyFile(this.getLog(), artifactFile, copiedArtifact);
        }
    }

    public void execute() throws MojoExecutionException {
        if (!this.isDistModule.booleanValue()) {
            this.getLog().info((CharSequence)"This module is marked as a non distribution or assembly module, and the plugin will not run.");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.distSvnStagingUrl)) {
            this.getLog().warn((CharSequence)"commons.distSvnStagingUrl is not set, the commons-release-plugin will not run.");
            return;
        }
        this.getLog().info((CharSequence)"Detaching Assemblies");
        for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
            this.putAttachedArtifactInSha512Map(attachedArtifact);
            if (!ARTIFACT_TYPES_TO_DETACH.contains(attachedArtifact.getType())) continue;
            this.detachedArtifacts.add(attachedArtifact);
        }
        if (this.detachedArtifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Current project contains no distributions. Not executing.");
            return;
        }
        try {
            this.project.getAttachedArtifacts().removeAll(this.detachedArtifacts);
        }
        catch (UnsupportedOperationException e) {
            ArrayList arrayList = new ArrayList(this.project.getAttachedArtifacts());
            arrayList.removeAll(this.detachedArtifacts);
            try {
                MethodUtils.invokeMethod((Object)this.project, (boolean)true, (String)"setAttachedArtifacts", (Object[])new Object[]{arrayList});
            }
            catch (ReflectiveOperationException roe) {
                throw new MojoExecutionException((Throwable)roe);
            }
        }
        if (!this.workingDirectory.exists()) {
            SharedFunctions.initDirectory(this.getLog(), this.workingDirectory);
        }
        this.writeAllArtifactsInSha512PropertiesFile();
        this.copyRemovedArtifactsToWorkingDirectory();
        this.getLog().info((CharSequence)"");
        this.hashArtifacts();
    }

    private String getArtifactKey(Artifact artifact) {
        return artifact.getFile().getName();
    }

    private String getSha512FilePath(File directory, File file) {
        StringBuilder buffer = new StringBuilder(directory.getAbsolutePath());
        buffer.append("/");
        buffer.append(file.getName());
        buffer.append(".sha512");
        return buffer.toString();
    }

    private void hashArtifacts() throws MojoExecutionException {
        for (Artifact artifact : this.detachedArtifacts) {
            if (StringUtils.toRootLowerCase((String)artifact.getFile().getName()).contains("asc")) continue;
            String artifactKey = this.getArtifactKey(artifact);
            try {
                String digest = this.artifactSha512s.getProperty(artifactKey.toString());
                this.getLog().info((CharSequence)(artifact.getFile().getName() + " sha512: " + digest));
                try (PrintWriter printWriter = new PrintWriter(this.getSha512FilePath(this.workingDirectory, artifact.getFile()));){
                    printWriter.println(digest);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not sign file: " + artifact.getFile().getName(), (Exception)e);
            }
        }
    }

    private void putAttachedArtifactInSha512Map(Artifact artifact) throws MojoExecutionException {
        block8: {
            try {
                String artifactKey = this.getArtifactKey(artifact);
                if (artifactKey.endsWith(".asc")) break block8;
                try (InputStream fis = Files.newInputStream(artifact.getFile().toPath(), new OpenOption[0]);){
                    this.artifactSha512s.put((Object)artifactKey, (Object)DigestUtils.sha512Hex((InputStream)fis));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not find artifact signature for: " + artifact.getArtifactId() + "-" + artifact.getClassifier() + "-" + artifact.getVersion() + " type: " + artifact.getType(), (Exception)e);
            }
        }
    }

    private void writeAllArtifactsInSha512PropertiesFile() throws MojoExecutionException {
        File propertiesFile = new File(this.workingDirectory, "sha512.properties");
        this.getLog().info((CharSequence)("Writing " + propertiesFile));
        try (OutputStream fileWriter = Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]);){
            this.artifactSha512s.store(fileWriter, "Release SHA-512s");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure to write SHA-512's", (Exception)e);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("zip");
        hashSet.add("tar.gz");
        hashSet.add("zip.asc");
        hashSet.add("tar.gz.asc");
        ARTIFACT_TYPES_TO_DETACH = Collections.unmodifiableSet(hashSet);
    }
}

