/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

final class LXMSupport {
    static final long M64 = -3372029247567499371L;
    static final long M64P = -8276630626270969855L;
    static final long C64P = 1614853376254672896L;
    static final long M128L = -3024805186288043011L;
    static final long M128PH = 3598791670994785524L;
    static final long C128PH = 6995105244622518211L;
    static final long GOLDEN_RATIO_64 = -7046029254386353131L;
    private static final long INT_TO_UNSIGNED_BYTE_MASK = 0xFFFFFFFFL;

    private LXMSupport() {
    }

    static long lea64(long x) {
        x = (x ^ x >>> 32) * -2685821657736338717L;
        x = (x ^ x >>> 32) * -2685821657736338717L;
        return x ^ x >>> 32;
    }

    static long unsignedMultiplyHigh(long value1, long value2) {
        long a = value1 >>> 32;
        long b = value1 & 0xFFFFFFFFL;
        long x = value2 >>> 32;
        long y = value2 & 0xFFFFFFFFL;
        long by = b * y;
        long bx = b * x;
        long ay = a * y;
        long ax = a * x;
        long carry = (by >>> 32) + (bx & 0xFFFFFFFFL) + ay;
        return (bx >>> 32) + (carry >>> 32) + ax;
    }

    static long unsignedAddHigh(long left, long right) {
        return (left >>> 1) + (right >>> 1) + (left & 1L) >>> -1;
    }
}

