/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.ASTVisitor;
import antlr.collections.AST;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.bind.JAXBException;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.corba.common.WSDLUtils;
import org.apache.cxf.tools.corba.processors.idl.DeferredActionCollection;
import org.apache.cxf.tools.corba.processors.idl.DefinitionVisitor;
import org.apache.cxf.tools.corba.processors.idl.ModuleToNSMapper;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopeNameCollection;
import org.apache.cxf.tools.corba.processors.idl.WSDLSchemaManager;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public final class WSDLASTVisitor
implements ASTVisitor {
    Definition definition;
    XmlSchema schema;
    XmlSchemaCollection schemas;
    TypeMappingType typeMap;
    ScopeNameCollection scopedNames;
    ScopeNameCollection recursionList;
    DeferredActionCollection deferredActions;
    String targetNamespace;
    private boolean declaredWSAImport;
    private boolean supportPolymorphicFactories;
    private XmlSchemaType sequenceOctetType;
    private boolean boundedStringOverride;
    private String idlFile;
    private String outputDir;
    private String importSchemaFilename;
    private boolean schemaGenerated;
    private ModuleToNSMapper moduleToNSMapper;
    private WSDLSchemaManager manager = new WSDLSchemaManager();
    private Map<Scope, List<Scope>> inheritScopeMap;
    private String pragmaPrefix;

    public WSDLASTVisitor(String tns, String schemans, String corbatypemaptns, String pragmaPrefix) throws WSDLException, JAXBException {
        this.definition = this.manager.createWSDLDefinition(tns);
        this.inheritScopeMap = new TreeMap<Scope, List<Scope>>();
        this.targetNamespace = tns;
        this.schemas = new XmlSchemaCollection();
        this.scopedNames = new ScopeNameCollection();
        this.deferredActions = new DeferredActionCollection();
        if (schemans == null) {
            schemans = tns;
        }
        this.schema = this.manager.createXmlSchemaForDefinition(this.definition, schemans, this.schemas);
        this.declaredWSAImport = false;
        this.typeMap = this.manager.createCorbaTypeMap(this.definition, corbatypemaptns);
        this.sequenceOctetType = this.schemas.getTypeByQName(Constants.XSD_BASE64);
        this.setBoundedStringOverride(false);
        this.moduleToNSMapper = new ModuleToNSMapper();
        this.setPragmaPrefix(pragmaPrefix);
    }

    public WSDLASTVisitor(String tns, String schemans, String corbatypemaptns) throws WSDLException, JAXBException {
        this(tns, schemans, corbatypemaptns, null);
    }

    public void visit(AST node) {
        while (node != null) {
            Scope rootScope = new Scope();
            DefinitionVisitor definitionVisitor = new DefinitionVisitor(rootScope, this.definition, this.schema, this);
            definitionVisitor.visit(node);
            node = node.getNextSibling();
        }
        try {
            this.manager.attachSchemaToWSDL(this.definition, this.schema, this.isSchemaGenerated());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setSchemaGenerated(boolean value) {
        this.schemaGenerated = value;
    }

    public boolean isSchemaGenerated() {
        return this.schemaGenerated;
    }

    public void updateSchemaNamespace(String name) throws Exception {
        this.schema.setTargetNamespace(name);
    }

    public void setQualified(boolean qualified) throws Exception {
        if (qualified) {
            XmlSchemaForm form = XmlSchemaForm.QUALIFIED;
            this.schema.setAttributeFormDefault(form);
            this.schema.setElementFormDefault(form);
        }
    }

    public void setSupportPolymorphicFactories(boolean support) throws Exception {
        this.supportPolymorphicFactories = support;
    }

    public boolean getSupportPolymorphicFactories() {
        return this.supportPolymorphicFactories;
    }

    public void setIdlFile(String idl) {
        this.idlFile = idl;
    }

    public String getIdlFile() {
        return this.idlFile;
    }

    public Map<Scope, List<Scope>> getInheritedScopeMap() {
        return this.inheritScopeMap;
    }

    public void setOutputDir(String outDir) {
        this.outputDir = outDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public WSDLSchemaManager getManager() {
        return this.manager;
    }

    public XmlSchema getSchema() {
        return this.schema;
    }

    public XmlSchemaCollection getSchemas() {
        return this.schemas;
    }

    public ScopeNameCollection getScopedNames() {
        return this.scopedNames;
    }

    public ScopeNameCollection getRecursionList() {
        return this.recursionList;
    }

    public DeferredActionCollection getDeferredActions() {
        return this.deferredActions;
    }

    public TypeMappingType getTypeMap() {
        return this.typeMap;
    }

    public XmlSchemaType getSequenceOctetType() {
        return this.sequenceOctetType;
    }

    public void setImportSchema(String filename) {
        this.importSchemaFilename = filename;
    }

    public String getImportSchemaFilename() {
        return this.importSchemaFilename;
    }

    public void setSequenceOctetType(String type) throws Exception {
        XmlSchemaType stype;
        if (type.equals("base64Binary")) {
            stype = this.schemas.getTypeByQName(Constants.XSD_BASE64);
        } else if (type.equals("hexBinary")) {
            stype = this.schemas.getTypeByQName(Constants.XSD_HEXBIN);
        } else {
            throw new ToolException("WSDLASTVisitor: Invalid XmlSchemaType specified for idl:sequence<octet> mapping.");
        }
        this.sequenceOctetType = stype;
    }

    public boolean getBoundedStringOverride() {
        return this.boundedStringOverride;
    }

    public void setBoundedStringOverride(boolean value) {
        this.boundedStringOverride = value;
    }

    public Binding[] getCorbaBindings() {
        ArrayList<Binding> result = new ArrayList<Binding>();
        Map bindings = CastUtils.cast((Map)this.definition.getBindings());
        block0: for (Binding binding : bindings.values()) {
            List extElements = CastUtils.cast((List)binding.getExtensibilityElements());
            for (int i = 0; i < extElements.size(); ++i) {
                ExtensibilityElement el = (ExtensibilityElement)extElements.get(i);
                if (!el.getElementType().equals(CorbaConstants.NE_CORBA_BINDING)) continue;
                result.add(binding);
                continue block0;
            }
        }
        return result.toArray(new Binding[0]);
    }

    public boolean writeDefinition(Writer writer) throws Exception {
        this.writeDefinition(this.definition, writer);
        return true;
    }

    public boolean writeDefinition(Definition def, Writer writer) throws Exception {
        WSDLUtils.writeWSDL(def, writer);
        return true;
    }

    public boolean writeSchemaDefinition(Definition definit, Writer writer) throws Exception {
        Definition def = this.manager.createWSDLDefinition(this.targetNamespace + "-types");
        def.createTypes();
        def.setTypes(definit.getTypes());
        WSDLUtils.writeSchema(def, writer);
        return true;
    }

    public boolean writeSchema(XmlSchema schemaRef, Writer writer) throws Exception {
        Definition defn = this.manager.createWSDLDefinition(schemaRef.getTargetNamespace());
        this.manager.attachSchemaToWSDL(defn, schemaRef, true);
        this.writeSchemaDefinition(defn, writer);
        return true;
    }

    public boolean writeDefinitions(Writer writer, Writer schemaWriter, Writer logicalWriter, Writer physicalWriter, String schemaFilename, String logicalFile, String physicalFile) throws Exception {
        Definition logicalDef = this.getLogicalDefinition(schemaFilename, schemaWriter);
        Definition physicalDef = (schemaFilename != null || this.importSchemaFilename != null) && logicalFile == null && physicalFile == null ? this.getPhysicalDefinition(logicalDef, true) : this.getPhysicalDefinition(logicalDef, false);
        if (logicalFile != null && physicalFile == null) {
            this.writeDefinition(logicalDef, logicalWriter);
            this.manager.addWSDLDefinitionImport(physicalDef, logicalDef, "logicaltns", logicalFile);
            this.writeDefinition(physicalDef, writer);
        } else if (logicalFile != null && physicalFile != null) {
            this.writeDefinition(logicalDef, logicalWriter);
            this.manager.addWSDLDefinitionImport(physicalDef, logicalDef, "logicaltns", logicalFile);
            this.writeDefinition(physicalDef, physicalWriter);
        } else if (logicalFile == null && physicalFile != null) {
            this.writeDefinition(logicalDef, writer);
            this.manager.addWSDLDefinitionImport(physicalDef, logicalDef, "logicaltns", this.getIdlFile());
            this.writeDefinition(physicalDef, physicalWriter);
        } else if (logicalFile == null && physicalFile == null && (schemaFilename != null || this.importSchemaFilename != null)) {
            this.writeDefinition(physicalDef, writer);
        } else if (logicalFile == null && physicalFile == null && schemaFilename == null) {
            this.writeDefinition(this.definition, writer);
        }
        return true;
    }

    private Definition getLogicalDefinition(String schemaFilename, Writer schemaWriter) throws WSDLException, JAXBException, Exception {
        Definition def = this.manager.createWSDLDefinition(this.targetNamespace);
        if (schemaFilename != null) {
            this.writeSchemaDefinition(this.definition, schemaWriter);
            this.manager.addWSDLSchemaImport(def, this.schema.getTargetNamespace(), schemaFilename);
        } else if (this.importSchemaFilename == null) {
            Types types = this.definition.getTypes();
            def.setTypes(types);
        } else {
            this.manager.addWSDLSchemaImport(def, this.schema.getTargetNamespace(), this.importSchemaFilename);
        }
        Collection portTypes = CastUtils.cast(this.definition.getAllPortTypes().values());
        for (Object port : portTypes) {
            def.addPortType((PortType)port);
        }
        Collection messages = CastUtils.cast(this.definition.getMessages().values());
        for (Object msg : messages) {
            def.addMessage((Message)msg);
        }
        Collection namespaces = CastUtils.cast(this.definition.getNamespaces().values());
        for (String namespace : namespaces) {
            String prefix = this.definition.getPrefix(namespace);
            if (!"corba".equals(prefix)) {
                def.addNamespace(prefix, namespace);
                continue;
            }
            def.removeNamespace(prefix);
        }
        Collection imports = CastUtils.cast(this.definition.getImports().values());
        for (Import importType : imports) {
            def.addImport(importType);
        }
        def.setDocumentationElement(this.definition.getDocumentationElement());
        def.setDocumentBaseURI(this.definition.getDocumentBaseURI());
        return def;
    }

    private Definition getPhysicalDefinition(Definition logicalDef, boolean schemaOnly) throws WSDLException, JAXBException {
        Definition def = schemaOnly ? logicalDef : this.manager.createWSDLDefinition(this.targetNamespace);
        Collection namespaces = CastUtils.cast(this.definition.getNamespaces().values());
        for (Object namespace : namespaces) {
            String prefix = this.definition.getPrefix((String)namespace);
            def.addNamespace(prefix, (String)namespace);
        }
        Collection bindings = CastUtils.cast(this.definition.getAllBindings().values());
        for (Object binding : bindings) {
            def.addBinding((Binding)binding);
        }
        Collection services = CastUtils.cast(this.definition.getAllServices().values());
        for (Service service : services) {
            def.addService(service);
        }
        List extns = CastUtils.cast((List)this.definition.getExtensibilityElements());
        for (ExtensibilityElement ext : extns) {
            def.addExtensibilityElement(ext);
        }
        def.setExtensionRegistry(this.definition.getExtensionRegistry());
        return def;
    }

    public boolean getDeclaredWSAImport() {
        return this.declaredWSAImport;
    }

    public void setDeclaredWSAImport(boolean declaredImport) {
        this.declaredWSAImport = declaredImport;
    }

    public void setModuleToNSMapping(Map<String, String> map) {
        this.moduleToNSMapper.setDefaultMapping(false);
        this.moduleToNSMapper.setUserMapping(map);
    }

    public ModuleToNSMapper getModuleToNSMapper() {
        return this.moduleToNSMapper;
    }

    public void setExcludedModules(Map<String, List<String>> modules) {
        this.moduleToNSMapper.setExcludedModuleMap(modules);
    }

    public void setPragmaPrefix(String pragmaPrefix) {
        this.pragmaPrefix = pragmaPrefix;
    }

    public String getPragmaPrefix() {
        return this.pragmaPrefix;
    }
}

