/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.metrics.MetricsContext;
import org.apache.cxf.metrics.interceptors.CountingInputStream;
import org.apache.cxf.metrics.interceptors.CountingOutputStream;

public class ExchangeMetrics {
    Deque<MetricsContext> contexts = new LinkedList<MetricsContext>();
    Exchange exchange;
    boolean started;
    long startTime = -1L;

    public ExchangeMetrics(Exchange e) {
        this.exchange = e;
    }

    public ExchangeMetrics addContext(MetricsContext ctx) {
        if (!this.contexts.contains(ctx)) {
            this.contexts.addLast(ctx);
            if (this.started) {
                ctx.start(this.exchange);
            }
        }
        return this;
    }

    public void start() {
        this.started = true;
        this.startTime = System.nanoTime();
        for (MetricsContext ctx : this.contexts) {
            ctx.start(this.exchange);
        }
    }

    public void stop() {
        CountingOutputStream out;
        this.started = false;
        if (this.startTime == -1L) {
            return;
        }
        CountingInputStream in = (CountingInputStream)this.exchange.get(CountingInputStream.class);
        long inSize = -1L;
        long outSize = -1L;
        if (in != null) {
            inSize = in.getCount();
        }
        if ((out = (CountingOutputStream)this.exchange.get(CountingOutputStream.class)) != null) {
            outSize = out.getCount();
        }
        long l = System.nanoTime() - this.startTime;
        for (MetricsContext ctx : this.contexts) {
            ctx.stop(l, inSize, outSize, this.exchange);
        }
    }
}

