/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateQueueMessage
extends PacketImpl {
    protected SimpleString address;
    protected SimpleString queueName;
    protected SimpleString filterString;
    protected boolean durable;
    protected boolean temporary;
    protected boolean requiresResponse;

    public CreateQueueMessage(QueueConfiguration queueConfiguration, boolean requiresResponse) {
        this(queueConfiguration.getAddress(), queueConfiguration.getName(), queueConfiguration.getFilterString(), queueConfiguration.isDurable(), queueConfiguration.isTemporary(), requiresResponse);
    }

    public CreateQueueMessage(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.temporary = temporary;
        this.requiresResponse = requiresResponse;
    }

    public CreateQueueMessage() {
        super((byte)34);
    }

    public CreateQueueMessage(byte createQueueMessageV2) {
        super(createQueueMessageV2);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", address=" + String.valueOf(this.address));
        sb.append(", queueName=" + String.valueOf(this.queueName));
        sb.append(", filterString=" + String.valueOf(this.filterString));
        sb.append(", durable=" + this.durable);
        sb.append(", temporary=" + this.temporary);
        return sb.toString();
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void setAddress(SimpleString address) {
        this.address = address;
    }

    public void setQueueName(SimpleString queueName) {
        this.queueName = queueName;
    }

    public void setFilterString(SimpleString filterString) {
        this.filterString = filterString;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.temporary);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.temporary = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.address, this.durable, this.filterString, this.queueName, this.requiresResponse, this.temporary);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateQueueMessage)) {
            return false;
        }
        CreateQueueMessage other = (CreateQueueMessage)obj;
        return Objects.equals(this.address, other.address) && this.durable == other.durable && Objects.equals(this.filterString, other.filterString) && Objects.equals(this.queueName, other.queueName) && this.requiresResponse == other.requiresResponse && this.temporary == other.temporary;
    }
}

