/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.TimeValue;

class CacheValidityPolicy {
    public static final TimeValue MAX_AGE = TimeValue.ofSeconds((long)0x80000000L);

    CacheValidityPolicy() {
    }

    public TimeValue getCurrentAge(HttpCacheEntry entry, Instant now) {
        return TimeValue.ofSeconds((long)(this.getCorrectedInitialAge(entry).toSeconds() + this.getResidentTime(entry, now).toSeconds()));
    }

    public TimeValue getFreshnessLifetime(HttpCacheEntry entry) {
        long maxAge = this.getMaxAge(entry);
        if (maxAge > -1L) {
            return TimeValue.ofSeconds((long)maxAge);
        }
        Instant dateValue = entry.getInstant();
        if (dateValue == null) {
            return TimeValue.ZERO_MILLISECONDS;
        }
        Instant expiry = DateUtils.parseStandardDate((MessageHeaders)entry, (String)"Expires");
        if (expiry == null) {
            return TimeValue.ZERO_MILLISECONDS;
        }
        Duration diff = Duration.between(dateValue, expiry);
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }

    public boolean isResponseFresh(HttpCacheEntry entry, Instant now) {
        return this.getCurrentAge(entry, now).compareTo(this.getFreshnessLifetime(entry)) == -1;
    }

    public boolean isResponseHeuristicallyFresh(HttpCacheEntry entry, Instant now, float coefficient, TimeValue defaultLifetime) {
        return this.getCurrentAge(entry, now).compareTo(this.getHeuristicFreshnessLifetime(entry, coefficient, defaultLifetime)) == -1;
    }

    public TimeValue getHeuristicFreshnessLifetime(HttpCacheEntry entry, float coefficient, TimeValue defaultLifetime) {
        Instant dateValue = entry.getInstant();
        Instant lastModifiedValue = DateUtils.parseStandardDate((MessageHeaders)entry, (String)"Last-Modified");
        if (dateValue != null && lastModifiedValue != null) {
            Duration diff = Duration.between(lastModifiedValue, dateValue);
            if (diff.isNegative()) {
                return TimeValue.ZERO_MILLISECONDS;
            }
            return TimeValue.ofSeconds((long)((long)(coefficient * (float)diff.getSeconds())));
        }
        return defaultLifetime;
    }

    public boolean isRevalidatable(HttpCacheEntry entry) {
        return entry.getFirstHeader("ETag") != null || entry.getFirstHeader("Last-Modified") != null;
    }

    public boolean mustRevalidate(HttpCacheEntry entry) {
        return this.hasCacheControlDirective(entry, "must-revalidate");
    }

    public boolean proxyRevalidate(HttpCacheEntry entry) {
        return this.hasCacheControlDirective(entry, "proxy-revalidate");
    }

    public boolean mayReturnStaleWhileRevalidating(HttpCacheEntry entry, Instant now) {
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"stale-while-revalidate".equalsIgnoreCase(elt.getName())) continue;
            try {
                int allowedStalenessLifetime = Integer.parseInt(elt.getValue());
                if (this.getStaleness(entry, now).compareTo(TimeValue.ofSeconds((long)allowedStalenessLifetime)) > 0) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    public boolean mayReturnStaleIfError(HttpRequest request, HttpCacheEntry entry, Instant now) {
        TimeValue staleness = this.getStaleness(entry, now);
        return this.mayReturnStaleIfError((MessageHeaders)request, "Cache-Control", staleness) || this.mayReturnStaleIfError(entry, "Cache-Control", staleness);
    }

    private boolean mayReturnStaleIfError(MessageHeaders headers, String name, TimeValue staleness) {
        boolean result = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)headers, (String)name);
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"stale-if-error".equals(elt.getName())) continue;
            try {
                int staleIfError = Integer.parseInt(elt.getValue());
                if (staleness.compareTo(TimeValue.ofSeconds((long)staleIfError)) > 0) continue;
                result = true;
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return result;
    }

    protected boolean contentLengthHeaderMatchesActualLength(HttpCacheEntry entry) {
        Header h = entry.getFirstHeader("Content-Length");
        if (h != null) {
            try {
                long responseLen = Long.parseLong(h.getValue());
                Resource resource = entry.getResource();
                if (resource == null) {
                    return false;
                }
                long resourceLen = resource.length();
                return responseLen == resourceLen;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }

    protected TimeValue getApparentAge(HttpCacheEntry entry) {
        Instant dateValue = entry.getInstant();
        if (dateValue == null) {
            return MAX_AGE;
        }
        Duration diff = Duration.between(dateValue, entry.getResponseInstant());
        if (diff.isNegative()) {
            return TimeValue.ZERO_MILLISECONDS;
        }
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }

    protected long getAgeValue(HttpCacheEntry entry) {
        long ageValue = 0L;
        for (Header hdr : entry.getHeaders("Age")) {
            long hdrAge;
            try {
                hdrAge = Long.parseLong(hdr.getValue());
                if (hdrAge < 0L) {
                    hdrAge = MAX_AGE.toSeconds();
                }
            }
            catch (NumberFormatException nfe) {
                hdrAge = MAX_AGE.toSeconds();
            }
            ageValue = hdrAge > ageValue ? hdrAge : ageValue;
        }
        return ageValue;
    }

    protected TimeValue getCorrectedReceivedAge(HttpCacheEntry entry) {
        TimeValue apparentAge = this.getApparentAge(entry);
        long ageValue = this.getAgeValue(entry);
        return apparentAge.toSeconds() > ageValue ? apparentAge : TimeValue.ofSeconds((long)ageValue);
    }

    protected TimeValue getResponseDelay(HttpCacheEntry entry) {
        Duration diff = Duration.between(entry.getRequestInstant(), entry.getResponseInstant());
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }

    protected TimeValue getCorrectedInitialAge(HttpCacheEntry entry) {
        return TimeValue.ofSeconds((long)(this.getCorrectedReceivedAge(entry).toSeconds() + this.getResponseDelay(entry).toSeconds()));
    }

    protected TimeValue getResidentTime(HttpCacheEntry entry, Instant now) {
        Duration diff = Duration.between(entry.getResponseInstant(), now);
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }

    protected long getMaxAge(HttpCacheEntry entry) {
        long maxAge = -1L;
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"max-age".equals(elt.getName()) && !"s-maxage".equals(elt.getName())) continue;
            try {
                long currMaxAge = Long.parseLong(elt.getValue());
                if (maxAge != -1L && currMaxAge >= maxAge) continue;
                maxAge = currMaxAge;
            }
            catch (NumberFormatException nfe) {
                maxAge = 0L;
            }
        }
        return maxAge;
    }

    public boolean hasCacheControlDirective(HttpCacheEntry entry, String directive) {
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!directive.equalsIgnoreCase(elt.getName())) continue;
            return true;
        }
        return false;
    }

    public TimeValue getStaleness(HttpCacheEntry entry, Instant now) {
        TimeValue freshness;
        TimeValue age = this.getCurrentAge(entry, now);
        if (age.compareTo(freshness = this.getFreshnessLifetime(entry)) <= 0) {
            return TimeValue.ZERO_MILLISECONDS;
        }
        return TimeValue.ofSeconds((long)(age.toSeconds() - freshness.toSeconds()));
    }
}

