/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.persistence.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.jms.persistence.config.PersistedType;
import org.apache.activemq.artemis.utils.BufferHelper;

public class PersistedBindings
implements EncodingSupport {
    private long id;
    private PersistedType type;
    private String name;
    private List<String> bindings = new ArrayList<String>();

    public PersistedBindings() {
    }

    public PersistedBindings(PersistedType type, String name) {
        this.type = type;
        this.name = name;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.type = PersistedType.getType(buffer.readByte());
        this.name = buffer.readSimpleString().toString();
        int bindingArraySize = buffer.readInt();
        this.bindings = new ArrayList<String>(bindingArraySize);
        for (int i = 0; i < bindingArraySize; ++i) {
            this.bindings.add(buffer.readSimpleString().toString());
        }
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeByte(this.type.getType());
        BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)this.name);
        buffer.writeInt(this.bindings.size());
        for (String bindingsEl : this.bindings) {
            BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)bindingsEl);
        }
    }

    public int getEncodeSize() {
        return 1 + BufferHelper.sizeOfSimpleString((String)this.name) + this.sizeOfBindings();
    }

    private int sizeOfBindings() {
        int size = 4;
        for (String str : this.bindings) {
            size += BufferHelper.sizeOfSimpleString((String)str);
        }
        return size;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public PersistedType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getBindings() {
        return this.bindings;
    }

    public void addBinding(String address) {
        this.bindings.add(address);
    }

    public void deleteBinding(String address) {
        this.bindings.remove(address);
    }
}

