/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.EvaluateAllEndpoints;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

@NoJSR250Annotations
@EvaluateAllEndpoints
@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Client)
public class FailoverFeature
extends DelegatingFeature<Portable> {
    protected FailoverFeature(Portable portable) {
        super((AbstractPortableFeature)portable);
    }

    public FailoverFeature() {
        super((AbstractPortableFeature)new Portable());
    }

    public FailoverFeature(String clientBootstrapAddress) {
        super((AbstractPortableFeature)new Portable(clientBootstrapAddress));
    }

    public ConduitSelector initTargetSelector(Endpoint endpoint) {
        return ((Portable)this.delegate).initTargetSelector(endpoint);
    }

    public FailoverTargetSelector getTargetSelector() {
        return ((Portable)this.delegate).getTargetSelector();
    }

    public void setTargetSelector(FailoverTargetSelector selector) {
        ((Portable)this.delegate).setTargetSelector(selector);
    }

    public void setStrategy(FailoverStrategy strategy) {
        ((Portable)this.delegate).setStrategy(strategy);
    }

    public FailoverStrategy getStrategy() {
        return ((Portable)this.delegate).getStrategy();
    }

    public String getClientBootstrapAddress() {
        return ((Portable)this.delegate).getClientBootstrapAddress();
    }

    public void setClientBootstrapAddress(String clientBootstrapAddress) {
        ((Portable)this.delegate).setClientBootstrapAddress(clientBootstrapAddress);
    }

    public static class Portable
    implements AbstractPortableFeature {
        private FailoverStrategy failoverStrategy;
        private FailoverTargetSelector targetSelector;
        private String clientBootstrapAddress;

        public Portable() {
        }

        public Portable(String clientBootstrapAddress) {
            this.clientBootstrapAddress = clientBootstrapAddress;
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            if (provider instanceof ConduitSelectorHolder) {
                ConduitSelectorHolder csHolder = (ConduitSelectorHolder)provider;
                Endpoint endpoint = csHolder.getConduitSelector().getEndpoint();
                ConduitSelector conduitSelector = this.initTargetSelector(endpoint);
                csHolder.setConduitSelector(conduitSelector);
            }
        }

        public void initialize(Client client, Bus bus) {
            ConduitSelector selector = this.initTargetSelector(client.getConduitSelector().getEndpoint());
            client.setConduitSelector(selector);
        }

        protected ConduitSelector initTargetSelector(Endpoint endpoint) {
            FailoverTargetSelector selector = this.getTargetSelector();
            selector.setEndpoint(endpoint);
            if (this.getStrategy() != null) {
                selector.setStrategy(this.getStrategy());
            }
            return selector;
        }

        public FailoverTargetSelector getTargetSelector() {
            if (this.targetSelector == null) {
                this.targetSelector = new FailoverTargetSelector(this.clientBootstrapAddress);
            }
            return this.targetSelector;
        }

        public void setTargetSelector(FailoverTargetSelector selector) {
            this.targetSelector = selector;
        }

        public void setStrategy(FailoverStrategy strategy) {
            this.failoverStrategy = strategy;
        }

        public FailoverStrategy getStrategy() {
            return this.failoverStrategy;
        }

        public String getClientBootstrapAddress() {
            return this.clientBootstrapAddress;
        }

        public void setClientBootstrapAddress(String clientBootstrapAddress) {
            this.clientBootstrapAddress = clientBootstrapAddress;
        }
    }
}

