/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.login.AppConfigurationEntry;

public class JaasAppConfigurationEntry
implements Serializable {
    private static final long serialVersionUID = -651209063030767725L;
    private String name;
    private String loginModuleClass;
    private String controlFlag;
    private Map<String, String> params = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public String getLoginModuleClass() {
        return this.loginModuleClass;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getControlFlag() {
        return this.controlFlag;
    }

    public JaasAppConfigurationEntry setName(String name) {
        this.name = name;
        return this;
    }

    public JaasAppConfigurationEntry setLoginModuleClass(String loginModuleClass) {
        this.loginModuleClass = loginModuleClass;
        return this;
    }

    public JaasAppConfigurationEntry setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public void setControlFlag(String controlFlag) {
        this.controlFlag = controlFlag;
        this.getLoginModuleControlFlag();
    }

    AppConfigurationEntry.LoginModuleControlFlag getLoginModuleControlFlag() {
        if (this.controlFlag == null || this.controlFlag.isEmpty() || this.controlFlag.equals("required")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if (this.controlFlag.equals("requisite")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if (this.controlFlag.equals("optional")) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if (this.controlFlag.equals("sufficient")) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        throw new IllegalArgumentException("Unknown control flag: " + this.controlFlag);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaasAppConfigurationEntry that = (JaasAppConfigurationEntry)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.loginModuleClass, that.loginModuleClass) && Objects.equals(this.controlFlag, that.controlFlag) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.loginModuleClass, this.controlFlag, this.params);
    }
}

