/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.resourceadapter;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public class ResourceAdapterInternalException
extends jakarta.resource.spi.ResourceAdapterInternalException {
    private static final long serialVersionUID = 6769505138041263456L;
    private static final String REASON_PREFIX = ", reason: ";
    private static final Logger LOGGER = LogUtils.getL7dLogger(ResourceAdapterInternalException.class);

    public ResourceAdapterInternalException(String msg) {
        this(msg, null);
    }

    public ResourceAdapterInternalException(String msg, Throwable cause) {
        super(msg + ResourceAdapterInternalException.optionalReasonFromCause(cause));
        this.setCause(cause);
        if (cause != null) {
            if (null != LOGGER.getLevel() && LOGGER.getLevel().intValue() < Level.INFO.intValue()) {
                cause.printStackTrace();
            }
            LOGGER.warning(cause.toString());
        }
    }

    private static String optionalReasonFromCause(Throwable cause) {
        Object reason = "";
        if (cause != null) {
            reason = cause instanceof InvocationTargetException ? REASON_PREFIX + String.valueOf(((InvocationTargetException)cause).getTargetException()) : REASON_PREFIX + String.valueOf(cause);
        }
        return reason;
    }

    private void setCause(Throwable cause) {
        if (this.getCause() != null) {
            return;
        }
        if (cause instanceof InvocationTargetException && ((InvocationTargetException)cause).getTargetException() != null) {
            this.initCause(((InvocationTargetException)cause).getTargetException());
        } else {
            this.initCause(cause);
        }
    }

    public Exception getLinkedException() {
        Exception linkedEx = null;
        if (this.getCause() instanceof Exception) {
            linkedEx = (Exception)this.getCause();
        }
        return linkedEx;
    }
}

