/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.deployers.impl;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeQueuePolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationDownstreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationPolicySet;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationStreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationTransformerConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.PrimaryOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.Validators;
import org.apache.activemq.artemis.core.config.routing.CacheConfiguration;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.config.routing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.config.routing.PoolConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.config.storage.FileStorageConfiguration;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.metrics.ActiveMQMetricsPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyFactoryResolver;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.DiskFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.XMLConfigurationUtil;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.apache.activemq.artemis.utils.XmlProvider;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileConfigurationParser
extends XMLConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SECURITY_ELEMENT_NAME = "security-setting";
    public static final String SECURITY_PLUGIN_ELEMENT_NAME = "security-setting-plugin";
    public static final String SECURITY_ROLE_MAPPING_NAME = "role-mapping";
    public static final String BROKER_PLUGINS_ELEMENT_NAME = "broker-plugins";
    public static final String BROKER_PLUGIN_ELEMENT_NAME = "broker-plugin";
    private static final String PERMISSION_ELEMENT_NAME = "permission";
    private static final String SETTING_ELEMENT_NAME = "setting";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String ROLES_ATTR_NAME = "roles";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String ROLE_FROM_ATTR_NAME = "from";
    private static final String ROLE_TO_ATTR_NAME = "to";
    @Deprecated(forRemoval=true)
    private static final String CREATETEMPQUEUE_NAME = "createTempQueue";
    @Deprecated(forRemoval=true)
    private static final String DELETETEMPQUEUE_NAME = "deleteTempQueue";
    private static final String DEAD_LETTER_ADDRESS_NODE_NAME = "dead-letter-address";
    private static final String AUTO_CREATE_DEAD_LETTER_RESOURCES_NODE_NAME = "auto-create-dead-letter-resources";
    private static final String DEAD_LETTER_QUEUE_PREFIX_NODE_NAME = "dead-letter-queue-prefix";
    private static final String DEAD_LETTER_QUEUE_SUFFIX_NODE_NAME = "dead-letter-queue-suffix";
    private static final String EXPIRY_ADDRESS_NODE_NAME = "expiry-address";
    private static final String AUTO_CREATE_EXPIRY_RESOURCES_NODE_NAME = "auto-create-expiry-resources";
    private static final String EXPIRY_QUEUE_PREFIX_NODE_NAME = "expiry-queue-prefix";
    private static final String EXPIRY_QUEUE_SUFFIX_NODE_NAME = "expiry-queue-suffix";
    private static final String EXPIRY_DELAY_NODE_NAME = "expiry-delay";
    private static final String MIN_EXPIRY_DELAY_NODE_NAME = "min-expiry-delay";
    private static final String MAX_EXPIRY_DELAY_NODE_NAME = "max-expiry-delay";
    private static final String NO_EXPIRY_NODE_NAME = "no-expiry";
    private static final String REDELIVERY_DELAY_NODE_NAME = "redelivery-delay";
    private static final String REDELIVERY_DELAY_MULTIPLIER_NODE_NAME = "redelivery-delay-multiplier";
    private static final String REDELIVERY_COLLISION_AVOIDANCE_FACTOR_NODE_NAME = "redelivery-collision-avoidance-factor";
    private static final String MAX_REDELIVERY_DELAY_NODE_NAME = "max-redelivery-delay";
    private static final String MAX_DELIVERY_ATTEMPTS = "max-delivery-attempts";
    private static final String MAX_SIZE_BYTES_NODE_NAME = "max-size-bytes";
    private static final String MAX_MESSAGES_NODE_NAME = "max-size-messages";
    private static final String MAX_SIZE_BYTES_REJECT_THRESHOLD_NODE_NAME = "max-size-bytes-reject-threshold";
    private static final String ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME = "address-full-policy";
    private static final String PAGE_FULL_MESSAGE_POLICY_NODE_NAME = "page-full-policy";
    private static final String DISK_FULL_MESSAGE_POLICY_NODE_NAME = "disk-full-policy";
    private static final String MAX_READ_PAGE_BYTES_NODE_NAME = "max-read-page-bytes";
    private static final String PREFETCH_PAGE_BYTES_NODE_NAME = "prefetch-page-bytes";
    private static final String MAX_READ_PAGE_MESSAGES_NODE_NAME = "max-read-page-messages";
    private static final String PREFETCH_PAGE_MESSAGES_NODE_NAME = "prefetch-page-messages";
    private static final String PAGE_SIZE_BYTES_NODE_NAME = "page-size-bytes";
    private static final String PAGE_MAX_CACHE_SIZE_NODE_NAME = "page-max-cache-size";
    private static final String PAGE_LIMIT_BYTES_NODE_NAME = "page-limit-bytes";
    private static final String PAGE_LIMIT_MESSAGES_NODE_NAME = "page-limit-messages";
    private static final String MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME = "message-counter-history-day-limit";
    private static final String LVQ_NODE_NAME = "last-value-queue";
    private static final String DEFAULT_LVQ_NODE_NAME = "default-last-value-queue";
    private static final String DEFAULT_LVQ_KEY_NODE_NAME = "default-last-value-key";
    private static final String DEFAULT_NON_DESTRUCTIVE_NODE_NAME = "default-non-destructive";
    private static final String DEFAULT_EXCLUSIVE_NODE_NAME = "default-exclusive-queue";
    private static final String DEFAULT_GROUP_REBALANCE = "default-group-rebalance";
    private static final String DEFAULT_GROUP_REBALANCE_PAUSE_DISPATCH = "default-group-rebalance-pause-dispatch";
    private static final String DEFAULT_GROUP_BUCKETS = "default-group-buckets";
    private static final String DEFAULT_GROUP_FIRST_KEY = "default-group-first-key";
    private static final String DEFAULT_CONSUMERS_BEFORE_DISPATCH = "default-consumers-before-dispatch";
    private static final String DEFAULT_DELAY_BEFORE_DISPATCH = "default-delay-before-dispatch";
    private static final String REDISTRIBUTION_DELAY_NODE_NAME = "redistribution-delay";
    private static final String SEND_TO_DLA_ON_NO_ROUTE = "send-to-dla-on-no-route";
    private static final String SLOW_CONSUMER_THRESHOLD_NODE_NAME = "slow-consumer-threshold";
    private static final String SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT_NODE_NAME = "slow-consumer-threshold-measurement-unit";
    private static final String SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME = "slow-consumer-check-period";
    private static final String SLOW_CONSUMER_POLICY_NODE_NAME = "slow-consumer-policy";
    private static final String AUTO_CREATE_JMS_QUEUES = "auto-create-jms-queues";
    private static final String AUTO_DELETE_JMS_QUEUES = "auto-delete-jms-queues";
    private static final String AUTO_CREATE_JMS_TOPICS = "auto-create-jms-topics";
    private static final String AUTO_DELETE_JMS_TOPICS = "auto-delete-jms-topics";
    private static final String AUTO_CREATE_QUEUES = "auto-create-queues";
    private static final String AUTO_DELETE_QUEUES = "auto-delete-queues";
    private static final String AUTO_DELETE_CREATED_QUEUES = "auto-delete-created-queues";
    private static final String AUTO_DELETE_QUEUES_DELAY = "auto-delete-queues-delay";
    private static final String AUTO_DELETE_QUEUES_MESSAGE_COUNT = "auto-delete-queues-message-count";
    private static final String AUTO_DELETE_QUEUES_SKIP_USAGE_CHECK = "auto-delete-queues-skip-usage-check";
    private static final String CONFIG_DELETE_QUEUES = "config-delete-queues";
    private static final String AUTO_CREATE_ADDRESSES = "auto-create-addresses";
    private static final String AUTO_DELETE_ADDRESSES = "auto-delete-addresses";
    private static final String AUTO_DELETE_ADDRESSES_DELAY = "auto-delete-addresses-delay";
    private static final String AUTO_DELETE_ADDRESSES_SKIP_USAGE_CHECK = "auto-delete-addresses-skip-usage-check";
    private static final String CONFIG_DELETE_ADDRESSES = "config-delete-addresses";
    private static final String CONFIG_DELETE_DIVERTS = "config-delete-diverts";
    private static final String DEFAULT_PURGE_ON_NO_CONSUMERS = "default-purge-on-no-consumers";
    private static final String DEFAULT_MAX_CONSUMERS = "default-max-consumers";
    private static final String DEFAULT_QUEUE_ROUTING_TYPE = "default-queue-routing-type";
    private static final String DEFAULT_ADDRESS_ROUTING_TYPE = "default-address-routing-type";
    private static final String MANAGEMENT_BROWSE_PAGE_SIZE = "management-browse-page-size";
    private static final String MANAGEMENT_MESSAGE_ATTRIBUTE_SIZE_LIMIT = "management-message-attribute-size-limit";
    private static final String MAX_CONNECTIONS_NODE_NAME = "max-connections";
    private static final String MAX_QUEUES_NODE_NAME = "max-queues";
    private static final String GLOBAL_MAX_SIZE = "global-max-size";
    private static final String GLOBAL_MAX_SIZE_PERCENT_JVM_MAX_MEM = "global-max-size-percent-of-jvm-max-memory";
    private static final String GLOBAL_MAX_MESSAGES = "global-max-messages";
    public static final String MAX_DISK_USAGE = "max-disk-usage";
    public static final String MIN_DISK_FREE = "min-disk-free";
    private static final String DISK_SCAN_PERIOD = "disk-scan-period";
    private static final String INTERNAL_NAMING_PREFIX = "internal-naming-prefix";
    private static final String AMQP_USE_CORE_SUBSCRIPTION_NAMING = "amqp-use-core-subscription-naming";
    private static final String DEFAULT_CONSUMER_WINDOW_SIZE = "default-consumer-window-size";
    private static final String DEFAULT_RING_SIZE = "default-ring-size";
    private static final String RETROACTIVE_MESSAGE_COUNT = "retroactive-message-count";
    private static final String ENABLE_METRICS = "enable-metrics";
    private static final String ENABLE_INGRESS_TIMESTAMP = "enable-ingress-timestamp";
    private static final String ID_CACHE_SIZE = "id-cache-size";
    private static final String MIRROR_ACK_MANAGER_QUEUE_ATTEMPTS = "mirror-ack-manager-queue-attempts";
    private static final String MIRROR_ACK_MANAGER_PAGE_ATTEMPTS = "mirror-ack-manager-page-attempts";
    private static final String MIRROR_ACK_MANAGER_RETRY_DELAY = "mirror-ack-manager-retry-delay";
    private static final String MIRROR_ACK_MANAGER_WARN_UNACKED = "mirror-ack-manager-warn-unacked";
    private static final String MIRROR_PAGE_TRANSACTION = "mirror-page-transaction";
    private static final String INITIAL_QUEUE_BUFFER_SIZE = "initial-queue-buffer-size";
    private static final String MQTT_SUBSCRIPTION_PERSISTENCE_ENABLED = "mqtt-subscription-persistence-enabled";
    private boolean validateAIO = false;
    private boolean printPageMaxSizeUsed = false;
    private static final List<String> HA_LIST = new ArrayList<String>();
    private static final List<String> STORE_TYPE_LIST;

    public boolean isValidateAIO() {
        return this.validateAIO;
    }

    public void setValidateAIO(boolean validateAIO) {
        this.validateAIO = validateAIO;
    }

    public Configuration parseMainConfig(InputStream input) throws Exception {
        Element e = XMLUtil.streamToElement((InputStream)input);
        Validator validator = XmlProvider.newValidator((URL)XMLUtil.findResource((String)"schema/artemis-server.xsd"));
        try {
            validator.validate(new DOMSource(e));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        ConfigurationImpl config = new ConfigurationImpl();
        this.parseMainConfig(e, config);
        return config;
    }

    public void parseMainConfig(Element e, Configuration config) throws Exception {
        boolean supportsAIO;
        NodeList ccConnectionRouter;
        int i;
        NodeList ccAMQConnectionsURI;
        int i2;
        NodeList incomingInterceptorNodes;
        config.setName(FileConfigurationParser.getString(e, NAME_ATTR_NAME, config.getName(), Validators.NO_CHECK));
        config.setSystemPropertyPrefix(FileConfigurationParser.getString(e, "system-property-prefix", config.getSystemPropertyPrefix(), Validators.NOT_NULL_OR_EMPTY));
        NodeList haPolicyNodes = e.getElementsByTagName("ha-policy");
        if (haPolicyNodes.getLength() > 0) {
            this.parseHAPolicyConfiguration((Element)haPolicyNodes.item(0), config);
        }
        if (config.getHAPolicyConfiguration() == null) {
            config.setHAPolicyConfiguration(new PrimaryOnlyPolicyConfiguration());
        }
        config.setResolveProtocols(FileConfigurationParser.getBoolean(e, "resolve-protocols", config.isResolveProtocols()));
        config.setPersistenceEnabled(FileConfigurationParser.getBoolean(e, "persistence-enabled", config.isPersistenceEnabled()));
        config.setPersistDeliveryCountBeforeDelivery(FileConfigurationParser.getBoolean(e, "persist-delivery-count-before-delivery", config.isPersistDeliveryCountBeforeDelivery()));
        config.setMaxRedeliveryRecords(FileConfigurationParser.getInteger(e, "max-redelivery-records", config.getMaxRedeliveryRecords(), Validators.MINUS_ONE_OR_GE_ZERO));
        config.setScheduledThreadPoolMaxSize(FileConfigurationParser.getInteger(e, "scheduled-thread-pool-max-size", config.getScheduledThreadPoolMaxSize(), Validators.GT_ZERO));
        config.setThreadPoolMaxSize(FileConfigurationParser.getInteger(e, "thread-pool-max-size", config.getThreadPoolMaxSize(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setSecurityEnabled(FileConfigurationParser.getBoolean(e, "security-enabled", config.isSecurityEnabled()));
        config.setGracefulShutdownEnabled(FileConfigurationParser.getBoolean(e, "graceful-shutdown-enabled", config.isGracefulShutdownEnabled()));
        config.setGracefulShutdownTimeout(FileConfigurationParser.getLong(e, "graceful-shutdown-timeout", config.getGracefulShutdownTimeout(), Validators.MINUS_ONE_OR_GE_ZERO));
        config.setJMXManagementEnabled(FileConfigurationParser.getBoolean(e, "jmx-management-enabled", config.isJMXManagementEnabled()));
        config.setJMXDomain(FileConfigurationParser.getString(e, "jmx-domain", config.getJMXDomain(), Validators.NOT_NULL_OR_EMPTY));
        config.setJMXUseBrokerName(FileConfigurationParser.getBoolean(e, "jmx-use-broker-name", config.isJMXUseBrokerName()));
        config.setSecurityInvalidationInterval(FileConfigurationParser.getLong(e, "security-invalidation-interval", config.getSecurityInvalidationInterval(), Validators.GE_ZERO));
        config.setAuthenticationCacheSize(FileConfigurationParser.getLong(e, "authentication-cache-size", config.getAuthenticationCacheSize(), Validators.GE_ZERO));
        config.setAuthorizationCacheSize(FileConfigurationParser.getLong(e, "authorization-cache-size", config.getAuthorizationCacheSize(), Validators.GE_ZERO));
        config.setConnectionTTLOverride(FileConfigurationParser.getLong(e, "connection-ttl-override", config.getConnectionTTLOverride(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setEnabledAsyncConnectionExecution(FileConfigurationParser.getBoolean(e, "async-connection-execution-enabled", config.isAsyncConnectionExecutionEnabled()));
        config.setTransactionTimeout(FileConfigurationParser.getLong(e, "transaction-timeout", config.getTransactionTimeout(), Validators.GT_ZERO));
        config.setTransactionTimeoutScanPeriod(FileConfigurationParser.getLong(e, "transaction-timeout-scan-period", config.getTransactionTimeoutScanPeriod(), Validators.GT_ZERO));
        config.setMessageExpiryScanPeriod(FileConfigurationParser.getLong(e, "message-expiry-scan-period", config.getMessageExpiryScanPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setAddressQueueScanPeriod(FileConfigurationParser.getLong(e, "address-queue-scan-period", config.getAddressQueueScanPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setIDCacheSize(FileConfigurationParser.getInteger(e, ID_CACHE_SIZE, config.getIDCacheSize(), Validators.GE_ZERO));
        config.setPersistIDCache(FileConfigurationParser.getBoolean(e, "persist-id-cache", config.isPersistIDCache()));
        config.setManagementAddress(SimpleString.of((String)FileConfigurationParser.getString(e, "management-address", config.getManagementAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setManagementNotificationAddress(SimpleString.of((String)FileConfigurationParser.getString(e, "management-notification-address", config.getManagementNotificationAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setMaskPassword(FileConfigurationParser.getBoolean(e, "mask-password", null));
        config.setPasswordCodec(FileConfigurationParser.getString(e, "password-codec", DefaultSensitiveStringCodec.class.getName(), Validators.NOT_NULL_OR_EMPTY));
        config.setPopulateValidatedUser(FileConfigurationParser.getBoolean(e, "populate-validated-user", config.isPopulateValidatedUser()));
        config.setRejectEmptyValidatedUser(FileConfigurationParser.getBoolean(e, "reject-empty-validated-user", config.isRejectEmptyValidatedUser()));
        config.setConnectionTtlCheckInterval(FileConfigurationParser.getLong(e, "connection-ttl-check-interval", config.getConnectionTtlCheckInterval(), Validators.GT_ZERO));
        config.setConfigurationFileRefreshPeriod(FileConfigurationParser.getLong(e, "configuration-file-refresh-period", config.getConfigurationFileRefreshPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setTemporaryQueueNamespace(FileConfigurationParser.getString(e, "temporary-queue-namespace", config.getTemporaryQueueNamespace(), Validators.NOT_NULL_OR_EMPTY));
        config.setUuidNamespace(FileConfigurationParser.getString(e, "uuid-namespace", config.getUuidNamespace(), Validators.NOT_NULL_OR_EMPTY));
        config.setMqttSessionScanInterval(FileConfigurationParser.getLong(e, "mqtt-session-scan-interval", config.getMqttSessionScanInterval(), Validators.GT_ZERO));
        config.setMqttSessionStatePersistenceTimeout(FileConfigurationParser.getLong(e, "mqtt-session-state-persistence-timeout", config.getMqttSessionStatePersistenceTimeout(), Validators.GT_ZERO, MQTT_SUBSCRIPTION_PERSISTENCE_ENABLED));
        config.setMqttSubscriptionPersistenceEnabled(FileConfigurationParser.getBoolean(e, MQTT_SUBSCRIPTION_PERSISTENCE_ENABLED, config.isMqttSubscriptionPersistenceEnabled()));
        config.setGlobalMaxSizePercentOfJvmMaxMemory(FileConfigurationParser.getInteger(e, GLOBAL_MAX_SIZE_PERCENT_JVM_MAX_MEM, config.getGlobalMaxSizePercentOfJvmMaxMemory(), Validators.GT_ZERO));
        long globalMaxSize = FileConfigurationParser.getTextBytesAsLongBytes(e, GLOBAL_MAX_SIZE, -1L, Validators.MINUS_ONE_OR_GT_ZERO);
        if (globalMaxSize > 0L) {
            config.setGlobalMaxSize(globalMaxSize);
        }
        long globalMaxMessages = FileConfigurationParser.getLong(e, GLOBAL_MAX_MESSAGES, -1L, Validators.MINUS_ONE_OR_GT_ZERO);
        config.setGlobalMaxMessages(globalMaxMessages);
        config.setMinDiskFree(FileConfigurationParser.getTextBytesAsLongBytes(e, MIN_DISK_FREE, config.getMinDiskFree(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMaxDiskUsage(FileConfigurationParser.getInteger(e, MAX_DISK_USAGE, config.getMaxDiskUsage(), Validators.PERCENTAGE_OR_MINUS_ONE));
        config.setDiskScanPeriod(FileConfigurationParser.getInteger(e, DISK_SCAN_PERIOD, config.getDiskScanPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setInternalNamingPrefix(FileConfigurationParser.getString(e, INTERNAL_NAMING_PREFIX, config.getInternalNamingPrefix(), Validators.NO_CHECK));
        config.setAmqpUseCoreSubscriptionNaming(FileConfigurationParser.getBoolean(e, AMQP_USE_CORE_SUBSCRIPTION_NAMING, config.isAmqpUseCoreSubscriptionNaming()));
        String passwordText = FileConfigurationParser.getString(e, "cluster-password", null, Validators.NO_CHECK);
        Boolean maskText = config.isMaskPassword();
        if (passwordText != null) {
            String resolvedPassword = PasswordMaskingUtil.resolveMask((Boolean)maskText, (String)passwordText, (String)config.getPasswordCodec());
            config.setClusterPassword(resolvedPassword);
        }
        config.setClusterUser(FileConfigurationParser.getString(e, "cluster-user", config.getClusterUser(), Validators.NO_CHECK));
        NodeList storeTypeNodes = e.getElementsByTagName("store");
        if (storeTypeNodes.getLength() > 0) {
            this.parseStoreConfiguration((Element)storeTypeNodes.item(0), config);
        }
        NodeList interceptorNodes = e.getElementsByTagName("remoting-interceptors");
        ArrayList<String> incomingInterceptorList = new ArrayList<String>();
        if (interceptorNodes.getLength() > 0) {
            NodeList interceptors = interceptorNodes.item(0).getChildNodes();
            for (int i3 = 0; i3 < interceptors.getLength(); ++i3) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i3).getNodeName())) continue;
                String clazz = FileConfigurationParser.getTrimmedTextContent(interceptors.item(i3));
                incomingInterceptorList.add(clazz);
            }
        }
        if ((incomingInterceptorNodes = e.getElementsByTagName("remoting-incoming-interceptors")).getLength() > 0) {
            NodeList interceptors = incomingInterceptorNodes.item(0).getChildNodes();
            for (int i4 = 0; i4 < interceptors.getLength(); ++i4) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i4).getNodeName())) continue;
                String clazz = FileConfigurationParser.getTrimmedTextContent(interceptors.item(i4));
                incomingInterceptorList.add(clazz);
            }
        }
        config.setIncomingInterceptorClassNames(incomingInterceptorList);
        NodeList outgoingInterceptorNodes = e.getElementsByTagName("remoting-outgoing-interceptors");
        ArrayList<String> outgoingInterceptorList = new ArrayList<String>();
        if (outgoingInterceptorNodes.getLength() > 0) {
            NodeList interceptors = outgoingInterceptorNodes.item(0).getChildNodes();
            for (i2 = 0; i2 < interceptors.getLength(); ++i2) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i2).getNodeName())) continue;
                String clazz = interceptors.item(i2).getTextContent();
                outgoingInterceptorList.add(clazz);
            }
        }
        config.setOutgoingInterceptorClassNames(outgoingInterceptorList);
        NodeList connectorNodes = e.getElementsByTagName("connector");
        for (i2 = 0; i2 < connectorNodes.getLength(); ++i2) {
            Element connectorNode = (Element)connectorNodes.item(i2);
            TransportConfiguration connectorConfig = this.parseConnectorTransportConfiguration(connectorNode, config);
            if (connectorConfig.getName() == null) {
                ActiveMQServerLogger.LOGGER.connectorWithNoName();
                continue;
            }
            if (config.getConnectorConfigurations().containsKey(connectorConfig.getName())) {
                ActiveMQServerLogger.LOGGER.connectorAlreadyDeployed(connectorConfig.getName());
                continue;
            }
            config.getConnectorConfigurations().put(connectorConfig.getName(), connectorConfig);
        }
        NodeList acceptorNodes = e.getElementsByTagName("acceptor");
        for (int i5 = 0; i5 < acceptorNodes.getLength(); ++i5) {
            Element acceptorNode = (Element)acceptorNodes.item(i5);
            TransportConfiguration acceptorConfig = this.parseAcceptorTransportConfiguration(acceptorNode, config);
            config.getAcceptorConfigurations().add(acceptorConfig);
        }
        NodeList bgNodes = e.getElementsByTagName("broadcast-group");
        for (int i6 = 0; i6 < bgNodes.getLength(); ++i6) {
            Element bgNode = (Element)bgNodes.item(i6);
            this.parseBroadcastGroupConfiguration(bgNode, config);
        }
        NodeList dgNodes = e.getElementsByTagName("discovery-group");
        for (int i7 = 0; i7 < dgNodes.getLength(); ++i7) {
            Element dgNode = (Element)dgNodes.item(i7);
            this.parseDiscoveryGroupConfiguration(dgNode, config);
        }
        NodeList bridges = e.getElementsByTagName("bridges");
        for (int i8 = 0; i8 < bridges.getLength(); ++i8) {
            Element bridgesElement = (Element)bridges.item(i8);
            for (int j = 0; j < bridgesElement.getChildNodes().getLength(); ++j) {
                Node node = bridgesElement.getChildNodes().item(j);
                if (!node.getNodeName().equalsIgnoreCase("bridge")) continue;
                this.parseBridgeConfiguration((Element)node, config);
            }
        }
        NodeList fedNodes = e.getElementsByTagName("federation");
        for (int i9 = 0; i9 < fedNodes.getLength(); ++i9) {
            Element fedNode = (Element)fedNodes.item(i9);
            this.parseFederationConfiguration(fedNode, config);
        }
        NodeList gaNodes = e.getElementsByTagName("grouping-handler");
        for (int i10 = 0; i10 < gaNodes.getLength(); ++i10) {
            Element gaNode = (Element)gaNodes.item(i10);
            this.parseGroupingHandlerConfiguration(gaNode, config);
        }
        NodeList ccNodes = e.getElementsByTagName("cluster-connection");
        for (int i11 = 0; i11 < ccNodes.getLength(); ++i11) {
            Element ccNode = (Element)ccNodes.item(i11);
            this.parseClusterConnectionConfiguration(ccNode, config);
        }
        NodeList ccNodesURI = e.getElementsByTagName("cluster-connection-uri");
        for (int i12 = 0; i12 < ccNodesURI.getLength(); ++i12) {
            Element ccNode = (Element)ccNodesURI.item(i12);
            this.parseClusterConnectionConfigurationURI(ccNode, config);
        }
        NodeList ccAMQPConnections = e.getElementsByTagName("broker-connections");
        if (ccAMQPConnections != null && (ccAMQConnectionsURI = e.getElementsByTagName("amqp-connection")) != null) {
            for (i = 0; i < ccAMQConnectionsURI.getLength(); ++i) {
                Element ccNode = (Element)ccAMQConnectionsURI.item(i);
                this.parseAMQPBrokerConnections(ccNode, config);
            }
        }
        NodeList dvNodes = e.getElementsByTagName("divert");
        for (i = 0; i < dvNodes.getLength(); ++i) {
            Element dvNode = (Element)dvNodes.item(i);
            this.parseDivertConfiguration(dvNode, config);
        }
        NodeList ccConnectionRouters = e.getElementsByTagName("connection-routers");
        if (ccConnectionRouters != null && (ccConnectionRouter = e.getElementsByTagName("connection-router")) != null) {
            for (int i13 = 0; i13 < ccConnectionRouter.getLength(); ++i13) {
                Element ccNode = (Element)ccConnectionRouter.item(i13);
                this.parseConnectionRouterConfiguration(ccNode, config);
            }
        }
        config.setLargeMessagesDirectory(FileConfigurationParser.getString(e, "large-messages-directory", config.getLargeMessagesDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setBindingsDirectory(FileConfigurationParser.getString(e, "bindings-directory", config.getBindingsDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateBindingsDir(FileConfigurationParser.getBoolean(e, "create-bindings-dir", config.isCreateBindingsDir()));
        config.setJournalDirectory(FileConfigurationParser.getString(e, "journal-directory", config.getJournalDirectory(), Validators.NOT_NULL_OR_EMPTY));
        this.parseJournalRetention(e, config);
        config.setNodeManagerLockDirectory(FileConfigurationParser.getString(e, "node-manager-lock-directory", null, Validators.NO_CHECK));
        config.setPageMaxConcurrentIO(FileConfigurationParser.getInteger(e, "page-max-concurrent-io", config.getPageMaxConcurrentIO(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setReadWholePage(FileConfigurationParser.getBoolean(e, "read-whole-page", config.isReadWholePage()));
        config.setPagingDirectory(FileConfigurationParser.getString(e, "paging-directory", config.getPagingDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setPurgePageFolders(FileConfigurationParser.getBoolean(e, "purge-page-folders", config.isPurgePageFolders()));
        config.setCreateJournalDir(FileConfigurationParser.getBoolean(e, "create-journal-dir", config.isCreateJournalDir()));
        String s = FileConfigurationParser.getString(e, "journal-type", config.getJournalType().toString(), Validators.JOURNAL_TYPE);
        config.setJournalType(JournalType.getType(s));
        if (config.getJournalType() == JournalType.ASYNCIO && !(supportsAIO = AIOSequentialFileFactory.isSupported())) {
            if (this.validateAIO) {
                ActiveMQServerLogger.LOGGER.AIONotFound();
            }
            config.setJournalType(JournalType.NIO);
        }
        config.setJournalDatasync(FileConfigurationParser.getBoolean(e, "journal-datasync", config.isJournalDatasync()));
        config.setJournalSyncTransactional(FileConfigurationParser.getBoolean(e, "journal-sync-transactional", config.isJournalSyncTransactional()));
        config.setJournalSyncNonTransactional(FileConfigurationParser.getBoolean(e, "journal-sync-non-transactional", config.isJournalSyncNonTransactional()));
        config.setJournalFileSize(FileConfigurationParser.getTextBytesAsIntBytes(e, "journal-file-size", config.getJournalFileSize(), Validators.POSITIVE_INT));
        config.setJournalMaxAtticFiles(FileConfigurationParser.getInteger(e, "journal-max-attic-files", config.getJournalMaxAtticFiles(), Validators.NO_CHECK));
        int journalBufferTimeout = FileConfigurationParser.getInteger(e, "journal-buffer-timeout", config.getJournalType() == JournalType.ASYNCIO ? 500000 : 3333333, Validators.GE_ZERO);
        int journalBufferSize = FileConfigurationParser.getTextBytesAsIntBytes(e, "journal-buffer-size", config.getJournalType() == JournalType.ASYNCIO ? 501760 : 501760, Validators.POSITIVE_INT);
        int journalMaxIO = FileConfigurationParser.getInteger(e, "journal-max-io", config.getJournalType() == JournalType.ASYNCIO ? ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio() : ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio(), Validators.GT_ZERO);
        config.setJournalDeviceBlockSize(FileConfigurationParser.getInteger(e, "journal-device-block-size", null, Validators.MINUS_ONE_OR_GE_ZERO));
        if (config.getJournalType() == JournalType.ASYNCIO) {
            config.setJournalBufferTimeout_AIO(journalBufferTimeout);
            config.setJournalBufferSize_AIO(journalBufferSize);
            config.setJournalMaxIO_AIO(journalMaxIO);
        } else {
            config.setJournalBufferTimeout_NIO(journalBufferTimeout);
            config.setJournalBufferSize_NIO(journalBufferSize);
            config.setJournalMaxIO_NIO(journalMaxIO);
        }
        config.setJournalFileOpenTimeout(FileConfigurationParser.getInteger(e, "journal-file-open-timeout", ActiveMQDefaultConfiguration.getDefaultJournalFileOpenTimeout(), Validators.GT_ZERO));
        config.setJournalMinFiles(FileConfigurationParser.getInteger(e, "journal-min-files", config.getJournalMinFiles(), Validators.GT_ZERO));
        config.setJournalPoolFiles(FileConfigurationParser.getInteger(e, "journal-pool-files", config.getJournalPoolFiles(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setJournalCompactMinFiles(FileConfigurationParser.getInteger(e, "journal-compact-min-files", config.getJournalCompactMinFiles(), Validators.GE_ZERO));
        config.setJournalCompactPercentage(FileConfigurationParser.getInteger(e, "journal-compact-percentage", config.getJournalCompactPercentage(), Validators.PERCENTAGE));
        config.setLogJournalWriteRate(FileConfigurationParser.getBoolean(e, "log-journal-write-rate", ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate()));
        config.setJournalLockAcquisitionTimeout(FileConfigurationParser.getLong(e, "journal-lock-acquisition-timeout", config.getJournalLockAcquisitionTimeout(), Validators.MINUS_ONE_OR_GT_ZERO));
        if (e.hasAttribute("wild-card-routing-enabled")) {
            config.setWildcardRoutingEnabled(FileConfigurationParser.getBoolean(e, "wild-card-routing-enabled", config.isWildcardRoutingEnabled()));
        }
        config.setMessageCounterEnabled(FileConfigurationParser.getBoolean(e, "message-counter-enabled", config.isMessageCounterEnabled()));
        config.setMessageCounterSamplePeriod(FileConfigurationParser.getLong(e, "message-counter-sample-period", config.getMessageCounterSamplePeriod(), Validators.GT_ZERO));
        config.setMessageCounterMaxDayHistory(FileConfigurationParser.getInteger(e, "message-counter-max-day-history", config.getMessageCounterMaxDayHistory(), Validators.GT_ZERO));
        config.setServerDumpInterval(FileConfigurationParser.getLong(e, "server-dump-interval", config.getServerDumpInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMemoryWarningThreshold(FileConfigurationParser.getInteger(e, "memory-warning-threshold", config.getMemoryWarningThreshold(), Validators.PERCENTAGE));
        config.setMemoryMeasureInterval(FileConfigurationParser.getLong(e, "memory-measure-interval", config.getMemoryMeasureInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setNetworkCheckList(FileConfigurationParser.getString(e, "network-check-list", config.getNetworkCheckList(), Validators.NO_CHECK));
        config.setNetworkCheckURLList(FileConfigurationParser.getString(e, "network-check-URL-list", config.getNetworkCheckURLList(), Validators.NO_CHECK));
        config.setNetworkCheckPeriod(FileConfigurationParser.getLong(e, "network-check-period", config.getNetworkCheckPeriod(), Validators.GT_ZERO));
        config.setNetworkCheckTimeout(FileConfigurationParser.getInteger(e, "network-check-timeout", config.getNetworkCheckTimeout(), Validators.GT_ZERO));
        config.setNetworkCheckNIC(FileConfigurationParser.getString(e, "network-check-NIC", config.getNetworkCheckNIC(), Validators.NO_CHECK));
        config.setNetworkCheckPing6Command(FileConfigurationParser.getString(e, "network-check-ping6-command", config.getNetworkCheckPing6Command(), Validators.NO_CHECK));
        config.setNetworkCheckPingCommand(FileConfigurationParser.getString(e, "network-check-ping-command", config.getNetworkCheckPingCommand(), Validators.NO_CHECK));
        config.setCriticalAnalyzer(FileConfigurationParser.getBoolean(e, "critical-analyzer", config.isCriticalAnalyzer()));
        config.setCriticalAnalyzerTimeout(FileConfigurationParser.getLong(e, "critical-analyzer-timeout", config.getCriticalAnalyzerTimeout(), Validators.GE_ZERO));
        config.setCriticalAnalyzerCheckPeriod(FileConfigurationParser.getLong(e, "critical-analyzer-check-period", config.getCriticalAnalyzerCheckPeriod(), Validators.GE_ZERO));
        config.setCriticalAnalyzerPolicy(CriticalAnalyzerPolicy.valueOf((String)FileConfigurationParser.getString(e, "critical-analyzer-policy", config.getCriticalAnalyzerPolicy().name(), Validators.NOT_NULL_OR_EMPTY)));
        config.setPageSyncTimeout(FileConfigurationParser.getInteger(e, "page-sync-timeout", config.getJournalBufferTimeout_NIO(), Validators.GE_ZERO));
        config.setSuppressSessionNotifications(FileConfigurationParser.getBoolean(e, "suppress-session-notifications", config.isSuppressSessionNotifications()));
        config.setLiteralMatchMarkers(FileConfigurationParser.getString(e, "literal-match-markers", config.getLiteralMatchMarkers(), Validators.NULL_OR_TWO_CHARACTERS));
        config.setLargeMessageSync(FileConfigurationParser.getBoolean(e, "large-message-sync", config.isLargeMessageSync()));
        config.setViewPermissionMethodMatchPattern(FileConfigurationParser.getString(e, "view-permission-method-match-pattern", config.getViewPermissionMethodMatchPattern(), Validators.NO_CHECK));
        config.setManagementMessageRbac(FileConfigurationParser.getBoolean(e, "management-message-rbac", config.isManagementMessageRbac()));
        config.setManagementRbacPrefix(FileConfigurationParser.getString(e, "management-rbac-prefix", config.getManagementRbacPrefix(), Validators.NO_CHECK));
        config.setMirrorPageTransaction(FileConfigurationParser.getBoolean(e, MIRROR_PAGE_TRANSACTION, config.isMirrorPageTransaction()));
        config.setMirrorAckManagerPageAttempts(FileConfigurationParser.getInteger(e, MIRROR_ACK_MANAGER_PAGE_ATTEMPTS, config.getMirrorAckManagerPageAttempts(), Validators.GT_ZERO));
        config.setMirrorAckManagerQueueAttempts(FileConfigurationParser.getInteger(e, MIRROR_ACK_MANAGER_QUEUE_ATTEMPTS, config.getMirrorAckManagerQueueAttempts(), Validators.GT_ZERO));
        config.setMirrorAckManagerRetryDelay(FileConfigurationParser.getInteger(e, MIRROR_ACK_MANAGER_RETRY_DELAY, config.getMirrorAckManagerRetryDelay(), Validators.GT_ZERO));
        config.setMirrorAckManagerWarnUnacked(FileConfigurationParser.getBoolean(e, MIRROR_ACK_MANAGER_WARN_UNACKED, config.isMirrorAckManagerWarnUnacked()));
        this.parseAddressSettings(e, config);
        this.parseResourceLimits(e, config);
        this.parseQueues(e, config);
        this.parseAddresses(e, config);
        this.parseSecurity(e, config);
        this.parseBrokerPlugins(e, config);
        this.parseMetrics(e, config);
        NodeList connectorServiceConfigs = e.getElementsByTagName("connector-service");
        ArrayList<ConnectorServiceConfiguration> configs = new ArrayList<ConnectorServiceConfiguration>();
        for (int i14 = 0; i14 < connectorServiceConfigs.getLength(); ++i14) {
            Element node = (Element)connectorServiceConfigs.item(i14);
            configs.add(this.parseConnectorService(node));
        }
        config.setConnectorServiceConfigurations(configs);
        NodeList wildCardConfiguration = e.getElementsByTagName("wildcard-addresses");
        if (wildCardConfiguration.getLength() > 0) {
            this.parseWildcardConfiguration((Element)wildCardConfiguration.item(0), config);
        }
    }

    private void parseJournalRetention(Element e, Configuration config) {
        NodeList retention = e.getElementsByTagName("journal-retention-directory");
        if (retention.getLength() != 0) {
            Element node = (Element)retention.item(0);
            String directory = node.getTextContent().trim();
            String storageLimitStr = FileConfigurationParser.getAttributeValue(node, "storage-limit");
            long storageLimit = storageLimitStr == null ? -1L : ByteUtil.convertTextBytes((String)storageLimitStr.trim());
            int period = FileConfigurationParser.getAttributeInteger(node, "period", -1, Validators.GT_ZERO);
            String unitStr = FileConfigurationParser.getAttributeValue(node, "unit");
            if (unitStr == null) {
                unitStr = "DAYS";
            }
            TimeUnit unit = TimeUnit.valueOf(unitStr.toUpperCase());
            config.setJournalRetentionDirectory(directory);
            config.setJournalRetentionMaxBytes(storageLimit);
            config.setJournalRetentionPeriod(unit, period);
            if (directory == null || directory.isEmpty()) {
                throw new IllegalArgumentException("journal-retention-directory=null");
            }
            if (storageLimit == -1L && period == -1) {
                throw new IllegalArgumentException("configure either storage-limit or period on journal-retention-directory");
            }
        }
    }

    private void parseSecurity(Element e, Configuration config) throws Exception {
        NodeList elements = e.getElementsByTagName("security-settings");
        if (elements.getLength() != 0) {
            Object securityItem;
            int i;
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName(SECURITY_ROLE_MAPPING_NAME);
            for (i = 0; i < list.getLength(); ++i) {
                Map<String, Set<String>> roleMappings = this.parseSecurityRoleMapping(list.item(i));
                for (Map.Entry<String, Set<String>> roleMapping : roleMappings.entrySet()) {
                    config.addSecurityRoleNameMapping(roleMapping.getKey(), roleMapping.getValue());
                }
            }
            list = node.getElementsByTagName(SECURITY_ELEMENT_NAME);
            for (i = 0; i < list.getLength(); ++i) {
                securityItem = this.parseSecurityRoles(list.item(i), config.getSecurityRoleNameMappings());
                config.putSecurityRoles((String)securityItem.getA(), (Set)securityItem.getB());
            }
            list = node.getElementsByTagName(SECURITY_PLUGIN_ELEMENT_NAME);
            for (i = 0; i < list.getLength(); ++i) {
                securityItem = this.parseSecuritySettingPlugins(list.item(i), config.isMaskPassword(), config.getPasswordCodec());
                config.addSecuritySettingPlugin(((SecuritySettingPlugin)securityItem.getA()).init((Map)securityItem.getB()));
            }
        }
    }

    private void parseBrokerPlugins(Element e, Configuration config) {
        NodeList brokerPlugins = e.getElementsByTagName(BROKER_PLUGINS_ELEMENT_NAME);
        if (brokerPlugins.getLength() != 0) {
            Element node = (Element)brokerPlugins.item(0);
            NodeList list = node.getElementsByTagName(BROKER_PLUGIN_ELEMENT_NAME);
            for (int i = 0; i < list.getLength(); ++i) {
                ActiveMQServerPlugin plugin = this.parseActiveMQServerPlugin(list.item(i));
                config.registerBrokerPlugin(plugin);
            }
        }
    }

    private ActiveMQServerPlugin parseActiveMQServerPlugin(Node item) {
        String clazz = item.getAttributes().getNamedItem("class-name").getNodeValue();
        Map<String, String> properties = this.getMapOfChildPropertyElements(item);
        ActiveMQServerPlugin serverPlugin = (ActiveMQServerPlugin)SecurityManagerShim.doPrivileged(() -> (ActiveMQServerPlugin)ClassloadingUtil.newInstanceFromClassLoader(FileConfigurationParser.class, (String)clazz, ActiveMQServerPlugin.class));
        serverPlugin.init(properties);
        return serverPlugin;
    }

    private Map<String, String> getMapOfChildPropertyElements(Node item) {
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("property")) continue;
            String key = FileConfigurationParser.getAttributeValue(child, "key");
            String value = FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME);
            properties.put(key, value);
        }
        return properties;
    }

    private void parseMetrics(Element e, Configuration config) {
        NodeList metrics = e.getElementsByTagName("metrics");
        NodeList metricsPlugin = e.getElementsByTagName("metrics-plugin");
        MetricsConfiguration metricsConfiguration = new MetricsConfiguration();
        if (metrics.getLength() != 0) {
            Element node = (Element)metrics.item(0);
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeName().equals("jvm-gc")) {
                    metricsConfiguration.setJvmGc(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("jvm-memory")) {
                    metricsConfiguration.setJvmMemory(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("jvm-threads")) {
                    metricsConfiguration.setJvmThread(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("netty-pool")) {
                    metricsConfiguration.setNettyPool(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("file-descriptors")) {
                    metricsConfiguration.setFileDescriptors(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("processor")) {
                    metricsConfiguration.setProcessor(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("uptime")) {
                    metricsConfiguration.setUptime(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("logging")) {
                    metricsConfiguration.setLogging(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("security-caches")) {
                    metricsConfiguration.setSecurityCaches(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (child.getNodeName().equals("executor-services")) {
                    metricsConfiguration.setExecutorServices(XMLUtil.parseBoolean((Node)child));
                    continue;
                }
                if (!child.getNodeName().equals("plugin")) continue;
                metricsConfiguration.setPlugin(this.parseMetricsPlugin(child, config));
            }
            if (metricsPlugin.getLength() != 0) {
                ActiveMQServerLogger.LOGGER.metricsPluginElementIgnored();
            }
        } else if (metricsPlugin.getLength() != 0) {
            ActiveMQServerLogger.LOGGER.metricsPluginElementDeprecated();
            metricsConfiguration.setPlugin(this.parseMetricsPlugin(metricsPlugin.item(0), config));
        }
        config.setMetricsConfiguration(metricsConfiguration);
    }

    private ActiveMQMetricsPlugin parseMetricsPlugin(Node item, Configuration config) {
        String clazz = item.getAttributes().getNamedItem("class-name").getNodeValue();
        Map<String, String> properties = this.getMapOfChildPropertyElements(item);
        ActiveMQMetricsPlugin metricsPlugin = (ActiveMQMetricsPlugin)SecurityManagerShim.doPrivileged(() -> (ActiveMQMetricsPlugin)ClassloadingUtil.newInstanceFromClassLoader(FileConfigurationParser.class, (String)clazz, ActiveMQMetricsPlugin.class));
        ActiveMQServerLogger.LOGGER.initializingMetricsPlugin(clazz, properties.toString());
        config.setMetricsPlugin(metricsPlugin.init(properties));
        return metricsPlugin;
    }

    private void parseQueues(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("queues");
        if (elements.getLength() != 0) {
            ActiveMQServerLogger.LOGGER.queuesElementDeprecated();
            Element node = (Element)elements.item(0);
            config.setQueueConfigs(this.parseQueueConfigurations(node, ActiveMQDefaultConfiguration.DEFAULT_ROUTING_TYPE));
        }
    }

    private List<QueueConfiguration> parseQueueConfigurations(Element node, RoutingType routingType) {
        ArrayList<QueueConfiguration> queueConfigurations = new ArrayList<QueueConfiguration>();
        NodeList list = node.getElementsByTagName("queue");
        for (int i = 0; i < list.getLength(); ++i) {
            QueueConfiguration queueConfig = this.parseQueueConfiguration(list.item(i));
            queueConfig.setRoutingType(routingType);
            queueConfigurations.add(queueConfig);
        }
        return queueConfigurations;
    }

    private void parseAddresses(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("addresses");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("address");
            for (int i = 0; i < list.getLength(); ++i) {
                config.addAddressConfiguration(this.parseAddressConfiguration(list.item(i)));
            }
        }
    }

    private void parseAddressSettings(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("address-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("address-setting");
            for (int i = 0; i < list.getLength(); ++i) {
                Pair<String, AddressSettings> newAddressSettings = this.parseAddressSettings(list.item(i));
                Map<String, AddressSettings> addressSettings = config.getAddressSettings();
                if (addressSettings.containsKey(newAddressSettings.getA())) {
                    ActiveMQServerLogger.LOGGER.duplicateAddressSettingMatch((String)newAddressSettings.getA());
                    continue;
                }
                config.getAddressSettings().put((String)newAddressSettings.getA(), (AddressSettings)newAddressSettings.getB());
            }
        }
    }

    private void parseResourceLimits(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("resource-limit-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("resource-limit-setting");
            for (int i = 0; i < list.getLength(); ++i) {
                config.addResourceLimitSettings(this.parseResourceLimitSettings(list.item(i)));
            }
        }
    }

    protected Pair<String, Set<Role>> parseSecurityRoles(Node node, Map<String, Set<String>> roleMappings) {
        String match = node.getAttributes().getNamedItem("match").getNodeValue();
        HashSet<Role> securityRoles = new HashSet<Role>();
        Pair securityMatch = new Pair((Object)match, securityRoles);
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> browseRoles = new ArrayList<String>();
        ArrayList<String> createAddressRoles = new ArrayList<String>();
        ArrayList<String> deleteAddressRoles = new ArrayList<String>();
        ArrayList<String> viewRoles = new ArrayList<String>();
        ArrayList<String> editRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String[] mappedRoles;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!PERMISSION_ELEMENT_NAME.equalsIgnoreCase(name)) continue;
            String type = FileConfigurationParser.getAttributeValue(child, TYPE_ATTR_NAME);
            String roleString = FileConfigurationParser.getAttributeValue(child, ROLES_ATTR_NAME);
            String[] roles = roleString.split(",");
            for (String role : mappedRoles = this.getMappedRoleNames(roles, roleMappings)) {
                if ("send".equals(type)) {
                    send.add(role.trim());
                } else if ("consume".equals(type)) {
                    consume.add(role.trim());
                } else if ("createDurableQueue".equals(type)) {
                    createDurableQueue.add(role.trim());
                } else if ("deleteDurableQueue".equals(type)) {
                    deleteDurableQueue.add(role.trim());
                } else if ("createNonDurableQueue".equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if ("deleteNonDurableQueue".equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (CREATETEMPQUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETETEMPQUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if ("manage".equals(type)) {
                    manageRoles.add(role.trim());
                } else if ("browse".equals(type)) {
                    browseRoles.add(role.trim());
                } else if ("createAddress".equals(type)) {
                    createAddressRoles.add(role.trim());
                } else if ("deleteAddress".equals(type)) {
                    deleteAddressRoles.add(role.trim());
                } else if ("view".equals(type)) {
                    viewRoles.add(role.trim());
                } else if ("edit".equals(type)) {
                    editRoles.add(role.trim());
                } else {
                    ActiveMQServerLogger.LOGGER.rolePermissionConfigurationError(type);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
        }
        for (String role : allRoles) {
            securityRoles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role), browseRoles.contains(role), createAddressRoles.contains(role), deleteAddressRoles.contains(role), viewRoles.contains(role), editRoles.contains(role)));
        }
        return securityMatch;
    }

    private String[] getMappedRoleNames(String[] roles, Map<String, Set<String>> roleMappings) {
        HashSet<String> mappedRoles = new HashSet<String>();
        for (String role : roles) {
            if (roleMappings.containsKey(role)) {
                mappedRoles.addAll((Collection)roleMappings.get(role));
            }
            mappedRoles.add(role);
        }
        return mappedRoles.toArray(new String[mappedRoles.size()]);
    }

    private Pair<SecuritySettingPlugin, Map<String, String>> parseSecuritySettingPlugins(Node item, Boolean maskPassword, String passwordCodec) throws Exception {
        String clazz = item.getAttributes().getNamedItem("class-name").getNodeValue();
        HashMap<String, String> settings = new HashMap<String, String>();
        NodeList children = item.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            String nodeName = child.getNodeName();
            if (!SETTING_ELEMENT_NAME.equalsIgnoreCase(nodeName)) continue;
            String settingName = FileConfigurationParser.getAttributeValue(child, NAME_ATTR_NAME);
            String settingValue = FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME);
            if (settingValue != null && PasswordMaskingUtil.isEncMasked((String)settingValue)) {
                settingValue = PasswordMaskingUtil.resolveMask((Boolean)maskPassword, (String)settingValue, (String)passwordCodec);
            }
            settings.put(settingName, settingValue);
        }
        SecuritySettingPlugin securitySettingPlugin = (SecuritySettingPlugin)SecurityManagerShim.doPrivileged(() -> (SecuritySettingPlugin)ClassloadingUtil.newInstanceFromClassLoader(FileConfigurationParser.class, (String)clazz, SecuritySettingPlugin.class));
        return new Pair((Object)securitySettingPlugin, settings);
    }

    private Map<String, Set<String>> parseSecurityRoleMapping(Node item) {
        HashMap<String, Set<String>> mappedRoleNames = new HashMap<String, Set<String>>();
        String externalRoleName = FileConfigurationParser.getAttributeValue(item, ROLE_FROM_ATTR_NAME).trim();
        HashSet internalRoleNames = new HashSet();
        Collections.addAll(internalRoleNames, FileConfigurationParser.getAttributeValue(item, ROLE_TO_ATTR_NAME).split(","));
        for (String internalRoleName : internalRoleNames) {
            if (mappedRoleNames.containsKey(internalRoleName = internalRoleName.trim())) {
                ((Set)mappedRoleNames.get(internalRoleName)).add(externalRoleName);
                continue;
            }
            HashSet<String> externalRoleNames = new HashSet<String>();
            externalRoleNames.add(externalRoleName);
            if (internalRoleName.isEmpty() || externalRoleName.isEmpty()) continue;
            mappedRoleNames.put(internalRoleName, externalRoleNames);
        }
        return mappedRoleNames;
    }

    protected Pair<String, AddressSettings> parseAddressSettings(Node node) {
        String match = FileConfigurationParser.getAttributeValue(node, "match");
        NodeList children = node.getChildNodes();
        AddressSettings addressSettings = new AddressSettings();
        Pair setting = new Pair((Object)match, (Object)addressSettings);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (DEAD_LETTER_ADDRESS_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDeadLetterAddress(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (EXPIRY_ADDRESS_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setExpiryAddress(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (EXPIRY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setExpiryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (MIN_EXPIRY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMinExpiryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (MAX_EXPIRY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxExpiryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (NO_EXPIRY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setNoExpiry(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedeliveryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (REDELIVERY_DELAY_MULTIPLIER_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedeliveryMultiplier(XMLUtil.parseDouble((Node)child));
                continue;
            }
            if (REDELIVERY_COLLISION_AVOIDANCE_FACTOR_NODE_NAME.equalsIgnoreCase(name)) {
                double redeliveryCollisionAvoidanceFactor = XMLUtil.parseDouble((Node)child);
                Validators.GE_ZERO.validate(REDELIVERY_COLLISION_AVOIDANCE_FACTOR_NODE_NAME, redeliveryCollisionAvoidanceFactor);
                Validators.LE_ONE.validate(REDELIVERY_COLLISION_AVOIDANCE_FACTOR_NODE_NAME, redeliveryCollisionAvoidanceFactor);
                addressSettings.setRedeliveryCollisionAvoidanceFactor(redeliveryCollisionAvoidanceFactor);
                continue;
            }
            if (MAX_REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxRedeliveryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (MAX_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxSizeBytes(ByteUtil.convertTextBytes((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (MAX_MESSAGES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxSizeMessages(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (MAX_SIZE_BYTES_REJECT_THRESHOLD_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxSizeBytesRejectThreshold(ByteUtil.convertTextBytes((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (PAGE_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageSizeBytes(Validators.POSITIVE_INT.validate(PAGE_SIZE_BYTES_NODE_NAME, ByteUtil.convertTextBytes((String)FileConfigurationParser.getTrimmedTextContent(child))).intValue());
                continue;
            }
            if (MAX_READ_PAGE_MESSAGES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxReadPageMessages(Validators.MINUS_ONE_OR_POSITIVE_INT.validate(MAX_READ_PAGE_MESSAGES_NODE_NAME, Long.parseLong(FileConfigurationParser.getTrimmedTextContent(child))).intValue());
                continue;
            }
            if (MAX_READ_PAGE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxReadPageBytes(Validators.MINUS_ONE_OR_POSITIVE_INT.validate(MAX_READ_PAGE_BYTES_NODE_NAME, ByteUtil.convertTextBytes((String)FileConfigurationParser.getTrimmedTextContent(child))).intValue());
                continue;
            }
            if (PREFETCH_PAGE_MESSAGES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPrefetchPageMessages(Validators.MINUS_ONE_OR_POSITIVE_INT.validate(PREFETCH_PAGE_MESSAGES_NODE_NAME, Long.parseLong(FileConfigurationParser.getTrimmedTextContent(child))).intValue());
                continue;
            }
            if (PREFETCH_PAGE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPrefetchPageBytes(Validators.MINUS_ONE_OR_POSITIVE_INT.validate(PREFETCH_PAGE_BYTES_NODE_NAME, ByteUtil.convertTextBytes((String)FileConfigurationParser.getTrimmedTextContent(child))).intValue());
                continue;
            }
            if (PAGE_MAX_CACHE_SIZE_NODE_NAME.equalsIgnoreCase(name)) {
                if (!this.printPageMaxSizeUsed) {
                    this.printPageMaxSizeUsed = true;
                    ActiveMQServerLogger.LOGGER.pageMaxSizeUsed();
                }
                addressSettings.setPageCacheMaxSize(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (PAGE_LIMIT_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageLimitBytes(Validators.MINUS_ONE_OR_GT_ZERO.validate(PAGE_LIMIT_BYTES_NODE_NAME, ByteUtil.convertTextBytes((String)FileConfigurationParser.getTrimmedTextContent(child))).longValue());
                continue;
            }
            if (PAGE_LIMIT_MESSAGES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageLimitMessages(Validators.MINUS_ONE_OR_GT_ZERO.validate(PAGE_LIMIT_MESSAGES_NODE_NAME, XMLUtil.parseLong((Node)child)).longValue());
                continue;
            }
            if (MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMessageCounterHistoryDayLimit(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setAddressFullMessagePolicy(Enum.valueOf(AddressFullMessagePolicy.class, Validators.ADDRESS_FULL_MESSAGE_POLICY_TYPE.validate(ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (DISK_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDiskFullMessagePolicy(Enum.valueOf(DiskFullMessagePolicy.class, Validators.DISK_FULL_MESSAGE_POLICY_TYPE.validate(DISK_FULL_MESSAGE_POLICY_NODE_NAME, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (PAGE_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageFullMessagePolicy(Enum.valueOf(PageFullMessagePolicy.class, Validators.PAGE_FULL_MESSAGE_POLICY_TYPE.validate(PAGE_FULL_MESSAGE_POLICY_NODE_NAME, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (LVQ_NODE_NAME.equalsIgnoreCase(name) || DEFAULT_LVQ_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDefaultLastValueQueue(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEFAULT_LVQ_KEY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDefaultLastValueKey(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (DEFAULT_NON_DESTRUCTIVE_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDefaultNonDestructive(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEFAULT_EXCLUSIVE_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDefaultExclusiveQueue(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEFAULT_GROUP_REBALANCE.equalsIgnoreCase(name)) {
                addressSettings.setDefaultGroupRebalance(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEFAULT_GROUP_REBALANCE_PAUSE_DISPATCH.equalsIgnoreCase(name)) {
                addressSettings.setDefaultGroupRebalancePauseDispatch(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEFAULT_GROUP_BUCKETS.equalsIgnoreCase(name)) {
                addressSettings.setDefaultGroupBuckets(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (DEFAULT_GROUP_FIRST_KEY.equalsIgnoreCase(name)) {
                addressSettings.setDefaultGroupFirstKey(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (MAX_DELIVERY_ATTEMPTS.equalsIgnoreCase(name)) {
                addressSettings.setMaxDeliveryAttempts(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (REDISTRIBUTION_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedistributionDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (SEND_TO_DLA_ON_NO_ROUTE.equalsIgnoreCase(name)) {
                addressSettings.setSendToDLAOnNoRoute(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (SLOW_CONSUMER_THRESHOLD_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setSlowConsumerThreshold(Validators.MINUS_ONE_OR_GT_ZERO.validate(SLOW_CONSUMER_THRESHOLD_NODE_NAME, XMLUtil.parseLong((Node)child)).longValue());
                continue;
            }
            if (SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit.valueOf(Validators.SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT.validate(SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT_NODE_NAME, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setSlowConsumerCheckPeriod(Validators.GT_ZERO.validate(SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME, XMLUtil.parseLong((Node)child)).longValue());
                continue;
            }
            if (SLOW_CONSUMER_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setSlowConsumerPolicy(Enum.valueOf(SlowConsumerPolicy.class, Validators.SLOW_CONSUMER_POLICY_TYPE.validate(SLOW_CONSUMER_POLICY_NODE_NAME, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (AUTO_CREATE_JMS_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateJmsQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_JMS_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteJmsQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_CREATE_JMS_TOPICS.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateJmsTopics(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_JMS_TOPICS.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteJmsTopics(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_CREATE_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_CREATED_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteCreatedQueues(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_QUEUES_DELAY.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteQueuesDelay(Validators.GE_ZERO.validate(AUTO_DELETE_QUEUES_DELAY, XMLUtil.parseLong((Node)child)).longValue());
                continue;
            }
            if (AUTO_DELETE_QUEUES_MESSAGE_COUNT.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteQueuesMessageCount((Long)Validators.MINUS_ONE_OR_GE_ZERO.validate(AUTO_DELETE_QUEUES_MESSAGE_COUNT, XMLUtil.parseLong((Node)child)));
                continue;
            }
            if (AUTO_DELETE_QUEUES_SKIP_USAGE_CHECK.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteQueuesSkipUsageCheck(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (CONFIG_DELETE_QUEUES.equalsIgnoreCase(name)) {
                addressSettings.setConfigDeleteQueues(Enum.valueOf(DeletionPolicy.class, Validators.DELETION_POLICY_TYPE.validate(CONFIG_DELETE_QUEUES, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (AUTO_CREATE_ADDRESSES.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateAddresses(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_ADDRESSES.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteAddresses(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (AUTO_DELETE_ADDRESSES_DELAY.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteAddressesDelay(Validators.GE_ZERO.validate(AUTO_DELETE_ADDRESSES_DELAY, XMLUtil.parseLong((Node)child)).longValue());
                continue;
            }
            if (AUTO_DELETE_ADDRESSES_SKIP_USAGE_CHECK.equalsIgnoreCase(name)) {
                addressSettings.setAutoDeleteAddressesSkipUsageCheck(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (CONFIG_DELETE_ADDRESSES.equalsIgnoreCase(name)) {
                addressSettings.setConfigDeleteAddresses(Enum.valueOf(DeletionPolicy.class, Validators.DELETION_POLICY_TYPE.validate(CONFIG_DELETE_ADDRESSES, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (CONFIG_DELETE_DIVERTS.equalsIgnoreCase(name)) {
                addressSettings.setConfigDeleteDiverts(Enum.valueOf(DeletionPolicy.class, Validators.DELETION_POLICY_TYPE.validate(CONFIG_DELETE_DIVERTS, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (MANAGEMENT_BROWSE_PAGE_SIZE.equalsIgnoreCase(name)) {
                addressSettings.setManagementBrowsePageSize(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (MANAGEMENT_MESSAGE_ATTRIBUTE_SIZE_LIMIT.equalsIgnoreCase(name)) {
                addressSettings.setManagementMessageAttributeSizeLimit(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (DEFAULT_PURGE_ON_NO_CONSUMERS.equalsIgnoreCase(name)) {
                addressSettings.setDefaultPurgeOnNoConsumers(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEFAULT_MAX_CONSUMERS.equalsIgnoreCase(name)) {
                addressSettings.setDefaultMaxConsumers(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (DEFAULT_CONSUMERS_BEFORE_DISPATCH.equalsIgnoreCase(name)) {
                addressSettings.setDefaultConsumersBeforeDispatch(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (DEFAULT_DELAY_BEFORE_DISPATCH.equalsIgnoreCase(name)) {
                addressSettings.setDefaultDelayBeforeDispatch(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (DEFAULT_QUEUE_ROUTING_TYPE.equalsIgnoreCase(name)) {
                addressSettings.setDefaultQueueRoutingType(RoutingType.valueOf((String)Validators.ROUTING_TYPE.validate(DEFAULT_QUEUE_ROUTING_TYPE, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (DEFAULT_ADDRESS_ROUTING_TYPE.equalsIgnoreCase(name)) {
                addressSettings.setDefaultAddressRoutingType(RoutingType.valueOf((String)Validators.ROUTING_TYPE.validate(DEFAULT_ADDRESS_ROUTING_TYPE, FileConfigurationParser.getTrimmedTextContent(child))));
                continue;
            }
            if (DEFAULT_CONSUMER_WINDOW_SIZE.equalsIgnoreCase(name)) {
                addressSettings.setDefaultConsumerWindowSize(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (DEFAULT_RING_SIZE.equalsIgnoreCase(name)) {
                addressSettings.setDefaultRingSize(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (RETROACTIVE_MESSAGE_COUNT.equalsIgnoreCase(name)) {
                addressSettings.setRetroactiveMessageCount(Validators.GE_ZERO.validate(RETROACTIVE_MESSAGE_COUNT, XMLUtil.parseLong((Node)child)).longValue());
                continue;
            }
            if (AUTO_CREATE_DEAD_LETTER_RESOURCES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateDeadLetterResources(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (DEAD_LETTER_QUEUE_PREFIX_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDeadLetterQueuePrefix(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (DEAD_LETTER_QUEUE_SUFFIX_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setDeadLetterQueueSuffix(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (AUTO_CREATE_EXPIRY_RESOURCES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setAutoCreateExpiryResources(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (EXPIRY_QUEUE_PREFIX_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setExpiryQueuePrefix(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (EXPIRY_QUEUE_SUFFIX_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setExpiryQueueSuffix(SimpleString.of((String)FileConfigurationParser.getTrimmedTextContent(child)));
                continue;
            }
            if (ENABLE_METRICS.equalsIgnoreCase(name)) {
                addressSettings.setEnableMetrics(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (ENABLE_INGRESS_TIMESTAMP.equalsIgnoreCase(name)) {
                addressSettings.setEnableIngressTimestamp(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (ID_CACHE_SIZE.equalsIgnoreCase(name)) {
                addressSettings.setIDCacheSize(Validators.GE_ZERO.validate(ID_CACHE_SIZE, XMLUtil.parseInt((Node)child)).intValue());
                continue;
            }
            if (!INITIAL_QUEUE_BUFFER_SIZE.equalsIgnoreCase(name)) continue;
            addressSettings.setInitialQueueBufferSize(Validators.POSITIVE_POWER_OF_TWO.validate(INITIAL_QUEUE_BUFFER_SIZE, XMLUtil.parseInt((Node)child)).intValue());
        }
        return setting;
    }

    protected ResourceLimitSettings parseResourceLimitSettings(Node node) {
        ResourceLimitSettings resourceLimitSettings = new ResourceLimitSettings();
        resourceLimitSettings.setMatch(SimpleString.of((String)FileConfigurationParser.getAttributeValue(node, "match")));
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (MAX_CONNECTIONS_NODE_NAME.equalsIgnoreCase(name)) {
                resourceLimitSettings.setMaxConnections(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (!MAX_QUEUES_NODE_NAME.equalsIgnoreCase(name)) continue;
            resourceLimitSettings.setMaxQueues(XMLUtil.parseInt((Node)child));
        }
        return resourceLimitSettings;
    }

    protected QueueConfiguration parseQueueConfiguration(Node node) {
        String name = FileConfigurationParser.getAttributeValue(node, NAME_ATTR_NAME);
        String address = null;
        String filterString = null;
        boolean durable = true;
        Integer maxConsumers = null;
        boolean purgeOnNoConsumers = ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
        String user = null;
        Boolean exclusive = null;
        Boolean groupRebalance = null;
        Boolean groupRebalancePauseDispatch = null;
        Integer groupBuckets = null;
        String groupFirstKey = null;
        Boolean lastValue = null;
        String lastValueKey = null;
        Boolean nonDestructive = null;
        Integer consumersBeforeDispatch = null;
        Long delayBeforeDispatch = null;
        Boolean enabled = null;
        Long ringSize = ActiveMQDefaultConfiguration.getDefaultRingSize();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (item.getNodeName().equals("max-consumers")) {
                maxConsumers = Validators.MAX_QUEUE_CONSUMERS.validate(name, Integer.parseInt(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("purge-on-no-consumers")) {
                purgeOnNoConsumers = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("exclusive")) {
                exclusive = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("group-rebalance")) {
                groupRebalance = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("group-rebalance-pause-dispatch")) {
                groupRebalancePauseDispatch = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("group-buckets")) {
                groupBuckets = Integer.parseInt(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("group-first-key")) {
                groupFirstKey = item.getNodeValue();
                continue;
            }
            if (item.getNodeName().equals("last-value")) {
                lastValue = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("last-value-key")) {
                lastValueKey = item.getNodeValue();
                continue;
            }
            if (item.getNodeName().equals("non-destructive")) {
                nonDestructive = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("consumers-before-dispatch")) {
                consumersBeforeDispatch = Integer.parseInt(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("delay-before-dispatch")) {
                delayBeforeDispatch = Long.parseLong(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("enabled")) {
                enabled = Boolean.parseBoolean(item.getNodeValue());
                continue;
            }
            if (!item.getNodeName().equals("ring-size")) continue;
            ringSize = Long.parseLong(item.getNodeValue());
        }
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("address")) {
                address = FileConfigurationParser.getTrimmedTextContent(child);
                continue;
            }
            if (child.getNodeName().equals("filter")) {
                filterString = FileConfigurationParser.getAttributeValue(child, "string");
                continue;
            }
            if (child.getNodeName().equals("durable")) {
                durable = XMLUtil.parseBoolean((Node)child);
                continue;
            }
            if (!child.getNodeName().equals("user")) continue;
            user = FileConfigurationParser.getTrimmedTextContent(child);
        }
        return QueueConfiguration.of((String)name).setAddress(address).setFilterString(filterString).setDurable(Boolean.valueOf(durable)).setMaxConsumers(maxConsumers).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setUser(user).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupRebalancePauseDispatch(groupRebalancePauseDispatch).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setLastValue(lastValue).setLastValueKey(lastValueKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setEnabled(enabled).setRingSize(ringSize);
    }

    protected CoreAddressConfiguration parseAddressConfiguration(Node node) {
        CoreAddressConfiguration addressConfiguration = new CoreAddressConfiguration();
        String name = FileConfigurationParser.getAttributeValue(node, NAME_ATTR_NAME);
        addressConfiguration.setName(name);
        ArrayList<QueueConfiguration> queueConfigurations = new ArrayList<QueueConfiguration>();
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            throw ActiveMQMessageBundle.BUNDLE.addressWithNoRoutingType(name);
        }
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("multicast")) {
                addressConfiguration.addRoutingType(RoutingType.MULTICAST);
                queueConfigurations.addAll(this.parseQueueConfigurations((Element)child, RoutingType.MULTICAST));
                continue;
            }
            if (!child.getNodeName().equals("anycast")) continue;
            addressConfiguration.addRoutingType(RoutingType.ANYCAST);
            queueConfigurations.addAll(this.parseQueueConfigurations((Element)child, RoutingType.ANYCAST));
        }
        for (QueueConfiguration queueConfiguration : queueConfigurations) {
            queueConfiguration.setAddress(name);
        }
        addressConfiguration.setQueueConfigs(queueConfigurations);
        return addressConfiguration;
    }

    private TransportConfiguration parseAcceptorTransportConfiguration(Element e, Configuration mainConfig) throws Exception {
        Node nameNode = e.getAttributes().getNamedItem(NAME_ATTR_NAME);
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String uri = e.getChildNodes().item(0).getNodeValue();
        List<TransportConfiguration> configurations = ConfigurationUtils.parseAcceptorURI(name, uri);
        Map params = configurations.get(0).getParams();
        if (mainConfig.isMaskPassword() != null) {
            params.put(ActiveMQDefaultConfiguration.getPropMaskPassword(), mainConfig.isMaskPassword());
            if (mainConfig.isMaskPassword().booleanValue() && mainConfig.getPasswordCodec() != null) {
                params.put(ActiveMQDefaultConfiguration.getPropPasswordCodec(), mainConfig.getPasswordCodec());
            }
        }
        return configurations.get(0);
    }

    private TransportConfiguration parseConnectorTransportConfiguration(Element e, Configuration mainConfig) throws Exception {
        Node nameNode = e.getAttributes().getNamedItem(NAME_ATTR_NAME);
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String uri = e.getChildNodes().item(0).getNodeValue();
        List<TransportConfiguration> configurations = ConfigurationUtils.parseConnectorURI(name, uri);
        Map params = configurations.get(0).getParams();
        if (mainConfig.isMaskPassword() != null) {
            params.put(ActiveMQDefaultConfiguration.getPropMaskPassword(), mainConfig.isMaskPassword());
            if (mainConfig.isMaskPassword().booleanValue() && mainConfig.getPasswordCodec() != null) {
                params.put(ActiveMQDefaultConfiguration.getPropPasswordCodec(), mainConfig.getPasswordCodec());
            }
        }
        return configurations.get(0);
    }

    private void parseStoreConfiguration(Element e, Configuration mainConfig) throws Exception {
        for (String storeType : STORE_TYPE_LIST) {
            NodeList storeNodeList = e.getElementsByTagName(storeType);
            if (storeNodeList.getLength() <= 0) continue;
            Element storeNode = (Element)storeNodeList.item(0);
            if (storeNode.getTagName().equals("database-store")) {
                mainConfig.setStoreConfiguration(this.createDatabaseStoreConfig(storeNode, mainConfig));
                continue;
            }
            if (!storeNode.getTagName().equals("file-store")) continue;
            mainConfig.setStoreConfiguration(this.createFileStoreConfig(storeNode));
        }
    }

    private void parseHAPolicyConfiguration(Element e, Configuration mainConfig) {
        for (String haType : HA_LIST) {
            Element noneNode;
            NodeList noneNodeList;
            NodeList backupNodeList;
            NodeList primaryNodeList;
            Element colocatedNode;
            NodeList colocatedNodeList;
            NodeList haNodeList = e.getElementsByTagName(haType);
            if (haNodeList.getLength() <= 0) continue;
            Element haNode = (Element)haNodeList.item(0);
            if (haNode.getTagName().equals("replication")) {
                colocatedNodeList = e.getElementsByTagName("colocated");
                if (colocatedNodeList.getLength() > 0) {
                    colocatedNode = (Element)colocatedNodeList.item(0);
                    mainConfig.setHAPolicyConfiguration(this.createColocatedHaPolicy(colocatedNode, true));
                    return;
                }
                primaryNodeList = e.getElementsByTagName("master");
                if (primaryNodeList.getLength() > 0) {
                    ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("master", "primary");
                    mainConfig.setHAPolicyConfiguration(this.createReplicationPrimaryHaPolicy((Element)primaryNodeList.item(0)));
                    return;
                }
                backupNodeList = e.getElementsByTagName("slave");
                if (backupNodeList.getLength() > 0) {
                    ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("slave", "backup");
                    mainConfig.setHAPolicyConfiguration(this.createReplicationBackupHaPolicy((Element)backupNodeList.item(0)));
                    return;
                }
                primaryNodeList = e.getElementsByTagName("primary");
                if (primaryNodeList.getLength() > 0) {
                    Element primaryNode = (Element)primaryNodeList.item(0);
                    if (primaryNode.getElementsByTagName("manager").item(0) != null) {
                        mainConfig.setHAPolicyConfiguration(this.createPluggableReplicationPrimaryHaPolicy(primaryNode));
                        return;
                    }
                    mainConfig.setHAPolicyConfiguration(this.createReplicationPrimaryHaPolicy(primaryNode));
                    return;
                }
                backupNodeList = e.getElementsByTagName("backup");
                if (backupNodeList.getLength() <= 0) continue;
                Element backupNode = (Element)backupNodeList.item(0);
                if (backupNode.getElementsByTagName("manager").item(0) != null) {
                    mainConfig.setHAPolicyConfiguration(this.createPluggableReplicationBackupHaPolicy(backupNode));
                    return;
                }
                mainConfig.setHAPolicyConfiguration(this.createReplicationBackupHaPolicy(backupNode));
                return;
            }
            if (haNode.getTagName().equals("shared-store")) {
                colocatedNodeList = e.getElementsByTagName("colocated");
                if (colocatedNodeList.getLength() > 0) {
                    colocatedNode = (Element)colocatedNodeList.item(0);
                    mainConfig.setHAPolicyConfiguration(this.createColocatedHaPolicy(colocatedNode, false));
                    return;
                }
                primaryNodeList = e.getElementsByTagName("master");
                if (primaryNodeList.getLength() > 0) {
                    ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("master", "primary");
                    mainConfig.setHAPolicyConfiguration(this.createSharedStorePrimaryHaPolicy((Element)primaryNodeList.item(0)));
                    return;
                }
                backupNodeList = e.getElementsByTagName("slave");
                if (backupNodeList.getLength() > 0) {
                    ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("slave", "backup");
                    mainConfig.setHAPolicyConfiguration(this.createSharedStoreBackupHaPolicy((Element)backupNodeList.item(0)));
                    return;
                }
                primaryNodeList = e.getElementsByTagName("primary");
                if (primaryNodeList.getLength() > 0) {
                    mainConfig.setHAPolicyConfiguration(this.createSharedStorePrimaryHaPolicy((Element)primaryNodeList.item(0)));
                    return;
                }
                backupNodeList = e.getElementsByTagName("backup");
                if (backupNodeList.getLength() <= 0) continue;
                mainConfig.setHAPolicyConfiguration(this.createSharedStoreBackupHaPolicy((Element)backupNodeList.item(0)));
                return;
            }
            if (haNode.getTagName().equals("live-only")) {
                noneNodeList = e.getElementsByTagName("live-only");
                noneNode = (Element)noneNodeList.item(0);
                mainConfig.setHAPolicyConfiguration(this.createPrimaryOnlyHaPolicy(noneNode));
                continue;
            }
            if (!haNode.getTagName().equals("primary-only")) continue;
            noneNodeList = e.getElementsByTagName("primary-only");
            noneNode = (Element)noneNodeList.item(0);
            mainConfig.setHAPolicyConfiguration(this.createPrimaryOnlyHaPolicy(noneNode));
        }
    }

    private PrimaryOnlyPolicyConfiguration createPrimaryOnlyHaPolicy(Element policyNode) {
        PrimaryOnlyPolicyConfiguration configuration = new PrimaryOnlyPolicyConfiguration();
        configuration.setScaleDownConfiguration(this.parseScaleDownConfig(policyNode));
        return configuration;
    }

    private ReplicatedPolicyConfiguration createReplicationPrimaryHaPolicy(Element policyNode) {
        ReplicatedPolicyConfiguration configuration = new ReplicatedPolicyConfiguration();
        configuration.setQuorumVoteWait(FileConfigurationParser.getInteger(policyNode, "quorum-vote-wait", ActiveMQDefaultConfiguration.getDefaultQuorumVoteWait(), Validators.GT_ZERO));
        String checkForLiveServer = "check-for-live-server";
        String checkForActiveServer = "check-for-active-server";
        if (policyNode.getElementsByTagName("check-for-live-server").getLength() > 0) {
            ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("check-for-live-server", "check-for-active-server");
            configuration.setCheckForActiveServer(FileConfigurationParser.getBoolean(policyNode, "check-for-live-server", configuration.isCheckForActiveServer()));
        } else {
            configuration.setCheckForActiveServer(FileConfigurationParser.getBoolean(policyNode, "check-for-active-server", configuration.isCheckForActiveServer()));
        }
        configuration.setGroupName(FileConfigurationParser.getString(policyNode, "group-name", configuration.getGroupName(), Validators.NO_CHECK));
        configuration.setClusterName(FileConfigurationParser.getString(policyNode, "cluster-name", configuration.getClusterName(), Validators.NO_CHECK));
        configuration.setMaxSavedReplicatedJournalsSize(FileConfigurationParser.getInteger(policyNode, "max-saved-replicated-journals-size", configuration.getMaxSavedReplicatedJournalsSize(), Validators.MINUS_ONE_OR_GE_ZERO));
        configuration.setInitialReplicationSyncTimeout(FileConfigurationParser.getLong(policyNode, "initial-replication-sync-timeout", configuration.getInitialReplicationSyncTimeout(), Validators.GT_ZERO));
        configuration.setVoteOnReplicationFailure(FileConfigurationParser.getBoolean(policyNode, "vote-on-replication-failure", configuration.getVoteOnReplicationFailure()));
        configuration.setVoteRetries(FileConfigurationParser.getInteger(policyNode, "vote-retries", configuration.getVoteRetries(), Validators.MINUS_ONE_OR_GE_ZERO));
        configuration.setVoteRetryWait(FileConfigurationParser.getLong(policyNode, "vote-retry-wait", configuration.getVoteRetryWait(), Validators.GT_ZERO));
        configuration.setRetryReplicationWait(FileConfigurationParser.getLong(policyNode, "retry-replication-wait", configuration.getVoteRetryWait(), Validators.GT_ZERO));
        configuration.setQuorumSize(FileConfigurationParser.getInteger(policyNode, "quorum-size", configuration.getQuorumSize(), Validators.MINUS_ONE_OR_GT_ZERO));
        return configuration;
    }

    private ReplicaPolicyConfiguration createReplicationBackupHaPolicy(Element policyNode) {
        ReplicaPolicyConfiguration configuration = new ReplicaPolicyConfiguration();
        configuration.setQuorumVoteWait(FileConfigurationParser.getInteger(policyNode, "quorum-vote-wait", ActiveMQDefaultConfiguration.getDefaultQuorumVoteWait(), Validators.GT_ZERO));
        configuration.setRestartBackup(FileConfigurationParser.getBoolean(policyNode, "restart-backup", configuration.isRestartBackup()));
        configuration.setGroupName(FileConfigurationParser.getString(policyNode, "group-name", configuration.getGroupName(), Validators.NO_CHECK));
        configuration.setAllowFailBack(FileConfigurationParser.getBoolean(policyNode, "allow-failback", configuration.isAllowFailBack()));
        configuration.setInitialReplicationSyncTimeout(FileConfigurationParser.getLong(policyNode, "initial-replication-sync-timeout", configuration.getInitialReplicationSyncTimeout(), Validators.GT_ZERO));
        configuration.setClusterName(FileConfigurationParser.getString(policyNode, "cluster-name", configuration.getClusterName(), Validators.NO_CHECK));
        configuration.setMaxSavedReplicatedJournalsSize(FileConfigurationParser.getInteger(policyNode, "max-saved-replicated-journals-size", configuration.getMaxSavedReplicatedJournalsSize(), Validators.MINUS_ONE_OR_GE_ZERO));
        configuration.setScaleDownConfiguration(this.parseScaleDownConfig(policyNode));
        configuration.setVoteOnReplicationFailure(FileConfigurationParser.getBoolean(policyNode, "vote-on-replication-failure", configuration.getVoteOnReplicationFailure()));
        configuration.setVoteRetries(FileConfigurationParser.getInteger(policyNode, "vote-retries", configuration.getVoteRetries(), Validators.MINUS_ONE_OR_GE_ZERO));
        configuration.setVoteRetryWait(FileConfigurationParser.getLong(policyNode, "vote-retry-wait", configuration.getVoteRetryWait(), Validators.GT_ZERO));
        configuration.setRetryReplicationWait(FileConfigurationParser.getLong(policyNode, "retry-replication-wait", configuration.getVoteRetryWait(), Validators.GT_ZERO));
        configuration.setQuorumSize(FileConfigurationParser.getInteger(policyNode, "quorum-size", configuration.getQuorumSize(), Validators.MINUS_ONE_OR_GT_ZERO));
        return configuration;
    }

    private ReplicationPrimaryPolicyConfiguration createPluggableReplicationPrimaryHaPolicy(Element policyNode) {
        ReplicationPrimaryPolicyConfiguration configuration = ReplicationPrimaryPolicyConfiguration.withDefault();
        configuration.setGroupName(FileConfigurationParser.getString(policyNode, "group-name", configuration.getGroupName(), Validators.NO_CHECK));
        configuration.setClusterName(FileConfigurationParser.getString(policyNode, "cluster-name", configuration.getClusterName(), Validators.NO_CHECK));
        configuration.setInitialReplicationSyncTimeout(FileConfigurationParser.getLong(policyNode, "initial-replication-sync-timeout", configuration.getInitialReplicationSyncTimeout(), Validators.GT_ZERO));
        configuration.setRetryReplicationWait(FileConfigurationParser.getLong(policyNode, "retry-replication-wait", configuration.getRetryReplicationWait(), Validators.GT_ZERO));
        configuration.setDistributedManagerConfiguration(this.createDistributedLockManagerConfiguration(policyNode));
        configuration.setCoordinationId(FileConfigurationParser.getString(policyNode, "coordination-id", configuration.getCoordinationId(), Validators.NOT_NULL_OR_EMPTY));
        configuration.setMaxSavedReplicatedJournalsSize(FileConfigurationParser.getInteger(policyNode, "max-saved-replicated-journals-size", configuration.getMaxSavedReplicatedJournalsSize(), Validators.MINUS_ONE_OR_GE_ZERO));
        return configuration;
    }

    private ReplicationBackupPolicyConfiguration createPluggableReplicationBackupHaPolicy(Element policyNode) {
        ReplicationBackupPolicyConfiguration configuration = ReplicationBackupPolicyConfiguration.withDefault();
        configuration.setGroupName(FileConfigurationParser.getString(policyNode, "group-name", configuration.getGroupName(), Validators.NO_CHECK));
        configuration.setAllowFailBack(FileConfigurationParser.getBoolean(policyNode, "allow-failback", configuration.isAllowFailBack()));
        configuration.setInitialReplicationSyncTimeout(FileConfigurationParser.getLong(policyNode, "initial-replication-sync-timeout", configuration.getInitialReplicationSyncTimeout(), Validators.GT_ZERO));
        configuration.setClusterName(FileConfigurationParser.getString(policyNode, "cluster-name", configuration.getClusterName(), Validators.NO_CHECK));
        configuration.setMaxSavedReplicatedJournalsSize(FileConfigurationParser.getInteger(policyNode, "max-saved-replicated-journals-size", configuration.getMaxSavedReplicatedJournalsSize(), Validators.MINUS_ONE_OR_GE_ZERO));
        configuration.setRetryReplicationWait(FileConfigurationParser.getLong(policyNode, "retry-replication-wait", configuration.getRetryReplicationWait(), Validators.GT_ZERO));
        configuration.setDistributedManagerConfiguration(this.createDistributedLockManagerConfiguration(policyNode));
        return configuration;
    }

    private DistributedLockManagerConfiguration createDistributedLockManagerConfiguration(Element policyNode) {
        HashMap<String, String> properties;
        Element managerNode = (Element)policyNode.getElementsByTagName("manager").item(0);
        String className = FileConfigurationParser.getString(managerNode, "class-name", ActiveMQDefaultConfiguration.getDefaultDistributedLockManagerClassName(), Validators.NO_CHECK);
        if (FileConfigurationParser.parameterExists(managerNode, "properties").booleanValue()) {
            NodeList propertyNodeList = managerNode.getElementsByTagName("property");
            int propertiesCount = propertyNodeList.getLength();
            properties = new HashMap(propertiesCount);
            for (int i = 0; i < propertiesCount; ++i) {
                Element propertyNode = (Element)propertyNodeList.item(i);
                String propertyName = propertyNode.getAttributeNode("key").getValue();
                String propertyValue = propertyNode.getAttributeNode(VALUE_ATTR_NAME).getValue();
                properties.put(propertyName, propertyValue);
            }
        } else {
            properties = new HashMap<String, String>(1);
        }
        return new DistributedLockManagerConfiguration(className, properties);
    }

    private SharedStorePrimaryPolicyConfiguration createSharedStorePrimaryHaPolicy(Element policyNode) {
        SharedStorePrimaryPolicyConfiguration configuration = new SharedStorePrimaryPolicyConfiguration();
        configuration.setFailoverOnServerShutdown(FileConfigurationParser.getBoolean(policyNode, "failover-on-shutdown", configuration.isFailoverOnServerShutdown()));
        configuration.setWaitForActivation(FileConfigurationParser.getBoolean(policyNode, "wait-for-activation", configuration.isWaitForActivation()));
        return configuration;
    }

    private SharedStoreBackupPolicyConfiguration createSharedStoreBackupHaPolicy(Element policyNode) {
        SharedStoreBackupPolicyConfiguration configuration = new SharedStoreBackupPolicyConfiguration();
        configuration.setAllowFailBack(FileConfigurationParser.getBoolean(policyNode, "allow-failback", configuration.isAllowFailBack()));
        configuration.setFailoverOnServerShutdown(FileConfigurationParser.getBoolean(policyNode, "failover-on-shutdown", configuration.isFailoverOnServerShutdown()));
        configuration.setRestartBackup(FileConfigurationParser.getBoolean(policyNode, "restart-backup", configuration.isRestartBackup()));
        configuration.setScaleDownConfiguration(this.parseScaleDownConfig(policyNode));
        return configuration;
    }

    private ColocatedPolicyConfiguration createColocatedHaPolicy(Element policyNode, boolean replicated) {
        Element backupNode;
        NodeList backupNodeList;
        NodeList primaryNodeList;
        ColocatedPolicyConfiguration configuration = new ColocatedPolicyConfiguration();
        boolean requestBackup = FileConfigurationParser.getBoolean(policyNode, "request-backup", configuration.isRequestBackup());
        configuration.setRequestBackup(requestBackup);
        int backupRequestRetries = FileConfigurationParser.getInteger(policyNode, "backup-request-retries", configuration.getBackupRequestRetries(), Validators.MINUS_ONE_OR_GE_ZERO);
        configuration.setBackupRequestRetries(backupRequestRetries);
        long backupRequestRetryInterval = FileConfigurationParser.getLong(policyNode, "backup-request-retry-interval", configuration.getBackupRequestRetryInterval(), Validators.GT_ZERO);
        configuration.setBackupRequestRetryInterval(backupRequestRetryInterval);
        int maxBackups = FileConfigurationParser.getInteger(policyNode, "max-backups", configuration.getMaxBackups(), Validators.GE_ZERO);
        configuration.setMaxBackups(maxBackups);
        int backupPortOffset = FileConfigurationParser.getInteger(policyNode, "backup-port-offset", configuration.getBackupPortOffset(), Validators.GT_ZERO);
        configuration.setBackupPortOffset(backupPortOffset);
        NodeList remoteConnectorNode = policyNode.getElementsByTagName("excludes");
        if (remoteConnectorNode != null && remoteConnectorNode.getLength() > 0) {
            NodeList remoteConnectors = remoteConnectorNode.item(0).getChildNodes();
            for (int i = 0; i < remoteConnectors.getLength(); ++i) {
                Node child = remoteConnectors.item(i);
                if (!child.getNodeName().equals("connector-ref")) continue;
                String connectorName = FileConfigurationParser.getTrimmedTextContent(child);
                configuration.getExcludedConnectors().add(connectorName);
            }
        }
        if ((primaryNodeList = policyNode.getElementsByTagName("master")).getLength() > 0) {
            ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("master", "primary");
            Element primaryNode = (Element)primaryNodeList.item(0);
            configuration.setPrimaryConfig(replicated ? this.createReplicationPrimaryHaPolicy(primaryNode) : this.createSharedStorePrimaryHaPolicy(primaryNode));
        }
        if ((backupNodeList = policyNode.getElementsByTagName("slave")).getLength() > 0) {
            ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption("slave", "backup");
            backupNode = (Element)backupNodeList.item(0);
            configuration.setBackupConfig(replicated ? this.createReplicationBackupHaPolicy(backupNode) : this.createSharedStoreBackupHaPolicy(backupNode));
        }
        if ((primaryNodeList = policyNode.getElementsByTagName("primary")).getLength() > 0) {
            Element primaryNode = (Element)primaryNodeList.item(0);
            configuration.setPrimaryConfig(replicated ? this.createReplicationPrimaryHaPolicy(primaryNode) : this.createSharedStorePrimaryHaPolicy(primaryNode));
        }
        if ((backupNodeList = policyNode.getElementsByTagName("backup")).getLength() > 0) {
            backupNode = (Element)backupNodeList.item(0);
            configuration.setBackupConfig(replicated ? this.createReplicationBackupHaPolicy(backupNode) : this.createSharedStoreBackupHaPolicy(backupNode));
        }
        return configuration;
    }

    private ScaleDownConfiguration parseScaleDownConfig(Element policyNode) {
        NodeList scaleDownNode = policyNode.getElementsByTagName("scale-down");
        if (scaleDownNode.getLength() > 0) {
            ScaleDownConfiguration scaleDownConfiguration = new ScaleDownConfiguration();
            Element scaleDownElement = (Element)scaleDownNode.item(0);
            scaleDownConfiguration.setEnabled(FileConfigurationParser.getBoolean(scaleDownElement, "enabled", scaleDownConfiguration.isEnabled()));
            scaleDownConfiguration.setCommitInterval(FileConfigurationParser.getInteger(scaleDownElement, "commit-interval", scaleDownConfiguration.getCommitInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
            NodeList discoveryGroupRef = scaleDownElement.getElementsByTagName("discovery-group-ref");
            if (discoveryGroupRef.item(0) != null) {
                scaleDownConfiguration.setDiscoveryGroup(discoveryGroupRef.item(0).getAttributes().getNamedItem("discovery-group-name").getNodeValue());
            }
            String scaleDownGroupName = FileConfigurationParser.getString(scaleDownElement, "group-name", scaleDownConfiguration.getGroupName(), Validators.NO_CHECK);
            scaleDownConfiguration.setGroupName(scaleDownGroupName);
            NodeList scaleDownConnectorNode = scaleDownElement.getElementsByTagName("connectors");
            if (scaleDownConnectorNode != null && scaleDownConnectorNode.getLength() > 0) {
                NodeList scaleDownConnectors = scaleDownConnectorNode.item(0).getChildNodes();
                for (int i = 0; i < scaleDownConnectors.getLength(); ++i) {
                    Node child = scaleDownConnectors.item(i);
                    if (!child.getNodeName().equals("connector-ref")) continue;
                    String connectorName = FileConfigurationParser.getTrimmedTextContent(child);
                    scaleDownConfiguration.getConnectors().add(connectorName);
                }
            }
            return scaleDownConfiguration;
        }
        return null;
    }

    private DatabaseStorageConfiguration createDatabaseStoreConfig(Element storeNode, Configuration mainConfig) throws Exception {
        DatabaseStorageConfiguration conf = new DatabaseStorageConfiguration();
        conf.setBindingsTableName(FileConfigurationParser.getString(storeNode, "bindings-table-name", conf.getBindingsTableName(), Validators.NO_CHECK));
        conf.setMessageTableName(FileConfigurationParser.getString(storeNode, "message-table-name", conf.getMessageTableName(), Validators.NO_CHECK));
        conf.setLargeMessageTableName(FileConfigurationParser.getString(storeNode, "large-message-table-name", conf.getLargeMessageTableName(), Validators.NO_CHECK));
        conf.setPageStoreTableName(FileConfigurationParser.getString(storeNode, "page-store-table-name", conf.getPageStoreTableName(), Validators.NO_CHECK));
        conf.setNodeManagerStoreTableName(FileConfigurationParser.getString(storeNode, "node-manager-store-table-name", conf.getNodeManagerStoreTableName(), Validators.NO_CHECK));
        String jdbcConnectionUrl = FileConfigurationParser.getString(storeNode, "jdbc-connection-url", conf.getJdbcConnectionUrl(), Validators.NO_CHECK);
        if (jdbcConnectionUrl != null && !jdbcConnectionUrl.startsWith("jdbc:")) {
            jdbcConnectionUrl = PasswordMaskingUtil.resolveMask((String)jdbcConnectionUrl, (String)mainConfig.getPasswordCodec());
        }
        conf.setJdbcConnectionUrl(jdbcConnectionUrl);
        conf.setJdbcDriverClassName(FileConfigurationParser.getString(storeNode, "jdbc-driver-class-name", conf.getJdbcDriverClassName(), Validators.NO_CHECK));
        conf.setJdbcNetworkTimeout(FileConfigurationParser.getInteger(storeNode, "jdbc-network-timeout", conf.getJdbcNetworkTimeout(), Validators.NO_CHECK));
        conf.setJdbcLockRenewPeriodMillis(FileConfigurationParser.getLong(storeNode, "jdbc-lock-renew-period", conf.getJdbcLockRenewPeriodMillis(), Validators.NO_CHECK));
        conf.setJdbcLockExpirationMillis(FileConfigurationParser.getLong(storeNode, "jdbc-lock-expiration", conf.getJdbcLockExpirationMillis(), Validators.NO_CHECK));
        conf.setJdbcJournalSyncPeriodMillis(FileConfigurationParser.getLong(storeNode, "jdbc-journal-sync-period", conf.getJdbcJournalSyncPeriodMillis(), Validators.NO_CHECK));
        conf.setJdbcAllowedTimeDiff(FileConfigurationParser.getLong(storeNode, "jdbc-allowed-time-diff", conf.getJdbcAllowedTimeDiff(), Validators.NO_CHECK));
        conf.setMaxPageSizeBytes(FileConfigurationParser.getTextBytesAsIntBytes(storeNode, "jdbc-max-page-size-bytes", conf.getMaxPageSizeBytes(), Validators.NO_CHECK));
        String jdbcUser = FileConfigurationParser.getString(storeNode, "jdbc-user", conf.getJdbcUser(), Validators.NO_CHECK);
        if (jdbcUser != null) {
            jdbcUser = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)jdbcUser, (String)mainConfig.getPasswordCodec());
        }
        conf.setJdbcUser(jdbcUser);
        String password = FileConfigurationParser.getString(storeNode, "jdbc-password", conf.getJdbcPassword(), Validators.NO_CHECK);
        if (password != null) {
            password = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)password, (String)mainConfig.getPasswordCodec());
        }
        conf.setJdbcPassword(password);
        conf.setDataSourceClassName(FileConfigurationParser.getString(storeNode, "data-source-class-name", conf.getDataSourceClassName(), Validators.NO_CHECK));
        if (FileConfigurationParser.parameterExists(storeNode, "data-source-properties").booleanValue()) {
            NodeList propertyNodeList = storeNode.getElementsByTagName("data-source-property");
            for (int i = 0; i < propertyNodeList.getLength(); ++i) {
                Element propertyNode = (Element)propertyNodeList.item(i);
                String propertyName = propertyNode.getAttributeNode("key").getValue();
                String propertyValue = propertyNode.getAttributeNode(VALUE_ATTR_NAME).getValue();
                if (propertyValue != null && PasswordMaskingUtil.isEncMasked((String)propertyValue)) {
                    propertyValue = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)propertyValue, (String)mainConfig.getPasswordCodec());
                }
                conf.addDataSourceProperty(propertyName, propertyValue);
            }
        }
        return conf;
    }

    private FileStorageConfiguration createFileStoreConfig(Element storeNode) {
        return new FileStorageConfiguration();
    }

    private void parseBroadcastGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute(NAME_ATTR_NAME);
        ArrayList<String> connectorNames = new ArrayList<String>();
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = FileConfigurationParser.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
            connectorNames.add(connectorName);
        }
        long broadcastPeriod = FileConfigurationParser.getLong(e, "broadcast-period", ActiveMQDefaultConfiguration.getDefaultBroadcastPeriod(), Validators.GT_ZERO);
        String localAddress = FileConfigurationParser.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = FileConfigurationParser.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = FileConfigurationParser.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = FileConfigurationParser.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = FileConfigurationParser.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactory = jgroupsFile != null ? new JGroupsFileBroadcastEndpointFactory().setFile(jgroupsFile).setChannelName(jgroupsChannel) : new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(localBindPort);
        BroadcastGroupConfiguration config = new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorNames).setEndpointFactory((BroadcastEndpointFactory)endpointFactory);
        mainConfig.getBroadcastGroupConfigurations().add(config);
    }

    private void parseDiscoveryGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute(NAME_ATTR_NAME);
        long discoveryInitialWaitTimeout = FileConfigurationParser.getLong(e, "initial-wait-timeout", 10000L, Validators.GT_ZERO);
        long refreshTimeout = FileConfigurationParser.getLong(e, "refresh-timeout", ActiveMQDefaultConfiguration.getDefaultBroadcastRefreshTimeout(), Validators.GT_ZERO);
        String localBindAddress = FileConfigurationParser.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = FileConfigurationParser.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = FileConfigurationParser.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = FileConfigurationParser.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = FileConfigurationParser.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactory = jgroupsFile != null ? new JGroupsFileBroadcastEndpointFactory().setFile(jgroupsFile).setChannelName(jgroupsChannel) : new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localBindAddress).setLocalBindPort(localBindPort);
        DiscoveryGroupConfiguration config = new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
        if (mainConfig.getDiscoveryGroupConfigurations().containsKey(name)) {
            ActiveMQServerLogger.LOGGER.discoveryGroupAlreadyDeployed(name);
            return;
        }
        mainConfig.getDiscoveryGroupConfigurations().put(name, config);
    }

    private void parseClusterConnectionConfigurationURI(Element e, Configuration mainConfig) throws Exception {
        String name = e.getAttribute(NAME_ATTR_NAME);
        String uri = e.getAttribute("address");
        ClusterConnectionConfiguration config = mainConfig.addClusterConfiguration(name, uri);
        logger.debug("Adding cluster connection :: {}", (Object)config);
    }

    private void parseAMQPBrokerConnections(Element e, Configuration mainConfig) throws Exception {
        String password;
        String name = e.getAttribute(NAME_ATTR_NAME);
        String uri = e.getAttribute("uri");
        int retryInterval = FileConfigurationParser.getAttributeInteger(e, "retry-interval", 5000, Validators.GT_ZERO);
        int reconnectAttempts = FileConfigurationParser.getAttributeInteger(e, "reconnect-attempts", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String user = FileConfigurationParser.getAttributeValue(e, "user");
        if (user != null && PasswordMaskingUtil.isEncMasked((String)user)) {
            user = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)user, (String)mainConfig.getPasswordCodec());
        }
        if ((password = FileConfigurationParser.getAttributeValue(e, "password")) != null && PasswordMaskingUtil.isEncMasked((String)password)) {
            password = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)password, (String)mainConfig.getPasswordCodec());
        }
        boolean autoStart = FileConfigurationParser.getBooleanAttribute(e, "auto-start", true);
        FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        AMQPBrokerConnectConfiguration config = new AMQPBrokerConnectConfiguration(name, uri);
        config.parseURI();
        config.setRetryInterval(retryInterval).setReconnectAttempts(reconnectAttempts).setUser(user).setPassword(password).setAutostart(autoStart);
        mainConfig.addAMQPConnection(config);
        NodeList senderList = e.getChildNodes();
        for (int i = 0; i < senderList.getLength(); ++i) {
            AMQPBrokerConnectionElement connectionElement;
            if (senderList.item(i).getNodeType() != 1) continue;
            Element e2 = (Element)senderList.item(i);
            AMQPBrokerConnectionAddressType nodeType = AMQPBrokerConnectionAddressType.valueOf(e2.getTagName().toUpperCase());
            if (nodeType == AMQPBrokerConnectionAddressType.MIRROR) {
                boolean messageAcks = FileConfigurationParser.getBooleanAttribute(e2, "message-acknowledgements", true);
                boolean queueCreation = FileConfigurationParser.getBooleanAttribute(e2, "queue-creation", true);
                boolean durable = FileConfigurationParser.getBooleanAttribute(e2, "durable", true);
                boolean queueRemoval = FileConfigurationParser.getBooleanAttribute(e2, "queue-removal", true);
                boolean sync = FileConfigurationParser.getBooleanAttribute(e2, "sync", false);
                String addressFilter = FileConfigurationParser.getAttributeValue(e2, "address-filter");
                AMQPMirrorBrokerConnectionElement amqpMirrorConnectionElement = new AMQPMirrorBrokerConnectionElement();
                amqpMirrorConnectionElement.setMessageAcknowledgements(messageAcks).setQueueCreation(queueCreation).setQueueRemoval(queueRemoval).setDurable(durable).setAddressFilter(addressFilter).setSync(sync);
                connectionElement = amqpMirrorConnectionElement;
                connectionElement.setType(AMQPBrokerConnectionAddressType.MIRROR);
                NodeList federationAttrs = e2.getChildNodes();
                for (int j = 0; j < federationAttrs.getLength(); ++j) {
                    Node mirrorElement = federationAttrs.item(j);
                    if (!mirrorElement.getNodeName().equals("property")) continue;
                    amqpMirrorConnectionElement.addProperty(FileConfigurationParser.getAttributeValue(mirrorElement, "key"), FileConfigurationParser.getAttributeValue(mirrorElement, VALUE_ATTR_NAME));
                }
            } else if (nodeType == AMQPBrokerConnectionAddressType.FEDERATION) {
                AMQPFederatedBrokerConnectionElement amqpFederationConnectionElement = new AMQPFederatedBrokerConnectionElement(name);
                NodeList federationAttrs = e2.getChildNodes();
                for (int j = 0; j < federationAttrs.getLength(); ++j) {
                    Node federationPolicy = federationAttrs.item(j);
                    if (federationPolicy.getNodeName().equals("remote-queue-policy")) {
                        amqpFederationConnectionElement.addRemoteQueuePolicy(this.parseAMQPFederatedFromQueuePolicy((Element)federationPolicy, mainConfig));
                        continue;
                    }
                    if (federationPolicy.getNodeName().equals("local-queue-policy")) {
                        amqpFederationConnectionElement.addLocalQueuePolicy(this.parseAMQPFederatedFromQueuePolicy((Element)federationPolicy, mainConfig));
                        continue;
                    }
                    if (federationPolicy.getNodeName().equals("remote-address-policy")) {
                        amqpFederationConnectionElement.addRemoteAddressPolicy(this.parseAMQPFederatedFromAddressPolicy((Element)federationPolicy, mainConfig));
                        continue;
                    }
                    if (federationPolicy.getNodeName().equals("local-address-policy")) {
                        amqpFederationConnectionElement.addLocalAddressPolicy(this.parseAMQPFederatedFromAddressPolicy((Element)federationPolicy, mainConfig));
                        continue;
                    }
                    if (!federationPolicy.getNodeName().equals("property")) continue;
                    amqpFederationConnectionElement.addProperty(FileConfigurationParser.getAttributeValue(federationPolicy, "key"), FileConfigurationParser.getAttributeValue(federationPolicy, VALUE_ATTR_NAME));
                }
                connectionElement = amqpFederationConnectionElement;
                connectionElement.setType(AMQPBrokerConnectionAddressType.FEDERATION);
            } else if (nodeType == AMQPBrokerConnectionAddressType.BRIDGE) {
                NodeList bridgeAttrs = e2.getChildNodes();
                String bridgeName = e2.hasAttribute(NAME_ATTR_NAME) ? e2.getAttribute(NAME_ATTR_NAME) : name;
                AMQPBridgeBrokerConnectionElement amqpBridgeConnectionElement = new AMQPBridgeBrokerConnectionElement(bridgeName);
                for (int j = 0; j < bridgeAttrs.getLength(); ++j) {
                    Node bridgePolicy = bridgeAttrs.item(j);
                    if (bridgePolicy.getNodeName().equals("bridge-from-address")) {
                        amqpBridgeConnectionElement.addBridgeFromAddressPolicy(this.parseAMQPBridgeAddressPolicy((Element)bridgePolicy, mainConfig));
                        continue;
                    }
                    if (bridgePolicy.getNodeName().equals("bridge-to-address")) {
                        amqpBridgeConnectionElement.addBridgeToAddressPolicy(this.parseAMQPBridgeAddressPolicy((Element)bridgePolicy, mainConfig));
                        continue;
                    }
                    if (bridgePolicy.getNodeName().equals("bridge-from-queue")) {
                        amqpBridgeConnectionElement.addBridgeFromQueuePolicy(this.parseAMQPBridgeQueuePolicy((Element)bridgePolicy, mainConfig));
                        continue;
                    }
                    if (bridgePolicy.getNodeName().equals("bridge-to-queue")) {
                        amqpBridgeConnectionElement.addBridgeToQueuePolicy(this.parseAMQPBridgeQueuePolicy((Element)bridgePolicy, mainConfig));
                        continue;
                    }
                    if (!bridgePolicy.getNodeName().equals("property")) continue;
                    amqpBridgeConnectionElement.addProperty(FileConfigurationParser.getAttributeValue(bridgePolicy, "key"), FileConfigurationParser.getAttributeValue(bridgePolicy, VALUE_ATTR_NAME));
                }
                connectionElement = amqpBridgeConnectionElement;
                connectionElement.setType(AMQPBrokerConnectionAddressType.BRIDGE);
            } else {
                String match = FileConfigurationParser.getAttributeValue(e2, "address-match");
                String queue = FileConfigurationParser.getAttributeValue(e2, "queue-name");
                connectionElement = new AMQPBrokerConnectionElement();
                connectionElement.setMatchAddress(SimpleString.of((String)match)).setType(nodeType);
                connectionElement.setQueueName(SimpleString.of((String)queue));
            }
            config.addElement(connectionElement);
        }
        logger.debug("Adding AMQP connection :: {}", (Object)config);
    }

    private AMQPFederationAddressPolicyElement parseAMQPFederatedFromAddressPolicy(Element policyNod, Configuration mainConfig) throws Exception {
        AMQPFederationAddressPolicyElement config = new AMQPFederationAddressPolicyElement();
        config.setName(policyNod.getAttribute(NAME_ATTR_NAME));
        NamedNodeMap attributes = policyNod.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (item.getNodeName().equals("max-hops")) {
                config.setMaxHops(Validators.MINUS_ONE_OR_GE_ZERO.validate(item.getNodeName(), Integer.parseInt(item.getNodeValue())).intValue());
                continue;
            }
            if (item.getNodeName().equals("auto-delete")) {
                config.setAutoDelete(Boolean.parseBoolean(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("auto-delete-delay")) {
                config.setAutoDeleteDelay(Validators.GE_ZERO.validate("auto-delete-delay", Long.parseLong(item.getNodeValue())).longValue());
                continue;
            }
            if (item.getNodeName().equals("auto-delete-message-count")) {
                config.setAutoDeleteMessageCount(Validators.MINUS_ONE_OR_GE_ZERO.validate("auto-delete-message-count", Long.parseLong(item.getNodeValue())).longValue());
                continue;
            }
            if (!item.getNodeName().equals("enable-divert-bindings")) continue;
            config.setEnableDivertBindings(Boolean.parseBoolean(item.getNodeValue()));
        }
        NodeList children = policyNod.getChildNodes();
        String transformerClassName = FileConfigurationParser.getString(policyNod, "transformer-class-name", null, Validators.NO_CHECK);
        if (transformerClassName != null && !transformerClassName.isEmpty()) {
            config.setTransformerConfiguration(this.getTransformerConfiguration(transformerClassName));
        }
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("include")) {
                config.addToIncludes(((Element)child).getAttribute("address-match"));
                continue;
            }
            if (child.getNodeName().equals("exclude")) {
                config.addToExcludes(((Element)child).getAttribute("address-match"));
                continue;
            }
            if (child.getNodeName().equals("transformer")) {
                config.setTransformerConfiguration(this.getTransformerConfiguration(child));
                continue;
            }
            if (!child.getNodeName().equals("property")) continue;
            config.addProperty(FileConfigurationParser.getAttributeValue(child, "key"), FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME));
        }
        return config;
    }

    private AMQPFederationQueuePolicyElement parseAMQPFederatedFromQueuePolicy(Element policyNod, Configuration mainConfig) throws Exception {
        AMQPFederationQueuePolicyElement config = new AMQPFederationQueuePolicyElement();
        config.setName(policyNod.getAttribute(NAME_ATTR_NAME));
        NamedNodeMap attributes = policyNod.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (item.getNodeName().equals("include-federated")) {
                config.setIncludeFederated(Boolean.parseBoolean(item.getNodeValue()));
                continue;
            }
            if (!item.getNodeName().equals("priority-adjustment")) continue;
            config.setPriorityAdjustment(Integer.parseInt(item.getNodeValue()));
        }
        NodeList children = policyNod.getChildNodes();
        String transformerClassName = FileConfigurationParser.getString(policyNod, "transformer-class-name", null, Validators.NO_CHECK);
        if (transformerClassName != null && !transformerClassName.isEmpty()) {
            config.setTransformerConfiguration(this.getTransformerConfiguration(transformerClassName));
        }
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("include")) {
                config.addToIncludes(((Element)child).getAttribute("address-match"), ((Element)child).getAttribute("queue-match"));
                continue;
            }
            if (child.getNodeName().equals("exclude")) {
                config.addToExcludes(((Element)child).getAttribute("address-match"), ((Element)child).getAttribute("queue-match"));
                continue;
            }
            if (child.getNodeName().equals("transformer")) {
                config.setTransformerConfiguration(this.getTransformerConfiguration(child));
                continue;
            }
            if (!child.getNodeName().equals("property")) continue;
            config.addProperty(FileConfigurationParser.getAttributeValue(child, "key"), FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME));
        }
        return config;
    }

    private AMQPBridgeAddressPolicyElement parseAMQPBridgeAddressPolicy(Element policyNod, Configuration mainConfig) throws Exception {
        AMQPBridgeAddressPolicyElement config = new AMQPBridgeAddressPolicyElement();
        config.setName(policyNod.getAttribute(NAME_ATTR_NAME));
        NamedNodeMap attributes = policyNod.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String capabilities;
            Node item = attributes.item(i);
            if (item.getNodeName().equals("filter")) {
                String filterString = item.getNodeValue();
                try {
                    SelectorParser.parse((String)filterString);
                }
                catch (Exception ex) {
                    logger.debug("Filter expression in bridge address policy {} has invalid syntax: {}", new Object[]{config.getName(), filterString, ex});
                    throw ex;
                }
                config.setFilter(filterString);
                continue;
            }
            if (item.getNodeName().equals("priority")) {
                config.setPriority(Integer.parseInt(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("enable-divert-bindings")) {
                config.setIncludeDivertBindings(Boolean.parseBoolean(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("use-durable-subscriptions")) {
                config.setUseDurableSubscriptions(Boolean.parseBoolean(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("remote-address")) {
                config.setRemoteAddress(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("remote-address-prefix")) {
                config.setRemoteAddressPrefix(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("remote-address-suffix")) {
                config.setRemoteAddressSuffix(item.getNodeValue());
                continue;
            }
            if (!item.getNodeName().equals("remote-terminus-capabilities") || (capabilities = item.getNodeValue()) == null || capabilities.isBlank()) continue;
            config.setRemoteTerminusCapabilities(capabilities.split(","));
        }
        NodeList children = policyNod.getChildNodes();
        String transformerClassName = FileConfigurationParser.getString(policyNod, "transformer-class-name", null, Validators.NO_CHECK);
        if (transformerClassName != null && !transformerClassName.isEmpty()) {
            config.setTransformerConfiguration(this.getTransformerConfiguration(transformerClassName));
        }
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("include")) {
                config.addToIncludes(((Element)child).getAttribute("address-match"));
                continue;
            }
            if (child.getNodeName().equals("exclude")) {
                config.addToExcludes(((Element)child).getAttribute("address-match"));
                continue;
            }
            if (child.getNodeName().equals("transformer")) {
                config.setTransformerConfiguration(this.getTransformerConfiguration(child));
                continue;
            }
            if (!child.getNodeName().equals("property")) continue;
            config.addProperty(FileConfigurationParser.getAttributeValue(child, "key"), FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME));
        }
        return config;
    }

    private AMQPBridgeQueuePolicyElement parseAMQPBridgeQueuePolicy(Element policyNod, Configuration mainConfig) throws Exception {
        AMQPBridgeQueuePolicyElement config = new AMQPBridgeQueuePolicyElement();
        config.setName(policyNod.getAttribute(NAME_ATTR_NAME));
        NamedNodeMap attributes = policyNod.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String capabilities;
            Node item = attributes.item(i);
            if (item.getNodeName().equals("filter")) {
                String filterString = item.getNodeValue();
                try {
                    SelectorParser.parse((String)filterString);
                }
                catch (Exception ex) {
                    logger.debug("Filter expression in bridge queue policy {} has invalid syntax: {}", new Object[]{config.getName(), filterString, ex});
                    throw ex;
                }
                config.setFilter(filterString);
                continue;
            }
            if (item.getNodeName().equals("priority")) {
                config.setPriority(Integer.parseInt(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("priority-adjustment")) {
                config.setPriorityAdjustment(Integer.parseInt(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("remote-address")) {
                config.setRemoteAddress(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("remote-address-prefix")) {
                config.setRemoteAddressPrefix(item.getNodeValue());
                continue;
            }
            if (item.getNodeName().equals("remote-address-suffix")) {
                config.setRemoteAddressSuffix(item.getNodeValue());
                continue;
            }
            if (!item.getNodeName().equals("remote-terminus-capabilities") || (capabilities = item.getNodeValue()) == null || capabilities.isBlank()) continue;
            config.setRemoteTerminusCapabilities(capabilities.split(","));
        }
        NodeList children = policyNod.getChildNodes();
        String transformerClassName = FileConfigurationParser.getString(policyNod, "transformer-class-name", null, Validators.NO_CHECK);
        if (transformerClassName != null && !transformerClassName.isEmpty()) {
            config.setTransformerConfiguration(this.getTransformerConfiguration(transformerClassName));
        }
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("include")) {
                config.addToIncludes(((Element)child).getAttribute("address-match"), ((Element)child).getAttribute("queue-match"));
                continue;
            }
            if (child.getNodeName().equals("exclude")) {
                config.addToExcludes(((Element)child).getAttribute("address-match"), ((Element)child).getAttribute("queue-match"));
                continue;
            }
            if (child.getNodeName().equals("transformer")) {
                config.setTransformerConfiguration(this.getTransformerConfiguration(child));
                continue;
            }
            if (!child.getNodeName().equals("property")) continue;
            config.addProperty(FileConfigurationParser.getAttributeValue(child, "key"), FileConfigurationParser.getAttributeValue(child, VALUE_ATTR_NAME));
        }
        return config;
    }

    private void parseClusterConnectionConfiguration(Element e, Configuration mainConfig) throws Exception {
        boolean forwardWhenNoConsumers;
        String name = e.getAttribute(NAME_ATTR_NAME);
        String address = FileConfigurationParser.getString(e, "address", "", Validators.NO_CHECK);
        String connectorName = FileConfigurationParser.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
        if (!mainConfig.getConnectorConfigurations().containsKey(connectorName)) {
            ActiveMQServerLogger.LOGGER.connectorRefNotFound(connectorName, name);
            return;
        }
        boolean duplicateDetection = FileConfigurationParser.getBoolean(e, "use-duplicate-detection", ActiveMQDefaultConfiguration.isDefaultClusterDuplicateDetection());
        MessageLoadBalancingType messageLoadBalancingType = FileConfigurationParser.parameterExists(e, "forward-when-no-consumers").booleanValue() ? ((forwardWhenNoConsumers = FileConfigurationParser.getBoolean(e, "forward-when-no-consumers", ActiveMQDefaultConfiguration.isDefaultClusterForwardWhenNoConsumers()).booleanValue()) ? MessageLoadBalancingType.STRICT : MessageLoadBalancingType.ON_DEMAND) : Enum.valueOf(MessageLoadBalancingType.class, FileConfigurationParser.getString(e, "message-load-balancing", ActiveMQDefaultConfiguration.getDefaultClusterMessageLoadBalancingType(), Validators.MESSAGE_LOAD_BALANCING_TYPE));
        int maxHops = FileConfigurationParser.getInteger(e, "max-hops", ActiveMQDefaultConfiguration.getDefaultClusterMaxHops(), Validators.GE_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(e, "check-period", ActiveMQDefaultConfiguration.getDefaultClusterFailureCheckPeriod(), Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(e, "connection-ttl", ActiveMQDefaultConfiguration.getDefaultClusterConnectionTtl(), Validators.GT_ZERO);
        long retryInterval = FileConfigurationParser.getLong(e, "retry-interval", ActiveMQDefaultConfiguration.getDefaultClusterRetryInterval(), Validators.GT_ZERO);
        long callTimeout = FileConfigurationParser.getLong(e, "call-timeout", ActiveMQDefaultConfiguration.getDefaultClusterCallTimeout(), Validators.GT_ZERO);
        long callFailoverTimeout = FileConfigurationParser.getLong(e, "call-failover-timeout", ActiveMQDefaultConfiguration.getDefaultClusterCallFailoverTimeout(), Validators.MINUS_ONE_OR_GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(e, "retry-interval-multiplier", ActiveMQDefaultConfiguration.getDefaultClusterRetryIntervalMultiplier(), Validators.GT_ZERO);
        int minLargeMessageSize = FileConfigurationParser.getTextBytesAsIntBytes(e, "min-large-message-size", 102400, Validators.POSITIVE_INT);
        long maxRetryInterval = FileConfigurationParser.getLong(e, "max-retry-interval", ActiveMQDefaultConfiguration.getDefaultClusterMaxRetryInterval(), Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(e, "initial-connect-attempts", ActiveMQDefaultConfiguration.getDefaultClusterInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(e, "reconnect-attempts", ActiveMQDefaultConfiguration.getDefaultClusterReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int confirmationWindowSize = FileConfigurationParser.getTextBytesAsIntBytes(e, "confirmation-window-size", ActiveMQDefaultConfiguration.getDefaultClusterConfirmationWindowSize(), Validators.POSITIVE_INT);
        int producerWindowSize = FileConfigurationParser.getTextBytesAsIntBytes(e, "producer-window-size", ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize(), Validators.MINUS_ONE_OR_POSITIVE_INT);
        long clusterNotificationInterval = FileConfigurationParser.getLong(e, "notification-interval", ActiveMQDefaultConfiguration.getDefaultClusterNotificationInterval(), Validators.GT_ZERO);
        int clusterNotificationAttempts = FileConfigurationParser.getInteger(e, "notification-attempts", ActiveMQDefaultConfiguration.getDefaultClusterNotificationAttempts(), Validators.GT_ZERO);
        int topologyScannerAttempts = FileConfigurationParser.getInteger(e, "topology-scanner-attempts", ActiveMQDefaultConfiguration.getClusterTopologyScannerAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        String discoveryGroupName = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        boolean allowDirectConnectionsOnly = false;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            Node attr = child.getAttributes().getNamedItem("allow-direct-connections-only");
            if (attr != null) {
                allowDirectConnectionsOnly = "true".equalsIgnoreCase(attr.getNodeValue()) || allowDirectConnectionsOnly;
            }
            this.getStaticConnectors(staticConnectorNames, child);
        }
        String clientId = FileConfigurationParser.getString(e, "client-id", null, Validators.NO_CHECK);
        ClusterConnectionConfiguration config = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(connectorName).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout).setDuplicateDetection(duplicateDetection).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setAllowDirectConnectionsOnly(allowDirectConnectionsOnly).setClusterNotificationInterval(clusterNotificationInterval).setClusterNotificationAttempts(clusterNotificationAttempts).setClientId(clientId).setTopologyScannerAttempts(topologyScannerAttempts);
        if (discoveryGroupName == null) {
            config.setStaticConnectors(staticConnectorNames);
        } else {
            config.setDiscoveryGroupName(discoveryGroupName);
        }
        mainConfig.getClusterConfigurations().add(config);
    }

    private void parseGroupingHandlerConfiguration(Element node, Configuration mainConfiguration) {
        String name = node.getAttribute(NAME_ATTR_NAME);
        String type = FileConfigurationParser.getString(node, TYPE_ATTR_NAME, null, Validators.NOT_NULL_OR_EMPTY);
        String address = FileConfigurationParser.getString(node, "address", "", Validators.NO_CHECK);
        Integer timeout = FileConfigurationParser.getInteger(node, "timeout", ActiveMQDefaultConfiguration.getDefaultGroupingHandlerTimeout(), Validators.GT_ZERO);
        Long groupTimeout = FileConfigurationParser.getLong(node, "group-timeout", ActiveMQDefaultConfiguration.getDefaultGroupingHandlerGroupTimeout(), Validators.MINUS_ONE_OR_GT_ZERO);
        Long reaperPeriod = FileConfigurationParser.getLong(node, "reaper-period", ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod(), Validators.GT_ZERO);
        mainConfiguration.setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(SimpleString.of((String)name)).setType(type.equals(GroupingHandlerConfiguration.TYPE.LOCAL.getType()) ? GroupingHandlerConfiguration.TYPE.LOCAL : GroupingHandlerConfiguration.TYPE.REMOTE).setAddress(SimpleString.of((String)address)).setTimeout(timeout.intValue()).setGroupTimeout(groupTimeout).setReaperPeriod(reaperPeriod));
    }

    private TransformerConfiguration getTransformerConfiguration(Node node) {
        Element element = (Element)node;
        String className = FileConfigurationParser.getString(element, "class-name", null, Validators.NO_CHECK);
        Map<String, String> properties = this.getMapOfChildPropertyElements(element);
        return new TransformerConfiguration(className).setProperties(properties);
    }

    private TransformerConfiguration getTransformerConfiguration(String transformerClassName) {
        return new TransformerConfiguration(transformerClassName).setProperties(Collections.emptyMap());
    }

    private void parseBridgeConfiguration(Element brNode, Configuration mainConfig) throws Exception {
        String name = brNode.getAttribute(NAME_ATTR_NAME);
        String queueName = FileConfigurationParser.getString(brNode, "queue-name", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = FileConfigurationParser.getString(brNode, "forwarding-address", null, Validators.NO_CHECK);
        String transformerClassName = FileConfigurationParser.getString(brNode, "transformer-class-name", null, Validators.NO_CHECK);
        int confirmationWindowSize = FileConfigurationParser.getTextBytesAsIntBytes(brNode, "confirmation-window-size", ActiveMQDefaultConfiguration.getDefaultBridgeConfirmationWindowSize(), Validators.MINUS_ONE_OR_POSITIVE_INT);
        int producerWindowSize = FileConfigurationParser.getTextBytesAsIntBytes(brNode, "producer-window-size", ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize(), Validators.MINUS_ONE_OR_POSITIVE_INT);
        long retryInterval = FileConfigurationParser.getLong(brNode, "retry-interval", 2000L, Validators.GT_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(brNode, "check-period", ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(brNode, "connection-ttl", ActiveMQClient.DEFAULT_CONNECTION_TTL, Validators.GT_ZERO);
        int minLargeMessageSize = FileConfigurationParser.getTextBytesAsIntBytes(brNode, "min-large-message-size", 102400, Validators.POSITIVE_INT);
        long maxRetryInterval = FileConfigurationParser.getLong(brNode, "max-retry-interval", ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, Validators.GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(brNode, "retry-interval-multiplier", ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(brNode, "initial-connect-attempts", ActiveMQDefaultConfiguration.getDefaultBridgeInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(brNode, "reconnect-attempts", ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttemptsSameNode = FileConfigurationParser.getInteger(brNode, "reconnect-attempts-same-node", ActiveMQDefaultConfiguration.getDefaultBridgeConnectSameNode(), Validators.MINUS_ONE_OR_GE_ZERO);
        boolean useDuplicateDetection = FileConfigurationParser.getBoolean(brNode, "use-duplicate-detection", ActiveMQDefaultConfiguration.isDefaultBridgeDuplicateDetection());
        String user = FileConfigurationParser.getString(brNode, "user", ActiveMQDefaultConfiguration.getDefaultClusterUser(), Validators.NO_CHECK);
        ComponentConfigurationRoutingType routingType = ComponentConfigurationRoutingType.valueOf((String)FileConfigurationParser.getString(brNode, "routing-type", ActiveMQDefaultConfiguration.getDefaultBridgeRoutingType(), Validators.COMPONENT_ROUTING_TYPE));
        int concurrency = FileConfigurationParser.getInteger(brNode, "concurrency", ActiveMQDefaultConfiguration.getDefaultBridgeConcurrency(), Validators.GT_ZERO);
        long pendingAckTimeout = FileConfigurationParser.getLong(brNode, "pending-ack-timeout", ActiveMQDefaultConfiguration.getDefaultBridgePendingAckTimeout(), Validators.GT_ZERO);
        String clientId = FileConfigurationParser.getString(brNode, "client-id", null, Validators.NO_CHECK);
        NodeList clusterPassNodes = brNode.getElementsByTagName("password");
        String password = null;
        if (clusterPassNodes.getLength() > 0) {
            Node passNode = clusterPassNodes.item(0);
            password = passNode.getTextContent();
        }
        password = password != null ? PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)password, (String)mainConfig.getPasswordCodec()) : ActiveMQDefaultConfiguration.getDefaultClusterPassword();
        boolean ha = FileConfigurationParser.getBoolean(brNode, "ha", false);
        TransformerConfiguration transformerConfiguration = null;
        String filterString = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        String discoveryGroupName = null;
        NodeList children = brNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("static-connectors")) {
                this.getStaticConnectors(staticConnectorNames, child);
                continue;
            }
            if (!child.getNodeName().equals("transformer")) continue;
            transformerConfiguration = this.getTransformerConfiguration(child);
        }
        if (transformerConfiguration == null && transformerClassName != null) {
            transformerConfiguration = this.getTransformerConfiguration(transformerClassName);
        }
        BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setTransformerConfiguration(transformerConfiguration).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setMaxRetryInterval(maxRetryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setReconnectAttemptsOnSameNode(reconnectAttemptsSameNode).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setHA(ha).setUser(user).setPassword(password).setRoutingType(routingType).setConcurrency(concurrency).setPendingAckTimeout(pendingAckTimeout).setClientId(clientId);
        if (!staticConnectorNames.isEmpty()) {
            config.setStaticConnectors(staticConnectorNames);
        } else {
            config.setDiscoveryGroupName(discoveryGroupName);
        }
        mainConfig.getBridgeConfigurations().add(config);
    }

    private void parseFederationConfiguration(Element fedNode, Configuration mainConfig) throws Exception {
        FederationConfiguration config = new FederationConfiguration();
        String name = fedNode.getAttribute(NAME_ATTR_NAME);
        config.setName(name);
        FederationConfiguration.Credentials credentials = new FederationConfiguration.Credentials();
        String passwordTextFederation = fedNode.getAttribute("password");
        if (passwordTextFederation != null && !passwordTextFederation.isEmpty()) {
            String resolvedPassword = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)passwordTextFederation, (String)mainConfig.getPasswordCodec());
            credentials.setPassword(resolvedPassword);
        }
        credentials.setUser(fedNode.getAttribute("user"));
        config.setCredentials(credentials);
        NodeList children = fedNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("upstream")) {
                config.addUpstreamConfiguration(this.getUpstream((Element)child, mainConfig));
                continue;
            }
            if (child.getNodeName().equals("downstream")) {
                config.addDownstreamConfiguration(this.getDownstream((Element)child, mainConfig));
                continue;
            }
            if (child.getNodeName().equals("policy-set")) {
                config.addFederationPolicy((FederationPolicy)this.getPolicySet((Element)child, mainConfig));
                continue;
            }
            if (child.getNodeName().equals("queue-policy")) {
                config.addFederationPolicy((FederationPolicy)this.getQueuePolicy((Element)child, mainConfig));
                continue;
            }
            if (child.getNodeName().equals("address-policy")) {
                config.addFederationPolicy((FederationPolicy)this.getAddressPolicy((Element)child, mainConfig));
                continue;
            }
            if (!child.getNodeName().equals("transformer")) continue;
            TransformerConfiguration transformerConfiguration = this.getTransformerConfiguration(child);
            config.addTransformerConfiguration(new FederationTransformerConfiguration(((Element)child).getAttribute(NAME_ATTR_NAME), transformerConfiguration));
        }
        mainConfig.getFederationConfigurations().add(config);
    }

    private FederationQueuePolicyConfiguration getQueuePolicy(Element policyNod, Configuration mainConfig) throws Exception {
        FederationQueuePolicyConfiguration config = new FederationQueuePolicyConfiguration();
        config.setName(policyNod.getAttribute(NAME_ATTR_NAME));
        NamedNodeMap attributes = policyNod.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (item.getNodeName().equals("include-federated")) {
                config.setIncludeFederated(Boolean.parseBoolean(item.getNodeValue()));
                continue;
            }
            if (item.getNodeName().equals("priority-adjustment")) {
                int priorityAdjustment = Integer.parseInt(item.getNodeValue());
                config.setPriorityAdjustment(Integer.valueOf(priorityAdjustment));
                continue;
            }
            if (!item.getNodeName().equals("transformer-ref")) continue;
            String transformerRef = item.getNodeValue();
            config.setTransformerRef(transformerRef);
        }
        NodeList children = policyNod.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("include")) {
                config.addInclude(this.getQueueMatcher((Element)child));
                continue;
            }
            if (!child.getNodeName().equals("exclude")) continue;
            config.addExclude(this.getQueueMatcher((Element)child));
        }
        return config;
    }

    private FederationQueuePolicyConfiguration.Matcher getQueueMatcher(Element child) {
        FederationQueuePolicyConfiguration.Matcher matcher = new FederationQueuePolicyConfiguration.Matcher();
        matcher.setQueueMatch(child.getAttribute("queue-match"));
        matcher.setAddressMatch(child.getAttribute("address-match"));
        return matcher;
    }

    private FederationAddressPolicyConfiguration getAddressPolicy(Element policyNod, Configuration mainConfig) throws Exception {
        FederationAddressPolicyConfiguration config = new FederationAddressPolicyConfiguration();
        config.setName(policyNod.getAttribute(NAME_ATTR_NAME));
        NamedNodeMap attributes = policyNod.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (item.getNodeName().equals("max-consumers")) {
                config.setMaxHops(Validators.MINUS_ONE_OR_GE_ZERO.validate(item.getNodeName(), Integer.parseInt(item.getNodeValue())).intValue());
                continue;
            }
            if (item.getNodeName().equals("auto-delete")) {
                config.setAutoDelete(Boolean.valueOf(Boolean.parseBoolean(item.getNodeValue())));
                continue;
            }
            if (item.getNodeName().equals("auto-delete-delay")) {
                config.setAutoDeleteDelay(Long.valueOf(Validators.GE_ZERO.validate("auto-delete-delay", Long.parseLong(item.getNodeValue())).longValue()));
                continue;
            }
            if (item.getNodeName().equals("auto-delete-message-count")) {
                config.setAutoDeleteMessageCount(Long.valueOf(Validators.MINUS_ONE_OR_GE_ZERO.validate("auto-delete-message-count", Long.parseLong(item.getNodeValue())).longValue()));
                continue;
            }
            if (item.getNodeName().equals("transformer-ref")) {
                config.setTransformerRef(item.getNodeValue());
                continue;
            }
            if (!item.getNodeName().equals("enable-divert-bindings")) continue;
            config.setEnableDivertBindings(Boolean.valueOf(Boolean.parseBoolean(item.getNodeValue())));
        }
        NodeList children = policyNod.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("include")) {
                config.addInclude(this.getAddressMatcher((Element)child));
                continue;
            }
            if (!child.getNodeName().equals("exclude")) continue;
            config.addExclude(this.getAddressMatcher((Element)child));
        }
        return config;
    }

    private FederationAddressPolicyConfiguration.Matcher getAddressMatcher(Element child) {
        FederationAddressPolicyConfiguration.Matcher matcher = new FederationAddressPolicyConfiguration.Matcher();
        matcher.setAddressMatch(child.getAttribute("address-match"));
        return matcher;
    }

    private FederationPolicySet getPolicySet(Element policySetNode, Configuration mainConfig) throws Exception {
        FederationPolicySet config = new FederationPolicySet();
        config.setName(policySetNode.getAttribute(NAME_ATTR_NAME));
        NodeList children = policySetNode.getChildNodes();
        ArrayList<String> policyRefs = new ArrayList<String>();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("policy")) continue;
            policyRefs.add(((Element)child).getAttribute("ref"));
        }
        config.addPolicyRefs(policyRefs);
        return config;
    }

    private <T extends FederationStreamConfiguration> T getFederationStream(T config, Element upstreamNode, Configuration mainConfig) throws Exception {
        String name = upstreamNode.getAttribute(NAME_ATTR_NAME);
        config.setName(name);
        String passwordTextFederation = upstreamNode.getAttribute("password");
        if (passwordTextFederation != null && !passwordTextFederation.isEmpty()) {
            String resolvedPassword = PasswordMaskingUtil.resolveMask((Boolean)mainConfig.isMaskPassword(), (String)passwordTextFederation, (String)mainConfig.getPasswordCodec());
            config.getConnectionConfiguration().setPassword(resolvedPassword);
        }
        config.getConnectionConfiguration().setUsername(upstreamNode.getAttribute("user"));
        NamedNodeMap attributes = upstreamNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (!item.getNodeName().equals("priority-adjustment")) continue;
            config.getConnectionConfiguration().setPriorityAdjustment(Integer.parseInt(item.getNodeValue()));
        }
        boolean ha = FileConfigurationParser.getBoolean(upstreamNode, "ha", false);
        long circuitBreakerTimeout = FileConfigurationParser.getLong(upstreamNode, "circuit-breaker-timeout", config.getConnectionConfiguration().getCircuitBreakerTimeout(), Validators.MINUS_ONE_OR_GE_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(upstreamNode, "check-period", ActiveMQDefaultConfiguration.getDefaultFederationFailureCheckPeriod(), Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(upstreamNode, "connection-ttl", ActiveMQDefaultConfiguration.getDefaultFederationConnectionTtl(), Validators.GT_ZERO);
        long retryInterval = FileConfigurationParser.getLong(upstreamNode, "retry-interval", ActiveMQDefaultConfiguration.getDefaultFederationRetryInterval(), Validators.GT_ZERO);
        long callTimeout = FileConfigurationParser.getLong(upstreamNode, "call-timeout", 30000L, Validators.GT_ZERO);
        long callFailoverTimeout = FileConfigurationParser.getLong(upstreamNode, "call-failover-timeout", 30000L, Validators.MINUS_ONE_OR_GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(upstreamNode, "retry-interval-multiplier", ActiveMQDefaultConfiguration.getDefaultFederationRetryIntervalMultiplier(), Validators.GT_ZERO);
        long maxRetryInterval = FileConfigurationParser.getLong(upstreamNode, "max-retry-interval", ActiveMQDefaultConfiguration.getDefaultFederationMaxRetryInterval(), Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(upstreamNode, "initial-connect-attempts", ActiveMQDefaultConfiguration.getDefaultFederationInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(upstreamNode, "reconnect-attempts", ActiveMQDefaultConfiguration.getDefaultFederationReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        String discoveryGroupName = null;
        NodeList children = upstreamNode.getChildNodes();
        ArrayList<String> policyRefs = new ArrayList<String>();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("static-connectors")) {
                this.getStaticConnectors(staticConnectorNames, child);
                continue;
            }
            if (!child.getNodeName().equals("policy")) continue;
            policyRefs.add(((Element)child).getAttribute("ref"));
        }
        config.addPolicyRefs(policyRefs);
        config.getConnectionConfiguration().setCircuitBreakerTimeout(circuitBreakerTimeout).setHA(ha).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout);
        if (!staticConnectorNames.isEmpty()) {
            config.getConnectionConfiguration().setStaticConnectors(staticConnectorNames);
        } else {
            config.getConnectionConfiguration().setDiscoveryGroupName(discoveryGroupName);
        }
        return config;
    }

    private FederationUpstreamConfiguration getUpstream(Element upstreamNode, Configuration mainConfig) throws Exception {
        return this.getFederationStream(new FederationUpstreamConfiguration(), upstreamNode, mainConfig);
    }

    private FederationDownstreamConfiguration getDownstream(Element downstreamNode, Configuration mainConfig) throws Exception {
        FederationDownstreamConfiguration downstreamConfiguration = this.getFederationStream(new FederationDownstreamConfiguration(), downstreamNode, mainConfig);
        String upstreamRef = FileConfigurationParser.getString(downstreamNode, "upstream-connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
        downstreamConfiguration.setUpstreamConfigurationRef(upstreamRef);
        return downstreamConfiguration;
    }

    private FederationUpstreamConfiguration getBrokerConnections(Element upstreamNode, Configuration mainConfig) throws Exception {
        return this.getFederationStream(new FederationUpstreamConfiguration(), upstreamNode, mainConfig);
    }

    private void getStaticConnectors(List<String> staticConnectorNames, Node child) {
        NodeList children2 = ((Element)child).getElementsByTagName("connector-ref");
        for (int k = 0; k < children2.getLength(); ++k) {
            Element child2 = (Element)children2.item(k);
            String connectorName = child2.getChildNodes().item(0).getNodeValue();
            staticConnectorNames.add(connectorName);
        }
    }

    private void parseDivertConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute(NAME_ATTR_NAME);
        String routingName = FileConfigurationParser.getString(e, "routing-name", null, Validators.NO_CHECK);
        String address = FileConfigurationParser.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = FileConfigurationParser.getString(e, "forwarding-address", null, Validators.NOT_NULL_OR_EMPTY);
        boolean exclusive = FileConfigurationParser.getBoolean(e, "exclusive", ActiveMQDefaultConfiguration.isDefaultDivertExclusive());
        String transformerClassName = FileConfigurationParser.getString(e, "transformer-class-name", null, Validators.NO_CHECK);
        ComponentConfigurationRoutingType routingType = ComponentConfigurationRoutingType.valueOf((String)FileConfigurationParser.getString(e, "routing-type", ActiveMQDefaultConfiguration.getDefaultDivertRoutingType(), Validators.COMPONENT_ROUTING_TYPE));
        TransformerConfiguration transformerConfiguration = null;
        String filterString = null;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("filter")) {
                filterString = FileConfigurationParser.getAttributeValue(child, "string");
                continue;
            }
            if (!child.getNodeName().equals("transformer")) continue;
            transformerConfiguration = this.getTransformerConfiguration(child);
        }
        if (transformerConfiguration == null && transformerClassName != null) {
            transformerConfiguration = this.getTransformerConfiguration(transformerClassName);
        }
        DivertConfiguration config = new DivertConfiguration().setName(name).setRoutingName(routingName).setAddress(address).setForwardingAddress(forwardingAddress).setExclusive(exclusive).setFilterString(filterString).setTransformerConfiguration(transformerConfiguration).setRoutingType(routingType);
        mainConfig.getDivertConfigurations().add(config);
    }

    private void parseConnectionRouterConfiguration(Element e, Configuration config) throws Exception {
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration();
        connectionRouterConfiguration.setName(e.getAttribute(NAME_ATTR_NAME));
        connectionRouterConfiguration.setKeyType(KeyType.valueOf(FileConfigurationParser.getString(e, "key-type", connectionRouterConfiguration.getKeyType().name(), Validators.KEY_TYPE)));
        connectionRouterConfiguration.setKeyFilter(FileConfigurationParser.getString(e, "key-filter", connectionRouterConfiguration.getKeyFilter(), Validators.NO_CHECK));
        connectionRouterConfiguration.setLocalTargetFilter(FileConfigurationParser.getString(e, "local-target-filter", connectionRouterConfiguration.getLocalTargetFilter(), Validators.NO_CHECK));
        NamedPropertyConfiguration policyConfiguration = null;
        PoolConfiguration poolConfiguration = null;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("cache")) {
                CacheConfiguration cacheConfiguration = new CacheConfiguration();
                this.parseCacheConfiguration((Element)child, cacheConfiguration);
                connectionRouterConfiguration.setCacheConfiguration(cacheConfiguration);
                continue;
            }
            if (child.getNodeName().equals("policy")) {
                policyConfiguration = new NamedPropertyConfiguration();
                this.parsePolicyConfiguration((Element)child, policyConfiguration);
                connectionRouterConfiguration.setPolicyConfiguration(policyConfiguration);
                continue;
            }
            if (!child.getNodeName().equals("pool")) continue;
            poolConfiguration = new PoolConfiguration();
            this.parsePoolConfiguration((Element)child, config, poolConfiguration);
            connectionRouterConfiguration.setPoolConfiguration(poolConfiguration);
        }
        config.getConnectionRouters().add(connectionRouterConfiguration);
    }

    private void parseCacheConfiguration(Element e, CacheConfiguration cacheConfiguration) throws ClassNotFoundException {
        cacheConfiguration.setPersisted(FileConfigurationParser.getBoolean(e, "persisted", cacheConfiguration.isPersisted()));
        cacheConfiguration.setTimeout(FileConfigurationParser.getInteger(e, "timeout", cacheConfiguration.getTimeout(), Validators.GE_ZERO));
    }

    private void parsePolicyConfiguration(Element e, NamedPropertyConfiguration policyConfiguration) throws ClassNotFoundException {
        String name = e.getAttribute(NAME_ATTR_NAME);
        PolicyFactoryResolver.getInstance().resolve(name);
        policyConfiguration.setName(name);
        policyConfiguration.setProperties(this.getMapOfChildPropertyElements(e));
    }

    private void parsePoolConfiguration(Element e, Configuration config, PoolConfiguration poolConfiguration) throws Exception {
        poolConfiguration.setUsername(FileConfigurationParser.getString(e, "username", null, Validators.NO_CHECK));
        String password = FileConfigurationParser.getString(e, "password", null, Validators.NO_CHECK);
        poolConfiguration.setPassword(password != null ? PasswordMaskingUtil.resolveMask((Boolean)config.isMaskPassword(), (String)password, (String)config.getPasswordCodec()) : null);
        poolConfiguration.setCheckPeriod(FileConfigurationParser.getInteger(e, "check-period", poolConfiguration.getCheckPeriod(), Validators.GT_ZERO));
        poolConfiguration.setQuorumSize(FileConfigurationParser.getInteger(e, "quorum-size", poolConfiguration.getQuorumSize(), Validators.GT_ZERO));
        poolConfiguration.setQuorumTimeout(FileConfigurationParser.getInteger(e, "quorum-timeout", poolConfiguration.getQuorumTimeout(), Validators.GE_ZERO));
        poolConfiguration.setLocalTargetEnabled(FileConfigurationParser.getBoolean(e, "local-target-enabled", poolConfiguration.isLocalTargetEnabled()));
        poolConfiguration.setClusterConnection(FileConfigurationParser.getString(e, "cluster-connection", null, Validators.NO_CHECK));
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("discovery-group-ref")) {
                poolConfiguration.setDiscoveryGroupName(child.getAttributes().getNamedItem("discovery-group-name").getNodeValue());
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            ArrayList<String> staticConnectorNames = new ArrayList<String>();
            this.getStaticConnectors(staticConnectorNames, child);
            poolConfiguration.setStaticConnectors(staticConnectorNames);
        }
    }

    protected void parseWildcardConfiguration(Element e, Configuration mainConfig) {
        WildcardConfiguration conf = mainConfig.getWildcardConfiguration();
        conf.setDelimiter(FileConfigurationParser.getString(e, "delimiter", Character.toString(conf.getDelimiter()), Validators.NO_CHECK).charAt(0));
        conf.setAnyWords(FileConfigurationParser.getString(e, "any-words", Character.toString(conf.getAnyWords()), Validators.NO_CHECK).charAt(0));
        conf.setSingleWord(FileConfigurationParser.getString(e, "single-word", Character.toString(conf.getSingleWord()), Validators.NO_CHECK).charAt(0));
        conf.setRoutingEnabled(FileConfigurationParser.getBoolean(e, "enabled", conf.isRoutingEnabled()));
        conf.setRoutingEnabled(FileConfigurationParser.getBoolean(e, "routing-enabled", conf.isRoutingEnabled()));
    }

    private ConnectorServiceConfiguration parseConnectorService(Element e) {
        Node nameNode = e.getAttributes().getNamedItem(NAME_ATTR_NAME);
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = FileConfigurationParser.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem(VALUE_ATTR_NAME);
            params.put(key, nValue.getTextContent());
        }
        return new ConnectorServiceConfiguration().setFactoryClassName(clazz).setParams(params).setName(name);
    }

    static {
        HA_LIST.add("live-only");
        HA_LIST.add("primary-only");
        HA_LIST.add("shared-store");
        HA_LIST.add("replication");
        STORE_TYPE_LIST = new ArrayList<String>();
        STORE_TYPE_LIST.add("database-store");
        STORE_TYPE_LIST.add("file-store");
    }
}

