/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.concurrent.locks.StampedLock;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.EmbeddedSlotMap;
import org.mozilla.javascript.LockAwareSlotMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;
import org.mozilla.javascript.SlotMapOwner;
import org.mozilla.javascript.ThreadSafeHashSlotMap;

class ThreadSafeEmbeddedSlotMap
extends EmbeddedSlotMap
implements LockAwareSlotMap {
    private final StampedLock lock = new StampedLock();
    private volatile LockAwareSlotMap current = this;

    public ThreadSafeEmbeddedSlotMap() {
    }

    public ThreadSafeEmbeddedSlotMap(int capacity) {
        super(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long stamp = this.lock.tryOptimisticRead();
        int s = this.current.sizeWithLock();
        if (this.lock.validate(stamp)) {
            return s;
        }
        stamp = this.lock.readLock();
        try {
            int n = this.current.sizeWithLock();
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    @Override
    public int dirtySize() {
        assert (this.lock.isReadLocked() || this.lock.isWriteLocked());
        return this.current.sizeWithLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long stamp = this.lock.tryOptimisticRead();
        boolean e = this.current.isEmptyWithLock();
        if (this.lock.validate(stamp)) {
            return e;
        }
        stamp = this.lock.readLock();
        try {
            boolean bl = this.current.isEmptyWithLock();
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
        long stamp = this.lock.writeLock();
        try {
            Slot slot = this.current.modifyWithLock(owner, key, index, attributes);
            return slot;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap mutableMap, Object key, int index, SlotMap.SlotComputer<S> c) {
        return this.current.computeWithLock(owner, mutableMap, key, index, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot query(Object key, int index) {
        long stamp = this.lock.tryOptimisticRead();
        Slot s = this.current.queryWithLock(key, index);
        if (this.lock.validate(stamp)) {
            return s;
        }
        stamp = this.lock.readLock();
        try {
            Slot slot = this.current.queryWithLock(key, index);
            return slot;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SlotMapOwner owner, Slot newSlot) {
        long stamp = this.lock.writeLock();
        try {
            this.current.addWithLock(owner, newSlot);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void addWithLock(SlotMapOwner owner, Slot newSlot) {
        super.add(owner, newSlot);
    }

    @Override
    public <S extends Slot> S computeWithLock(SlotMapOwner owner, CompoundOperationMap mutableMap, Object key, int index, SlotMap.SlotComputer<S> compute) {
        return super.compute(owner, mutableMap, key, index, compute);
    }

    @Override
    public boolean isEmptyWithLock() {
        return super.isEmpty();
    }

    @Override
    public Slot modifyWithLock(SlotMapOwner owner, Object key, int index, int attributes) {
        return super.modify(owner, key, index, attributes);
    }

    @Override
    public Slot queryWithLock(Object key, int index) {
        return super.query(key, index);
    }

    @Override
    public int sizeWithLock() {
        return super.size();
    }

    @Override
    public long getReadLock() {
        return this.lock.readLock();
    }

    @Override
    public long getWriteLock() {
        return this.lock.writeLock();
    }

    @Override
    public void releaseLock(long stamp) {
        this.lock.unlock(stamp);
    }

    @Override
    protected void promoteMap(SlotMapOwner owner, Slot newSlot) {
        ThreadSafeHashSlotMap newMap = new ThreadSafeHashSlotMap(this.lock, this, newSlot);
        owner.setMap(newMap);
        this.current = newMap;
    }
}

