/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.ModulePackageAccess;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.eval.ICodeSnippetRequestor;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.eval.ExpressionBinder;
import org.eclipse.jdt.internal.debug.eval.RemoteEvaluator;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationEngineMessages;

public class RemoteEvaluatorBuilder {
    private IJavaProject javaProject;
    private ExpressionBinder binder;
    private final String enclosingTypeName;
    private final String packageName;
    private final boolean isStatic;
    private final boolean isConstructor;
    private final List<String> argumentNames = new ArrayList<String>();
    private final List<String> argumentTypeNames = new ArrayList<String>();
    private LinkedHashMap<String, byte[]> classFiles = new LinkedHashMap();
    private String codeSnippetClassName = null;
    private String snippet = null;
    private final ITypeBinding enclosingClass;
    private static Object EVALUATE_CODE_SNIPPET_LOCK = new Object();

    public RemoteEvaluatorBuilder(IJavaProject javaProject, ExpressionBinder binder, ITypeBinding enclosingClass, boolean isStatic, boolean isConstructor) {
        this.javaProject = javaProject;
        this.binder = binder;
        this.enclosingClass = enclosingClass;
        this.enclosingTypeName = enclosingClass.getQualifiedName();
        this.packageName = enclosingClass.getPackage().getName();
        this.isStatic = isStatic;
        this.isConstructor = isConstructor;
    }

    public void acceptLambda(LambdaExpression lambda, ITypeBinding expectedResult) {
        this.acceptFunctionalExpression((Expression)lambda, expectedResult);
    }

    public void acceptMethodReference(MethodReference node, ITypeBinding expectedResult) {
        this.acceptFunctionalExpression((Expression)node, expectedResult);
    }

    public void acceptAnonymousClass(ClassInstanceCreation node, ITypeBinding expectedResult) {
        this.acceptFunctionalExpression((Expression)node, expectedResult);
    }

    private void acceptFunctionalExpression(Expression node, ITypeBinding expectedResult) {
        FunctionalEvalVisitor visitor = new FunctionalEvalVisitor();
        node.accept((ASTVisitor)visitor);
        String castExpression = "(" + expectedResult.getQualifiedName() + ")";
        this.snippet = String.valueOf(castExpression) + "(" + visitor.buffer.toString() + ")";
    }

    public String getSnippet() {
        return this.snippet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEvaluator build() throws JavaModelException, DebugException {
        List<String> boundVariableNames = this.getVariableNames();
        List<String> boundVariableTypeNames = this.getVariableTypeNames();
        final ArrayList errors = new ArrayList();
        IType enclosingType = this.javaProject.findType(this.enclosingTypeName);
        if (enclosingType == null) {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), EvaluationEngineMessages.ASTInstructionCompiler_Functional_expressions_cannot_be_evaluated_inside_local_and_or_anonymous_classes));
        }
        Object object = EVALUATE_CODE_SNIPPET_LOCK;
        synchronized (object) {
            IEvaluationContext context = this.javaProject.newEvaluationContext();
            if (!this.packageName.startsWith("java.")) {
                context.setPackageName(this.packageName);
            }
            context.evaluateCodeSnippet(this.snippet, boundVariableTypeNames.toArray(new String[boundVariableNames.size()]), boundVariableNames.toArray(new String[boundVariableNames.size()]), new int[boundVariableNames.size()], enclosingType, this.isStatic, this.isConstructor, new ICodeSnippetRequestor(){

                public void acceptProblem(IMarker problemMarker, String fragmentSource, int fragmentKind) {
                    if (problemMarker.getAttribute("severity", 0) >= 2) {
                        errors.add(this.toString(problemMarker));
                    }
                }

                private String toString(IMarker marker) {
                    return marker.getAttribute("message", "");
                }

                public boolean acceptClassFiles(byte[][] classFileBytes, String[][] classFileCompoundNames, String mainCodeSnippetClassName) {
                    int i = 0;
                    while (i < classFileCompoundNames.length) {
                        String className = RemoteEvaluatorBuilder.makeClassName(classFileCompoundNames[i]);
                        RemoteEvaluatorBuilder.this.classFiles.put(className, classFileBytes[i]);
                        ++i;
                    }
                    if (mainCodeSnippetClassName != null) {
                        RemoteEvaluatorBuilder.this.setCodeSnippetClassName(mainCodeSnippetClassName);
                    }
                    return true;
                }
            }, null);
        }
        if (!errors.isEmpty()) {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), ((Object)errors).toString()));
        }
        return new RemoteEvaluator(this.classFiles, this.codeSnippetClassName, this.getVariableNames(), enclosingType.getFullyQualifiedName('$'));
    }

    private void setCodeSnippetClassName(String codeSnippetClassName) {
        this.codeSnippetClassName = codeSnippetClassName;
    }

    private static String makeClassName(String[] names) {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j < names.length) {
            if (j > 0) {
                sb.append('/');
            }
            sb.append(names[j]);
            ++j;
        }
        return sb.toString();
    }

    public List<String> getVariableTypeNames() {
        return Collections.unmodifiableList(this.argumentTypeNames);
    }

    public List<String> getVariableNames() {
        return Collections.unmodifiableList(this.argumentNames);
    }

    public String allocateNewVariable(ITypeBinding binding, String hint) {
        String varName = String.valueOf(hint) + "$" + this.argumentNames.size();
        this.argumentNames.add(varName);
        this.argumentTypeNames.add(binding.getQualifiedName());
        return varName;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public String getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Deprecated
    private static Type getReturnType(MethodDeclaration node) {
        return node.getReturnType();
    }

    @Deprecated
    private static Name getSuperclass(TypeDeclaration node) {
        return node.getSuperclass();
    }

    @Deprecated
    private static TypeDeclaration getTypeDeclaration(TypeDeclarationStatement node) {
        return node.getTypeDeclaration();
    }

    @Deprecated
    private static List<?> thrownExceptions(MethodDeclaration node) {
        return node.thrownExceptions();
    }

    private class FunctionalEvalVisitor
    extends ASTVisitor {
        protected StringBuilder buffer = new StringBuilder();
        private int indent = 2;
        private Map<IBinding, String> localBindings = new HashMap<IBinding, String>();
        @Deprecated
        private static final int JLS2 = 2;
        @Deprecated
        private static final int JLS3 = 3;
        @Deprecated
        private static final int JLS4 = 4;
        @Deprecated
        private static final int JLS8 = 8;
        @Deprecated
        private static final int JLS9 = 9;

        boolean isLocalBinding(IBinding binding) {
            return this.localBindings.containsKey(binding);
        }

        void addLocalBinding(IBinding binding, String name) {
            this.localBindings.put(binding, name);
        }

        void printIndent() {
            int i = 0;
            while (i < this.indent) {
                this.buffer.append("  ");
                ++i;
            }
        }

        @Deprecated
        private Name getName(ClassInstanceCreation node) {
            return node.getName();
        }

        void printModifiers(int modifiers) {
            if (Modifier.isPublic((int)modifiers)) {
                this.buffer.append("public ");
            }
            if (Modifier.isProtected((int)modifiers)) {
                this.buffer.append("protected ");
            }
            if (Modifier.isPrivate((int)modifiers)) {
                this.buffer.append("private ");
            }
            if (Modifier.isStatic((int)modifiers)) {
                this.buffer.append("static ");
            }
            if (Modifier.isAbstract((int)modifiers)) {
                this.buffer.append("abstract ");
            }
            if (Modifier.isFinal((int)modifiers)) {
                this.buffer.append("final ");
            }
            if (Modifier.isSynchronized((int)modifiers)) {
                this.buffer.append("synchronized ");
            }
            if (Modifier.isVolatile((int)modifiers)) {
                this.buffer.append("volatile ");
            }
            if (Modifier.isNative((int)modifiers)) {
                this.buffer.append("native ");
            }
            if (Modifier.isStrictfp((int)modifiers)) {
                this.buffer.append("strictfp ");
            }
            if (Modifier.isTransient((int)modifiers)) {
                this.buffer.append("transient ");
            }
        }

        void printModifiers(List ext) {
            for (ASTNode p : ext) {
                p.accept((ASTVisitor)this);
                this.buffer.append(" ");
            }
        }

        private void printTypes(List<Type> types, String prefix) {
            if (types.size() > 0) {
                this.buffer.append(" " + prefix + " ");
                Type type = types.get(0);
                type.accept((ASTVisitor)this);
                int i = 1;
                int l = types.size();
                while (i < l) {
                    this.buffer.append(",");
                    type = types.get(0);
                    type.accept((ASTVisitor)this);
                    ++i;
                }
            }
        }

        private void visitReferenceTypeArguments(List typeArguments) {
            this.buffer.append("::");
            if (!typeArguments.isEmpty()) {
                this.buffer.append('<');
                Iterator it = typeArguments.iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(',');
                }
                this.buffer.append('>');
            }
        }

        private void visitTypeAnnotations(AnnotatableType node) {
            if (node.getAST().apiLevel() >= 8) {
                this.visitAnnotationsList(node.annotations());
            }
        }

        private void visitAnnotationsList(List annotations) {
            for (Annotation annotation : annotations) {
                annotation.accept((ASTVisitor)this);
                this.buffer.append(' ');
            }
        }

        @Deprecated
        private List superInterfaces(TypeDeclaration node) {
            return node.superInterfaces();
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printIndent();
            this.printModifiers(node.modifiers());
            this.buffer.append("@interface ");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append(" {");
            for (BodyDeclaration d : node.bodyDeclarations()) {
                d.accept((ASTVisitor)this);
            }
            this.buffer.append("}\n");
            return false;
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printIndent();
            this.printModifiers(node.modifiers());
            node.getType().accept((ASTVisitor)this);
            this.buffer.append(" ");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append("()");
            if (node.getDefault() != null) {
                this.buffer.append(" default ");
                node.getDefault().accept((ASTVisitor)this);
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            this.buffer.append("{\n");
            ++this.indent;
            for (BodyDeclaration b : node.bodyDeclarations()) {
                b.accept((ASTVisitor)this);
            }
            --this.indent;
            this.printIndent();
            this.buffer.append("}\n");
            return false;
        }

        public boolean visit(ArrayAccess node) {
            node.getArray().accept((ASTVisitor)this);
            this.buffer.append("[");
            node.getIndex().accept((ASTVisitor)this);
            this.buffer.append("]");
            return false;
        }

        public boolean visit(ArrayCreation node) {
            this.buffer.append("new ");
            ArrayType at = node.getType();
            int dims = at.getDimensions();
            Type elementType = at.getElementType();
            elementType.accept((ASTVisitor)this);
            Iterator it = node.dimensions().iterator();
            while (it.hasNext()) {
                this.buffer.append("[");
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                this.buffer.append("]");
                --dims;
            }
            int i = 0;
            while (i < dims) {
                this.buffer.append("[]");
                ++i;
            }
            if (node.getInitializer() != null) {
                node.getInitializer().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ArrayInitializer node) {
            this.buffer.append("{");
            Iterator it = node.expressions().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append("}");
            return false;
        }

        public boolean visit(ArrayType node) {
            if (node.getAST().apiLevel() < 8) {
                this.visitComponentType(node);
                this.buffer.append("[]");
            } else {
                node.getElementType().accept((ASTVisitor)this);
                List dimensions = node.dimensions();
                int size = dimensions.size();
                int i = 0;
                while (i < size) {
                    Dimension aDimension = (Dimension)dimensions.get(i);
                    aDimension.accept((ASTVisitor)this);
                    ++i;
                }
            }
            return false;
        }

        public boolean visit(AssertStatement node) {
            this.printIndent();
            this.buffer.append("assert ");
            node.getExpression().accept((ASTVisitor)this);
            if (node.getMessage() != null) {
                this.buffer.append(" : ");
                node.getMessage().accept((ASTVisitor)this);
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(Assignment node) {
            node.getLeftHandSide().accept((ASTVisitor)this);
            this.buffer.append(node.getOperator().toString());
            node.getRightHandSide().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(Block node) {
            this.buffer.append("{\n");
            ++this.indent;
            for (Statement s : node.statements()) {
                s.accept((ASTVisitor)this);
            }
            --this.indent;
            this.printIndent();
            this.buffer.append("}\n");
            return false;
        }

        public boolean visit(BlockComment node) {
            this.printIndent();
            this.buffer.append("/* */");
            return false;
        }

        public boolean visit(BooleanLiteral node) {
            if (node.booleanValue()) {
                this.buffer.append("true");
            } else {
                this.buffer.append("false");
            }
            return false;
        }

        public boolean visit(BreakStatement node) {
            this.printIndent();
            this.buffer.append("break");
            if (node.getLabel() != null) {
                this.buffer.append(" ");
                node.getLabel().accept((ASTVisitor)this);
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(CastExpression node) {
            node.getType().accept((ASTVisitor)this);
            node.getExpression().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(CatchClause node) {
            this.buffer.append("catch (");
            node.getException().accept((ASTVisitor)this);
            this.buffer.append(") ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(CharacterLiteral node) {
            this.buffer.append(node.getEscapedValue());
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            Iterator it;
            if (node.getExpression() != null) {
                node.getExpression().accept((ASTVisitor)this);
                this.buffer.append(".");
            }
            this.buffer.append("new ");
            if (node.getAST().apiLevel() == 2) {
                this.getName(node).accept((ASTVisitor)this);
            }
            if (node.getAST().apiLevel() >= 3) {
                if (!node.typeArguments().isEmpty()) {
                    this.buffer.append("<");
                    it = node.typeArguments().iterator();
                    while (it.hasNext()) {
                        Type t = (Type)it.next();
                        t.accept((ASTVisitor)this);
                        if (!it.hasNext()) continue;
                        this.buffer.append(",");
                    }
                    this.buffer.append(">");
                }
                node.getType().accept((ASTVisitor)this);
            }
            this.buffer.append("(");
            it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
            if (node.getAnonymousClassDeclaration() != null) {
                node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(CompilationUnit node) {
            if (node.getAST().apiLevel() >= 9 && node.getModule() != null) {
                node.getModule().accept((ASTVisitor)this);
            }
            if (node.getPackage() != null) {
                node.getPackage().accept((ASTVisitor)this);
            }
            for (ImportDeclaration d : node.imports()) {
                d.accept((ASTVisitor)this);
            }
            for (ImportDeclaration d : node.types()) {
                d.accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ConditionalExpression node) {
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(" ? ");
            node.getThenExpression().accept((ASTVisitor)this);
            this.buffer.append(" : ");
            node.getElseExpression().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(ConstructorInvocation node) {
            Iterator it;
            this.printIndent();
            if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
                this.buffer.append("<");
                it = node.typeArguments().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
            this.buffer.append("this(");
            it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(");\n");
            return false;
        }

        public boolean visit(ContinueStatement node) {
            this.printIndent();
            this.buffer.append("continue");
            if (node.getLabel() != null) {
                this.buffer.append(" ");
                node.getLabel().accept((ASTVisitor)this);
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(CreationReference node) {
            node.getType().accept((ASTVisitor)this);
            this.visitReferenceTypeArguments(node.typeArguments());
            this.buffer.append("new");
            return false;
        }

        public boolean visit(Dimension node) {
            List annotations = node.annotations();
            if (annotations.size() > 0) {
                this.buffer.append(' ');
            }
            this.visitAnnotationsList(annotations);
            this.buffer.append("[]");
            return false;
        }

        public boolean visit(DoStatement node) {
            this.printIndent();
            this.buffer.append("do ");
            node.getBody().accept((ASTVisitor)this);
            this.buffer.append(" while (");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(");\n");
            return false;
        }

        public boolean visit(EmptyStatement node) {
            this.printIndent();
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(EnhancedForStatement node) {
            this.printIndent();
            this.buffer.append("for (");
            node.getParameter().accept((ASTVisitor)this);
            this.buffer.append(" : ");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(") ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(EnumConstantDeclaration node) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printIndent();
            this.printModifiers(node.modifiers());
            node.getName().accept((ASTVisitor)this);
            if (!node.arguments().isEmpty()) {
                this.buffer.append("(");
                Iterator it = node.arguments().iterator();
                while (it.hasNext()) {
                    Expression e = (Expression)it.next();
                    e.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(")");
            }
            if (node.getAnonymousClassDeclaration() != null) {
                node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(EnumDeclaration node) {
            Iterator it;
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printIndent();
            this.printModifiers(node.modifiers());
            this.buffer.append("enum ");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append(" ");
            if (!node.superInterfaceTypes().isEmpty()) {
                this.buffer.append("implements ");
                it = node.superInterfaceTypes().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
            this.buffer.append("{");
            it = node.enumConstants().iterator();
            while (it.hasNext()) {
                EnumConstantDeclaration d = (EnumConstantDeclaration)it.next();
                d.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            if (!node.bodyDeclarations().isEmpty()) {
                this.buffer.append("; ");
                for (EnumConstantDeclaration d : node.bodyDeclarations()) {
                    d.accept((ASTVisitor)this);
                }
            }
            this.buffer.append("}\n");
            return false;
        }

        public boolean visit(ExportsDirective node) {
            return this.visit((ModulePackageAccess)node, "exports");
        }

        public boolean visit(ExpressionMethodReference node) {
            node.getExpression().accept((ASTVisitor)this);
            this.visitReferenceTypeArguments(node.typeArguments());
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(ExpressionStatement node) {
            this.printIndent();
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(FieldAccess node) {
            ITypeBinding instanceType = node.getExpression().resolveTypeBinding();
            if (instanceType.isAssignmentCompatible(RemoteEvaluatorBuilder.this.enclosingClass)) {
                node.getExpression().accept((ASTVisitor)this);
                this.buffer.append(".");
                this.buffer.append(node.getName().getIdentifier());
                return false;
            }
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(".");
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(FieldDeclaration node) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printIndent();
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
            }
            node.getType().accept((ASTVisitor)this);
            this.buffer.append(" ");
            Iterator it = node.fragments().iterator();
            while (it.hasNext()) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                f.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(ForStatement node) {
            Expression e;
            this.printIndent();
            this.buffer.append("for (");
            Iterator it = node.initializers().iterator();
            while (it.hasNext()) {
                e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append("; ");
            if (node.getExpression() != null) {
                node.getExpression().accept((ASTVisitor)this);
            }
            this.buffer.append("; ");
            it = node.updaters().iterator();
            while (it.hasNext()) {
                e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(") ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(IfStatement node) {
            this.printIndent();
            this.buffer.append("if (");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(") ");
            node.getThenStatement().accept((ASTVisitor)this);
            if (node.getElseStatement() != null) {
                this.buffer.append(" else ");
                node.getElseStatement().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ImportDeclaration node) {
            this.printIndent();
            this.buffer.append("import ");
            if (node.getAST().apiLevel() >= 3 && node.isStatic()) {
                this.buffer.append("static ");
            }
            node.getName().accept((ASTVisitor)this);
            if (node.isOnDemand()) {
                this.buffer.append(".*");
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(InfixExpression node) {
            node.getLeftOperand().accept((ASTVisitor)this);
            this.buffer.append(' ');
            this.buffer.append(node.getOperator().toString());
            this.buffer.append(' ');
            node.getRightOperand().accept((ASTVisitor)this);
            List extendedOperands = node.extendedOperands();
            if (extendedOperands.size() != 0) {
                this.buffer.append(' ');
                Iterator it = extendedOperands.iterator();
                while (it.hasNext()) {
                    this.buffer.append(node.getOperator().toString()).append(' ');
                    Expression e = (Expression)it.next();
                    e.accept((ASTVisitor)this);
                }
            }
            return false;
        }

        public boolean visit(Initializer node) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
            }
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(InstanceofExpression node) {
            node.getLeftOperand().accept((ASTVisitor)this);
            this.buffer.append(" instanceof ");
            node.getRightOperand().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(IntersectionType node) {
            Iterator it = node.types().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(" & ");
            }
            return false;
        }

        public boolean visit(Javadoc node) {
            this.printIndent();
            this.buffer.append("/** ");
            for (ASTNode e : node.tags()) {
                e.accept((ASTVisitor)this);
            }
            this.buffer.append("\n */\n");
            return false;
        }

        public boolean visit(LabeledStatement node) {
            this.printIndent();
            node.getLabel().accept((ASTVisitor)this);
            this.buffer.append(": ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(LambdaExpression node) {
            boolean hasParentheses = node.hasParentheses();
            if (hasParentheses) {
                this.buffer.append('(');
            }
            Iterator it = node.parameters().iterator();
            while (it.hasNext()) {
                VariableDeclaration v = (VariableDeclaration)it.next();
                v.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            if (hasParentheses) {
                this.buffer.append(')');
            }
            this.buffer.append(" -> ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(LineComment node) {
            this.buffer.append("//\n");
            return false;
        }

        public boolean visit(MarkerAnnotation node) {
            this.buffer.append("@");
            node.getTypeName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(MemberRef node) {
            if (node.getQualifier() != null) {
                node.getQualifier().accept((ASTVisitor)this);
            }
            this.buffer.append("#");
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(MemberValuePair node) {
            node.getName().accept((ASTVisitor)this);
            this.buffer.append("=");
            node.getValue().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            Type receiverType;
            Iterator it;
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printIndent();
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
                if (!node.typeParameters().isEmpty()) {
                    this.buffer.append("<");
                    it = node.typeParameters().iterator();
                    while (it.hasNext()) {
                        TypeParameter t = (TypeParameter)it.next();
                        t.accept((ASTVisitor)this);
                        if (!it.hasNext()) continue;
                        this.buffer.append(",");
                    }
                    this.buffer.append(">");
                }
            }
            if (!node.isConstructor()) {
                if (node.getAST().apiLevel() == 2) {
                    RemoteEvaluatorBuilder.getReturnType(node).accept((ASTVisitor)this);
                } else if (node.getReturnType2() != null) {
                    node.getReturnType2().accept((ASTVisitor)this);
                } else {
                    this.buffer.append("void");
                }
                this.buffer.append(" ");
            }
            node.getName().accept((ASTVisitor)this);
            this.buffer.append("(");
            if (node.getAST().apiLevel() >= 8 && (receiverType = node.getReceiverType()) != null) {
                receiverType.accept((ASTVisitor)this);
                this.buffer.append(' ');
                SimpleName qualifier = node.getReceiverQualifier();
                if (qualifier != null) {
                    qualifier.accept((ASTVisitor)this);
                    this.buffer.append('.');
                }
                this.buffer.append("this");
                if (node.parameters().size() > 0) {
                    this.buffer.append(',');
                }
            }
            it = node.parameters().iterator();
            while (it.hasNext()) {
                SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
                v.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
            int size = node.getExtraDimensions();
            if (node.getAST().apiLevel() >= 8) {
                List dimensions = node.extraDimensions();
                int i = 0;
                while (i < size) {
                    this.visit((Dimension)dimensions.get(i));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    this.buffer.append("[]");
                    ++i;
                }
            }
            if (node.getAST().apiLevel() < 8) {
                if (!RemoteEvaluatorBuilder.thrownExceptions(node).isEmpty()) {
                    this.buffer.append(" throws ");
                    Iterator<?> it2 = RemoteEvaluatorBuilder.thrownExceptions(node).iterator();
                    while (it2.hasNext()) {
                        Name n = (Name)it2.next();
                        n.accept((ASTVisitor)this);
                        if (!it2.hasNext()) continue;
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
            } else if (!node.thrownExceptionTypes().isEmpty()) {
                this.buffer.append(" throws ");
                Iterator it3 = node.thrownExceptionTypes().iterator();
                while (it3.hasNext()) {
                    Type n = (Type)it3.next();
                    n.accept((ASTVisitor)this);
                    if (!it3.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
            if (node.getBody() == null) {
                this.buffer.append(";\n");
            } else {
                node.getBody().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(MethodInvocation node) {
            Iterator it;
            if (node.getExpression() != null) {
                node.getExpression().accept((ASTVisitor)this);
                this.buffer.append(".");
            } else {
                String newVarName = String.valueOf(new String(ICodeSnippetRequestor.LOCAL_VAR_PREFIX)) + RemoteEvaluatorBuilder.this.allocateNewVariable(node.resolveMethodBinding().getDeclaringClass(), "this");
                RemoteEvaluatorBuilder.this.binder.bindThis(RemoteEvaluatorBuilder.this.enclosingClass, newVarName);
                this.buffer.append(newVarName);
                this.buffer.append(".");
            }
            if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
                this.buffer.append("<");
                it = node.typeArguments().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
            node.getName().accept((ASTVisitor)this);
            this.buffer.append("(");
            it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
            return false;
        }

        public boolean visit(MethodRef node) {
            if (node.getQualifier() != null) {
                node.getQualifier().accept((ASTVisitor)this);
            }
            this.buffer.append("#");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append("(");
            Iterator it = node.parameters().iterator();
            while (it.hasNext()) {
                MethodRefParameter e = (MethodRefParameter)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
            return false;
        }

        public boolean visit(MethodRefParameter node) {
            node.getType().accept((ASTVisitor)this);
            if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
                this.buffer.append("...");
            }
            if (node.getName() != null) {
                this.buffer.append(" ");
                node.getName().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(Modifier node) {
            this.buffer.append(node.getKeyword().toString());
            return false;
        }

        public boolean visit(ModuleDeclaration node) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            this.printModifiers(node.annotations());
            if (node.isOpen()) {
                this.buffer.append("open ");
            }
            this.buffer.append("module");
            this.buffer.append(" ");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append(" {\n");
            ++this.indent;
            for (ModuleDirective stmt : node.moduleStatements()) {
                stmt.accept((ASTVisitor)this);
            }
            --this.indent;
            this.buffer.append("}");
            return false;
        }

        public boolean visit(ModuleModifier node) {
            this.buffer.append(node.getKeyword().toString());
            return false;
        }

        private boolean visit(ModulePackageAccess node, String keyword) {
            this.printIndent();
            this.buffer.append(keyword);
            this.buffer.append(" ");
            node.getName().accept((ASTVisitor)this);
            this.printTypes(node.modules(), "to");
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(NameQualifiedType node) {
            node.getQualifier().accept((ASTVisitor)this);
            this.buffer.append('.');
            this.visitTypeAnnotations((AnnotatableType)node);
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(NormalAnnotation node) {
            this.buffer.append("@");
            node.getTypeName().accept((ASTVisitor)this);
            this.buffer.append("(");
            Iterator it = node.values().iterator();
            while (it.hasNext()) {
                MemberValuePair p = (MemberValuePair)it.next();
                p.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
            return false;
        }

        public boolean visit(NullLiteral node) {
            this.buffer.append("null");
            return false;
        }

        public boolean visit(NumberLiteral node) {
            this.buffer.append(node.getToken());
            return false;
        }

        public boolean visit(OpensDirective node) {
            return this.visit((ModulePackageAccess)node, "opens");
        }

        public boolean visit(PackageDeclaration node) {
            if (node.getAST().apiLevel() >= 3) {
                if (node.getJavadoc() != null) {
                    node.getJavadoc().accept((ASTVisitor)this);
                }
                for (Annotation p : node.annotations()) {
                    p.accept((ASTVisitor)this);
                    this.buffer.append(" ");
                }
            }
            this.printIndent();
            this.buffer.append("package ");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(ParameterizedType node) {
            node.getType().accept((ASTVisitor)this);
            this.buffer.append("<");
            Iterator it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
            return false;
        }

        public boolean visit(ParenthesizedExpression node) {
            this.buffer.append("(");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(")");
            return false;
        }

        public boolean visit(PostfixExpression node) {
            node.getOperand().accept((ASTVisitor)this);
            this.buffer.append(node.getOperator().toString());
            return false;
        }

        public boolean visit(PrefixExpression node) {
            this.buffer.append(node.getOperator().toString());
            node.getOperand().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(PrimitiveType node) {
            this.visitTypeAnnotations((AnnotatableType)node);
            this.buffer.append(node.getPrimitiveTypeCode().toString());
            return false;
        }

        public boolean visit(ProvidesDirective node) {
            this.printIndent();
            this.buffer.append("provides");
            this.buffer.append(" ");
            node.getName().accept((ASTVisitor)this);
            this.printTypes(node.implementations(), "with");
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(QualifiedName node) {
            node.getQualifier().accept((ASTVisitor)this);
            this.buffer.append(".");
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(QualifiedType node) {
            node.getQualifier().accept((ASTVisitor)this);
            this.buffer.append(".");
            this.visitTypeAnnotations((AnnotatableType)node);
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(RequiresDirective node) {
            this.printIndent();
            this.buffer.append("requires");
            this.buffer.append(" ");
            this.printModifiers(node.modifiers());
            node.getName().accept((ASTVisitor)this);
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(ReturnStatement node) {
            this.printIndent();
            this.buffer.append("return");
            if (node.getExpression() != null) {
                this.buffer.append(" ");
                node.getExpression().accept((ASTVisitor)this);
            }
            this.buffer.append(";\n");
            return false;
        }

        private boolean needToQualify(SimpleName node) {
            return !(node.getParent() instanceof QualifiedName) && !(node.getParent() instanceof QualifiedType);
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (!this.isLocalBinding(binding) && binding instanceof IVariableBinding) {
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isField()) {
                    if (Modifier.isStatic((int)vb.getModifiers())) {
                        if (this.needToQualify(node)) {
                            ITypeBinding declaringClass = vb.getDeclaringClass();
                            this.buffer.append(declaringClass.getQualifiedName());
                            this.buffer.append(".");
                        }
                        this.buffer.append(node.getIdentifier());
                    } else {
                        ITypeBinding declaringClass = vb.getDeclaringClass();
                        String newVarName = RemoteEvaluatorBuilder.this.allocateNewVariable(declaringClass, ICodeSnippetRequestor.LOCAL_VAR_PREFIX.concat("this"));
                        RemoteEvaluatorBuilder.this.binder.bindThis(declaringClass, newVarName);
                        this.buffer.append(newVarName);
                        this.buffer.append(".");
                        this.buffer.append(node.getIdentifier());
                    }
                } else {
                    String newVarName = String.valueOf(new String(ICodeSnippetRequestor.LOCAL_VAR_PREFIX)) + RemoteEvaluatorBuilder.this.allocateNewVariable(vb.getType(), node.getIdentifier());
                    RemoteEvaluatorBuilder.this.binder.bind((IVariableBinding)binding, newVarName);
                    this.buffer.append(newVarName);
                }
                return false;
            }
            this.buffer.append(node.getIdentifier());
            return false;
        }

        public boolean visit(SimpleType node) {
            this.visitTypeAnnotations((AnnotatableType)node);
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(SingleMemberAnnotation node) {
            this.buffer.append("@");
            node.getTypeName().accept((ASTVisitor)this);
            this.buffer.append("(");
            node.getValue().accept((ASTVisitor)this);
            this.buffer.append(")");
            return false;
        }

        public boolean visit(SingleVariableDeclaration node) {
            this.printIndent();
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
            }
            node.getType().accept((ASTVisitor)this);
            if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
                if (node.getAST().apiLevel() >= 8) {
                    List annotations = node.varargsAnnotations();
                    if (annotations.size() > 0) {
                        this.buffer.append(' ');
                    }
                    this.visitAnnotationsList(annotations);
                }
                this.buffer.append("...");
            }
            this.buffer.append(" ");
            node.getName().accept((ASTVisitor)this);
            int size = node.getExtraDimensions();
            if (node.getAST().apiLevel() >= 8) {
                List dimensions = node.extraDimensions();
                int i = 0;
                while (i < size) {
                    this.visit((Dimension)dimensions.get(i));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    this.buffer.append("[]");
                    ++i;
                }
            }
            if (node.getInitializer() != null) {
                this.buffer.append("=");
                node.getInitializer().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(StringLiteral node) {
            this.buffer.append(node.getEscapedValue());
            return false;
        }

        public boolean visit(SuperConstructorInvocation node) {
            Iterator it;
            this.printIndent();
            if (node.getExpression() != null) {
                node.getExpression().accept((ASTVisitor)this);
                this.buffer.append(".");
            }
            if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
                this.buffer.append("<");
                it = node.typeArguments().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
            this.buffer.append("super(");
            it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(");\n");
            return false;
        }

        public boolean visit(SuperFieldAccess node) {
            if (node.getQualifier() != null) {
                node.getQualifier().accept((ASTVisitor)this);
                this.buffer.append(".");
            }
            this.buffer.append("super.");
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            Iterator it;
            if (node.getQualifier() != null) {
                node.getQualifier().accept((ASTVisitor)this);
                this.buffer.append(".");
            }
            this.buffer.append("super.");
            if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
                this.buffer.append("<");
                it = node.typeArguments().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
            node.getName().accept((ASTVisitor)this);
            this.buffer.append("(");
            it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
            return false;
        }

        public boolean visit(SuperMethodReference node) {
            if (node.getQualifier() != null) {
                node.getQualifier().accept((ASTVisitor)this);
                this.buffer.append('.');
            }
            this.buffer.append("super");
            this.visitReferenceTypeArguments(node.typeArguments());
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(SwitchCase node) {
            if (node.getAST().isPreviewEnabled()) {
                if (node.isDefault()) {
                    this.buffer.append("default");
                    this.buffer.append(node.isSwitchLabeledRule() ? " ->" : ":");
                } else {
                    this.buffer.append("case ");
                    Iterator it = node.expressions().iterator();
                    while (it.hasNext()) {
                        Expression t = (Expression)it.next();
                        t.accept((ASTVisitor)this);
                        this.buffer.append(it.hasNext() ? ", " : (node.isSwitchLabeledRule() ? " ->" : ":"));
                    }
                }
            } else if (node.isDefault()) {
                this.buffer.append("default :\n");
            } else {
                this.buffer.append("case ");
                this.getSwitchExpression(node).accept((ASTVisitor)this);
                this.buffer.append(":\n");
            }
            ++this.indent;
            return false;
        }

        @Deprecated
        private Expression getSwitchExpression(SwitchCase node) {
            return node.getExpression();
        }

        private void visitSwitchNode(ASTNode node) {
            this.buffer.append("switch (");
            if (node instanceof SwitchExpression) {
                ((SwitchExpression)node).getExpression().accept((ASTVisitor)this);
            } else if (node instanceof SwitchStatement) {
                ((SwitchStatement)node).getExpression().accept((ASTVisitor)this);
            }
            this.buffer.append(") ");
            this.buffer.append("{\n");
            ++this.indent;
            if (node instanceof SwitchExpression) {
                for (Statement s : ((SwitchExpression)node).statements()) {
                    s.accept((ASTVisitor)this);
                    --this.indent;
                }
            } else if (node instanceof SwitchStatement) {
                for (Statement s : ((SwitchStatement)node).statements()) {
                    s.accept((ASTVisitor)this);
                    --this.indent;
                }
            }
            --this.indent;
            this.printIndent();
            this.buffer.append("}\n");
        }

        public boolean visit(SwitchExpression node) {
            this.visitSwitchNode((ASTNode)node);
            return false;
        }

        public boolean visit(SwitchStatement node) {
            this.visitSwitchNode((ASTNode)node);
            return false;
        }

        public boolean visit(SynchronizedStatement node) {
            this.buffer.append("synchronized (");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(") ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(TagElement node) {
            return false;
        }

        public boolean visit(TextBlock node) {
            this.buffer.append(node.getEscapedValue());
            return false;
        }

        public boolean visit(TextElement node) {
            this.buffer.append(node.getText());
            return false;
        }

        public boolean visit(ThisExpression node) {
            ITypeBinding thisType = node.resolveTypeBinding();
            String newVarName = RemoteEvaluatorBuilder.this.allocateNewVariable(thisType, ICodeSnippetRequestor.LOCAL_VAR_PREFIX.concat("this"));
            RemoteEvaluatorBuilder.this.binder.bindThis(thisType, newVarName);
            this.buffer.append(newVarName);
            return false;
        }

        public boolean visit(ThrowStatement node) {
            this.printIndent();
            this.buffer.append("throw ");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(TryStatement node) {
            List resources;
            this.printIndent();
            this.buffer.append("try ");
            if (node.getAST().apiLevel() >= 4 && !(resources = node.resources()).isEmpty()) {
                this.buffer.append('(');
                Iterator it = resources.iterator();
                while (it.hasNext()) {
                    Expression variable = (Expression)it.next();
                    variable.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(';');
                }
                this.buffer.append(')');
            }
            node.getBody().accept((ASTVisitor)this);
            this.buffer.append(" ");
            for (CatchClause cc : node.catchClauses()) {
                cc.accept((ASTVisitor)this);
            }
            if (node.getFinally() != null) {
                this.buffer.append(" finally ");
                node.getFinally().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            TypeParameter t;
            Iterator it;
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
            }
            this.buffer.append(node.isInterface() ? "interface " : "class ");
            node.getName().accept((ASTVisitor)this);
            if (node.getAST().apiLevel() >= 3 && !node.typeParameters().isEmpty()) {
                this.buffer.append("<");
                it = node.typeParameters().iterator();
                while (it.hasNext()) {
                    t = (TypeParameter)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
            this.buffer.append(" ");
            if (node.getAST().apiLevel() == 2) {
                if (RemoteEvaluatorBuilder.getSuperclass(node) != null) {
                    this.buffer.append("extends ");
                    RemoteEvaluatorBuilder.getSuperclass(node).accept((ASTVisitor)this);
                    this.buffer.append(" ");
                }
                if (!this.superInterfaces(node).isEmpty()) {
                    this.buffer.append(node.isInterface() ? "extends " : "implements ");
                    it = this.superInterfaces(node).iterator();
                    while (it.hasNext()) {
                        Name n = (Name)it.next();
                        n.accept((ASTVisitor)this);
                        if (!it.hasNext()) continue;
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
            }
            if (node.getAST().apiLevel() >= 3) {
                if (node.getSuperclassType() != null) {
                    this.buffer.append("extends ");
                    node.getSuperclassType().accept((ASTVisitor)this);
                    this.buffer.append(" ");
                }
                if (!node.superInterfaceTypes().isEmpty()) {
                    this.buffer.append(node.isInterface() ? "extends " : "implements ");
                    it = node.superInterfaceTypes().iterator();
                    while (it.hasNext()) {
                        t = (Type)it.next();
                        t.accept((ASTVisitor)this);
                        if (!it.hasNext()) continue;
                        this.buffer.append(", ");
                    }
                    this.buffer.append(" ");
                }
            }
            this.buffer.append("{\n");
            ++this.indent;
            for (BodyDeclaration d : node.bodyDeclarations()) {
                d.accept((ASTVisitor)this);
            }
            --this.indent;
            this.printIndent();
            this.buffer.append("}\n");
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (node.getAST().apiLevel() == 2) {
                RemoteEvaluatorBuilder.getTypeDeclaration(node).accept((ASTVisitor)this);
            }
            if (node.getAST().apiLevel() >= 3) {
                node.getDeclaration().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(TypeLiteral node) {
            node.getType().accept((ASTVisitor)this);
            this.buffer.append(".class");
            return false;
        }

        public boolean visit(TypeMethodReference node) {
            node.getType().accept((ASTVisitor)this);
            this.visitReferenceTypeArguments(node.typeArguments());
            node.getName().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(TypeParameter node) {
            if (node.getAST().apiLevel() >= 8) {
                this.printModifiers(node.modifiers());
            }
            node.getName().accept((ASTVisitor)this);
            if (!node.typeBounds().isEmpty()) {
                this.buffer.append(" extends ");
                Iterator it = node.typeBounds().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(" & ");
                }
            }
            return false;
        }

        public boolean visit(UnionType node) {
            Iterator it = node.types().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append('|');
            }
            return false;
        }

        public boolean visit(UsesDirective node) {
            this.printIndent();
            this.buffer.append("uses");
            this.buffer.append(" ");
            node.getName().accept((ASTVisitor)this);
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
            }
            node.getType().accept((ASTVisitor)this);
            this.buffer.append(" ");
            Iterator it = node.fragments().iterator();
            while (it.hasNext()) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                f.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            return false;
        }

        public boolean visit(VariableDeclarationFragment node) {
            this.addLocalBinding((IBinding)node.resolveBinding(), node.getName().getIdentifier());
            this.buffer.append(node.getName().getIdentifier());
            int size = node.getExtraDimensions();
            if (node.getAST().apiLevel() >= 8) {
                List dimensions = node.extraDimensions();
                int i = 0;
                while (i < size) {
                    this.visit((Dimension)dimensions.get(i));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    this.buffer.append("[]");
                    ++i;
                }
            }
            if (node.getInitializer() != null) {
                this.buffer.append("=");
                node.getInitializer().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(VariableDeclarationStatement node) {
            this.printIndent();
            if (node.getAST().apiLevel() == 2) {
                this.printModifiers(node.getModifiers());
            }
            if (node.getAST().apiLevel() >= 3) {
                this.printModifiers(node.modifiers());
            }
            node.getType().accept((ASTVisitor)this);
            this.buffer.append(" ");
            Iterator it = node.fragments().iterator();
            while (it.hasNext()) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                f.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(";\n");
            return false;
        }

        public boolean visit(WhileStatement node) {
            this.printIndent();
            this.buffer.append("while (");
            node.getExpression().accept((ASTVisitor)this);
            this.buffer.append(") ");
            node.getBody().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(WildcardType node) {
            this.visitTypeAnnotations((AnnotatableType)node);
            this.buffer.append("?");
            Type bound = node.getBound();
            if (bound != null) {
                if (node.isUpperBound()) {
                    this.buffer.append(" extends ");
                } else {
                    this.buffer.append(" super ");
                }
                bound.accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(YieldStatement node) {
            if (node.getAST().isPreviewEnabled() && node.isImplicit() && node.getExpression() == null) {
                return false;
            }
            this.printIndent();
            this.buffer.append("yield");
            if (node.getExpression() != null) {
                this.buffer.append(" ");
                node.getExpression().accept((ASTVisitor)this);
            }
            this.buffer.append(";\n");
            return false;
        }

        @Deprecated
        private void visitComponentType(ArrayType node) {
            node.getComponentType().accept((ASTVisitor)this);
        }
    }
}

