/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyAttributeDescriptionAction
extends BrowserAction {
    public void run() {
        StringBuffer text = new StringBuffer();
        boolean isFirst = true;
        for (String attributeName : this.getAttributeNameSet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                text.append(BrowserCoreConstants.LINE_SEPARATOR);
            }
            text.append(attributeName);
        }
        if (text.length() > 0) {
            CopyAction.copyToClipboard((Object[])new Object[]{text.toString()}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private Set<String> getAttributeNameSet() {
        LinkedHashSet<String> attributeNameSet = new LinkedHashSet<String>();
        AttributeHierarchy[] attributeHierarchyArray = this.getSelectedAttributeHierarchies();
        int n = attributeHierarchyArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeHierarchy attributeHierarchy = attributeHierarchyArray[n2];
            for (IAttribute attribute : attributeHierarchy) {
                attributeNameSet.add(attribute.getDescription());
            }
            ++n2;
        }
        attributeHierarchyArray = this.getSelectedAttributes();
        n = attributeHierarchyArray.length;
        n2 = 0;
        while (n2 < n) {
            AttributeHierarchy attribute = attributeHierarchyArray[n2];
            attributeNameSet.add(attribute.getDescription());
            ++n2;
        }
        attributeHierarchyArray = this.getSelectedValues();
        n = attributeHierarchyArray.length;
        n2 = 0;
        while (n2 < n) {
            AttributeHierarchy value = attributeHierarchyArray[n2];
            attributeNameSet.add(value.getAttribute().getDescription());
            ++n2;
        }
        return attributeNameSet;
    }

    public String getText() {
        if (this.getAttributeNameSet().size() > 1) {
            return Messages.getString("CopyAttributeDescriptionAction.CopyAttributeDescriptions");
        }
        return Messages.getString("CopyAttributeDescriptionAction.CopyAttributeDescription");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_att.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getAttributeNameSet().size() > 0;
    }
}

