/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

public class SearchResultEditorSorter
extends ViewerSorter
implements SelectionListener {
    protected SearchResultEditorContentProvider contentProvider;
    private ISearch search;
    private TableColumn[] columns;
    private boolean showDn;
    private int sortBy;
    private int sortOrder;

    public void connect(SearchResultEditorContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.sortBy = 0;
        this.sortOrder = 0;
        TableColumn[] tableColumnArray = this.columns = contentProvider.getViewer().getTable().getColumns();
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addSelectionListener((SelectionListener)this);
            ++n2;
        }
    }

    public void inputChanged(ISearch newSearch, boolean showDn) {
        TableColumn column;
        int n;
        int n2;
        TableColumn[] tableColumnArray;
        this.search = newSearch;
        this.showDn = showDn;
        if (this.columns != null) {
            tableColumnArray = this.columns;
            n2 = this.columns.length;
            n = 0;
            while (n < n2) {
                column = tableColumnArray[n];
                column.removeSelectionListener((SelectionListener)this);
                ++n;
            }
        }
        tableColumnArray = this.columns = this.contentProvider.getViewer().getTable().getColumns();
        n2 = this.columns.length;
        n = 0;
        while (n < n2) {
            column = tableColumnArray[n];
            column.addSelectionListener((SelectionListener)this);
            ++n;
        }
        int visibleColumns = this.search.getReturningAttributes().length;
        if (showDn) {
            ++visibleColumns;
        }
        if (visibleColumns < this.sortBy + 1) {
            this.setSortColumn(0);
            this.setSortColumn(0);
            this.setSortColumn(0);
        }
    }

    public void dispose() {
        if (this.columns != null) {
            TableColumn[] tableColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                if (!column.isDisposed()) {
                    column.removeSelectionListener((SelectionListener)this);
                }
                ++n2;
            }
        }
        this.columns = null;
        this.search = null;
        this.contentProvider = null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof TableColumn) {
            int index = this.contentProvider.getViewer().getTable().indexOf((TableColumn)e.widget);
            this.setSortColumn(index);
        }
    }

    private void setSortColumn(int index) {
        TableColumn[] columns;
        if (this.sortBy == index) {
            this.sortOrder = this.sortOrder == 1 ? 2 : (this.sortOrder == 2 ? 0 : 1);
        } else {
            this.sortBy = index;
            this.sortOrder = 1;
        }
        if (this.sortOrder == 0) {
            this.sortBy = 0;
        }
        TableColumn[] tableColumnArray = columns = this.contentProvider.getViewer().getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setImage(null);
            ++n2;
        }
        if (this.sortOrder == 1) {
            columns[index].setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/sort_ascending.gif"));
        } else if (this.sortOrder == 2) {
            columns[index].setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/sort_descending.gif"));
        } else {
            columns[index].setImage(null);
        }
        this.contentProvider.refresh();
    }

    public boolean isSorted() {
        return true;
    }

    public void sort(final Viewer viewer, Object[] elements) {
        if (this.isSorted()) {
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    return SearchResultEditorSorter.this.compare(viewer, a, b);
                }
            });
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (this.search == null) {
            return this.equal();
        }
        ISearchResult sr1 = (ISearchResult)o1;
        ISearchResult sr2 = (ISearchResult)o2;
        IEntry entry1 = sr1.getEntry();
        IEntry entry2 = sr2.getEntry();
        if (entry1 == null) {
            if (entry2 == null) {
                return this.equal();
            }
            return this.lessThan();
        }
        if (entry2 == null) {
            return this.greaterThan();
        }
        String attributeName = this.showDn && this.sortBy == 0 ? "Dn" : (this.showDn && this.sortBy > 0 ? this.search.getReturningAttributes()[this.sortBy - 1] : this.search.getReturningAttributes()[this.sortBy]);
        if (attributeName == "Dn") {
            return this.compare(entry1.getDn().getNormName(), entry2.getDn().getNormName());
        }
        AttributeHierarchy ah1 = entry1.getAttributeWithSubtypes(attributeName);
        AttributeHierarchy ah2 = entry2.getAttributeWithSubtypes(attributeName);
        if (ah1 == null) {
            if (ah2 == null) {
                return this.equal();
            }
            return this.lessThan();
        }
        if (ah2 == null) {
            return this.greaterThan();
        }
        IAttribute attribute1 = ah1.getAttribute();
        IAttribute attribute2 = ah2.getAttribute();
        String value1 = this.getValue(attribute1);
        String value2 = this.getValue(attribute2);
        return this.compare(value1, value2);
    }

    private String getValue(IAttribute attribute) {
        if (attribute.getValueSize() > 0) {
            return attribute.getStringValue();
        }
        return "";
    }

    private int lessThan() {
        return this.sortOrder == 1 ? -1 : 1;
    }

    private int equal() {
        return 0;
    }

    private int greaterThan() {
        return this.sortOrder == 1 ? 1 : -1;
    }

    private int compare(String s1, String s2) {
        return this.sortOrder == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }
}

