/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class EntryEditorWidgetFilter
extends ViewerFilter {
    protected TreeViewer viewer;
    protected String quickFilterAttribute = "";
    protected String quickFilterValue = "";

    public void connect(TreeViewer viewer) {
        this.viewer = viewer;
        viewer.addFilter((ViewerFilter)this);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IAttribute) {
            IValue[] values;
            IValue[] iValueArray = values = ((IAttribute)element).getValues();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IValue value = iValueArray[n2];
                if (this.goesThroughQuickFilter(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (element instanceof IValue) {
            return this.goesThroughQuickFilter((IValue)element);
        }
        return true;
    }

    private boolean goesThroughQuickFilter(IValue value) {
        if (!Strings.isEmpty((String)this.quickFilterAttribute) && value.getAttribute().getDescription().toUpperCase().indexOf(this.quickFilterAttribute.toUpperCase()) == -1) {
            return false;
        }
        if (!Strings.isEmpty((String)this.quickFilterValue)) {
            if (value.isString() && value.getStringValue().toUpperCase().indexOf(this.quickFilterValue.toUpperCase()) == -1) {
                return false;
            }
            if (value.isBinary()) {
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        this.viewer = null;
    }

    public String getQuickFilterAttribute() {
        return this.quickFilterAttribute;
    }

    public void setQuickFilterAttribute(String quickFilterAttribute) {
        if (!this.quickFilterAttribute.equals(quickFilterAttribute)) {
            String oldValue = this.quickFilterAttribute;
            this.quickFilterAttribute = quickFilterAttribute;
            BrowserCommonActivator.getDefault().getPreferenceStore().firePropertyChangeEvent("QuickFilterAttributeChanged", (Object)oldValue, (Object)quickFilterAttribute);
        }
    }

    public String getQuickFilterValue() {
        return this.quickFilterValue;
    }

    public void setQuickFilterValue(String quickFilterValue) {
        if (!this.quickFilterValue.equals(quickFilterValue)) {
            String oldValue = this.quickFilterValue;
            this.quickFilterValue = quickFilterValue;
            BrowserCommonActivator.getDefault().getPreferenceStore().firePropertyChangeEvent("QuickFilterValueChanged", (Object)oldValue, (Object)this.quickFilterAttribute);
        }
    }
}

