/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReloadSchemaRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class ReloadSchemaAction
extends BrowserAction {
    public void run() {
        IBrowserConnection connection = this.getConnectionToRefresh();
        if (connection != null) {
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ReloadSchemaRunnable(connection)}).execute();
        }
    }

    public String getText() {
        return Messages.getString("ReloadSchemaAction.ReloadSchema");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/refresh.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getConnectionToRefresh() != null;
    }

    private IBrowserConnection getConnectionToRefresh() {
        Connection[] connections = this.getSelectedConnections();
        if (connections.length != 1) {
            return null;
        }
        Connection connection = connections[0];
        if (!connection.getConnectionWrapper().isConnected()) {
            return null;
        }
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        return browserConnection;
    }
}

