/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.concurrent.Execs;

public class FileSessionCredentialsProvider
implements AWSCredentialsProvider {
    private final ScheduledExecutorService scheduler = Execs.scheduledSingleThreaded((String)"FileSessionCredentialsProviderRefresh-%d");
    private final String sessionCredentialsFile;
    private AWSSessionCredentials awsSessionCredentials;

    public FileSessionCredentialsProvider(String sessionCredentialsFile) {
        this.sessionCredentialsFile = sessionCredentialsFile;
        this.refresh();
        this.scheduler.scheduleAtFixedRate(this::refresh, 1L, 1L, TimeUnit.HOURS);
    }

    public AWSCredentials getCredentials() {
        return this.awsSessionCredentials;
    }

    public void refresh() {
        try {
            Properties props = new Properties();
            try (InputStream is = Files.newInputStream(Paths.get(this.sessionCredentialsFile, new String[0]), new OpenOption[0]);){
                props.load(is);
            }
            String sessionToken = props.getProperty("sessionToken");
            String accessKey = props.getProperty("accessKey");
            String secretKey = props.getProperty("secretKey");
            this.awsSessionCredentials = new Credentials(sessionToken, accessKey, secretKey);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot refresh AWS credentials", e);
        }
    }

    private static class Credentials
    implements AWSSessionCredentials {
        private final String sessionToken;
        private final String accessKey;
        private final String secretKey;

        private Credentials(String sessionToken, String accessKey, String secretKey) {
            this.sessionToken = sessionToken;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getAWSAccessKeyId() {
            return this.accessKey;
        }

        public String getAWSSecretKey() {
            return this.secretKey;
        }
    }
}

