/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.List;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.msq.counters.CpuCounter;
import org.apache.druid.utils.JvmUtils;

public class CpuTimeAccumulatingFrameProcessor<T>
implements FrameProcessor<T> {
    private final FrameProcessor<T> delegate;
    private final CpuCounter counter;

    public CpuTimeAccumulatingFrameProcessor(FrameProcessor<T> delegate, CpuCounter counter) {
        this.delegate = delegate;
        this.counter = counter;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return this.delegate.inputChannels();
    }

    public List<WritableFrameChannel> outputChannels() {
        return this.delegate.outputChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnOrAwait<T> runIncrementally(IntSet readableInputs) throws InterruptedException, IOException {
        long startCpu = JvmUtils.getCurrentThreadCpuTime();
        long startWall = System.nanoTime();
        try {
            ReturnOrAwait returnOrAwait = this.delegate.runIncrementally(readableInputs);
            return returnOrAwait;
        }
        finally {
            this.counter.accumulate(JvmUtils.getCurrentThreadCpuTime() - startCpu, System.nanoTime() - startWall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws IOException {
        long startCpu = JvmUtils.getCurrentThreadCpuTime();
        long startWall = System.nanoTime();
        try {
            this.delegate.cleanup();
        }
        finally {
            this.counter.accumulate(JvmUtils.getCurrentThreadCpuTime() - startCpu, System.nanoTime() - startWall);
        }
    }
}

