/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;

@JsonTypeName(value="warnings")
public class WarningCounters
implements QueryCounter {
    private final ConcurrentHashMap<String, Long> warningCodeCounter = new ConcurrentHashMap();

    public void incrementWarningCount(String errorCode) {
        this.warningCodeCounter.compute(errorCode, (ignored, oldCount) -> oldCount == null ? 1L : oldCount + 1L);
    }

    @Override
    @Nullable
    public Snapshot snapshot() {
        if (this.warningCodeCounter.isEmpty()) {
            return null;
        }
        ImmutableMap countCopy = ImmutableMap.copyOf(this.warningCodeCounter);
        return new Snapshot((Map<String, Long>)countCopy);
    }

    @JsonTypeName(value="warnings")
    public static class Snapshot
    implements QueryCounterSnapshot {
        private final Map<String, Long> warningCountMap;

        @JsonCreator
        public Snapshot(Map<String, Long> warningCountMap) {
            this.warningCountMap = (Map)Preconditions.checkNotNull(warningCountMap, (Object)"warningCountMap");
        }

        @JsonValue
        public Map<String, Long> getWarningCountMap() {
            return this.warningCountMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return Objects.equals(this.warningCountMap, snapshot.warningCountMap);
        }

        public int hashCode() {
            return Objects.hash(this.warningCountMap);
        }
    }
}

