/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureBox;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.controller.messages.DoneReadingInput;
import org.apache.druid.msq.dart.controller.messages.PartialKeyStatistics;
import org.apache.druid.msq.dart.controller.messages.ResultsComplete;
import org.apache.druid.msq.dart.controller.messages.WorkerError;
import org.apache.druid.msq.dart.controller.messages.WorkerWarning;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

public class DartControllerClient
implements ControllerClient {
    private final Outbox<ControllerMessage> outbox;
    private final String queryId;
    private final String controllerHost;
    private final FutureBox futureBox = new FutureBox();

    public DartControllerClient(Outbox<ControllerMessage> outbox, String queryId, String controllerHost) {
        this.outbox = outbox;
        this.queryId = queryId;
        this.controllerHost = controllerHost;
    }

    @Override
    public void postPartialKeyStatistics(StageId stageId, int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) {
        this.validateStage(stageId);
        this.sendMessage(new PartialKeyStatistics(stageId, workerNumber, partialKeyStatisticsInformation));
    }

    @Override
    public void postDoneReadingInput(StageId stageId, int workerNumber) {
        this.validateStage(stageId);
        this.sendMessage(new DoneReadingInput(stageId, workerNumber));
    }

    @Override
    public void postResultsComplete(StageId stageId, int workerNumber, @Nullable Object resultObject) {
        this.validateStage(stageId);
        this.sendMessage(new ResultsComplete(stageId, workerNumber, resultObject));
    }

    @Override
    public void postWorkerError(MSQErrorReport errorWrapper) {
        this.sendMessage(new WorkerError(this.queryId, errorWrapper));
    }

    @Override
    public void postWorkerWarning(List<MSQErrorReport> errorWrappers) {
        this.sendMessage(new WorkerWarning(this.queryId, errorWrappers));
    }

    @Override
    public void postCounters(String workerId, CounterSnapshotsTree snapshotsTree) {
    }

    @Override
    public List<String> getWorkerIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.futureBox.close();
    }

    private void sendMessage(ControllerMessage message) {
        FutureUtils.getUnchecked((ListenableFuture)this.futureBox.register(this.outbox.sendMessage(this.controllerHost, (Object)message)), (boolean)true);
    }

    private void validateStage(StageId stageId) {
        if (!stageId.getQueryId().equals(this.queryId)) {
            throw DruidException.defensive((String)"Expected queryId[%s] but got queryId[%s], stageNumber[%s]", (Object[])new Object[]{this.queryId, stageId.getQueryId(), stageId.getStageNumber()});
        }
    }
}

