/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.messages.server.MessageRelayResource;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.worker.DartWorkerRunner;
import org.apache.druid.msq.dart.worker.http.GetWorkersResponse;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.rpc.MSQResourceUtils;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.msq.rpc.WorkerResource;
import org.apache.druid.server.initialization.jetty.ServiceUnavailableException;
import org.apache.druid.server.security.AuthorizerMapper;

@LazySingleton
@Path(value="/druid/dart-worker/")
public class DartWorkerResource {
    public static final String PATH = "/druid/dart-worker";
    public static final String HEADER_CONTROLLER_HOST = "X-Dart-Controller-Host";
    private final DartWorkerRunner workerRunner;
    private final ResourcePermissionMapper permissionMapper;
    private final AuthorizerMapper authorizerMapper;
    private final MessageRelayResource<ControllerMessage> messageRelayResource;

    @Inject
    public DartWorkerResource(DartWorkerRunner workerRunner, @Dart ResourcePermissionMapper permissionMapper, @Smile ObjectMapper smileMapper, Outbox<ControllerMessage> outbox, AuthorizerMapper authorizerMapper) {
        this.workerRunner = workerRunner;
        this.permissionMapper = permissionMapper;
        this.authorizerMapper = authorizerMapper;
        this.messageRelayResource = new MessageRelayResource(outbox, smileMapper, ControllerMessage.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/workers")
    public GetWorkersResponse httpGetWorkers(@Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        return this.workerRunner.getWorkersResponse();
    }

    @POST
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/workers/{queryId}/workOrder")
    public Response httpPostWorkOrder(WorkOrder workOrder, @PathParam(value="queryId") String queryId, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        String controllerHost = req.getHeader(HEADER_CONTROLLER_HOST);
        if (controllerHost == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.INVALID_INPUT).build("Missing controllerId[%s]", new Object[]{HEADER_CONTROLLER_HOST});
        }
        this.workerRunner.startWorker(queryId, controllerHost, workOrder.getWorkerContext()).postWorkOrder(workOrder);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/workers/{queryId}/stop")
    public Response httpPostStopWorker(@PathParam(value="queryId") String queryId, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.workerRunner.stopWorker(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @Path(value="/workers/{queryId}")
    public Object httpCallWorkerResource(@PathParam(value="queryId") String queryId, @Context HttpServletRequest req) {
        WorkerResource resource = this.workerRunner.getWorkerResource(queryId);
        if (resource != null) {
            return resource;
        }
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        throw new ServiceUnavailableException(StringUtils.format((String)"No worker running for query[%s]", (Object[])new Object[]{queryId}));
    }

    @Path(value="/relay")
    public Object httpCallMessageRelayServer(@Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        return this.messageRelayResource;
    }
}

