/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;

public class WorkerInputs {
    private final Int2ObjectSortedMap<List<InputSlice>> assignmentsMap;

    private WorkerInputs(Int2ObjectSortedMap<List<InputSlice>> assignmentsMap) {
        this.assignmentsMap = assignmentsMap;
    }

    public static WorkerInputs create(StageDefinition stageDef, Int2IntMap stageWorkerCountMap, InputSpecSlicer slicer, WorkerAssignmentStrategy assignmentStrategy, long maxInputBytesPerWorker) {
        Int2ObjectAVLTreeMap assignmentsMap = new Int2ObjectAVLTreeMap();
        int numInputs = stageDef.getInputSpecs().size();
        if (numInputs == 0) {
            assignmentsMap.put(0, Collections.singletonList(NilInputSlice.INSTANCE));
            return new WorkerInputs((Int2ObjectSortedMap<List<InputSlice>>)assignmentsMap);
        }
        for (int inputNumber = 0; inputNumber < numInputs; ++inputNumber) {
            InputSpec inputSpec = stageDef.getInputSpecs().get(inputNumber);
            if (stageDef.getBroadcastInputNumbers().contains(inputNumber)) {
                List<InputSlice> broadcastSlices = slicer.sliceStatic(inputSpec, 1);
                NilInputSlice broadcastSlice = broadcastSlices.isEmpty() ? NilInputSlice.INSTANCE : (InputSlice)Iterables.getOnlyElement(broadcastSlices);
                for (int workerNumber = 0; workerNumber < stageDef.getMaxWorkerCount(); ++workerNumber) {
                    ((List)assignmentsMap.computeIfAbsent(workerNumber, ignored -> Arrays.asList(new InputSlice[numInputs]))).set(inputNumber, broadcastSlice);
                }
                continue;
            }
            List<InputSlice> slices = assignmentStrategy.assign(stageDef, inputSpec, stageWorkerCountMap, slicer, maxInputBytesPerWorker);
            if (slices.isEmpty()) {
                slices = Collections.singletonList(NilInputSlice.INSTANCE);
            }
            for (int workerNumber = 0; workerNumber < slices.size(); ++workerNumber) {
                ((List)assignmentsMap.computeIfAbsent(workerNumber, ignored -> Arrays.asList(new InputSlice[numInputs]))).set(inputNumber, slices.get(workerNumber));
            }
        }
        ObjectBidirectionalIterator assignmentsIterator = assignmentsMap.int2ObjectEntrySet().iterator();
        IntAVLTreeSet nilWorkers = new IntAVLTreeSet();
        while (assignmentsIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)assignmentsIterator.next();
            List slices = (List)entry.getValue();
            for (int inputNumber = 0; inputNumber < numInputs; ++inputNumber) {
                if (slices.get(inputNumber) != null) continue;
                slices.set(inputNumber, NilInputSlice.INSTANCE);
            }
            boolean isNilWorker = IntStream.range(0, numInputs).allMatch(i -> ((InputSlice)slices.get(i)).equals(NilInputSlice.INSTANCE) || stageDef.getBroadcastInputNumbers().contains(i));
            if (!isNilWorker) continue;
            nilWorkers.add(entry.getIntKey());
        }
        if (nilWorkers.size() == assignmentsMap.size()) {
            List firstSlices = (List)assignmentsMap.get(nilWorkers.firstInt());
            assignmentsMap.clear();
            assignmentsMap.put(nilWorkers.firstInt(), (Object)firstSlices);
        } else {
            IntBidirectionalIterator intBidirectionalIterator = nilWorkers.iterator();
            while (intBidirectionalIterator.hasNext()) {
                int nilWorker = (Integer)intBidirectionalIterator.next();
                assignmentsMap.remove(nilWorker);
            }
        }
        return new WorkerInputs((Int2ObjectSortedMap<List<InputSlice>>)assignmentsMap);
    }

    public List<InputSlice> inputsForWorker(int workerNumber) {
        return (List)Preconditions.checkNotNull((Object)((List)this.assignmentsMap.get(workerNumber)), (String)"worker [%s]", (int)workerNumber);
    }

    public IntSortedSet workers() {
        return this.assignmentsMap.keySet();
    }

    public int workerCount() {
        return this.assignmentsMap.size();
    }

    public Int2ObjectMap<List<InputSlice>> assignmentsMap() {
        return this.assignmentsMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerInputs that = (WorkerInputs)o;
        return Objects.equals(this.assignmentsMap, that.assignmentsMap);
    }

    public int hashCode() {
        return Objects.hash(this.assignmentsMap);
    }

    public String toString() {
        return this.assignmentsMap.toString();
    }
}

