/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import java.util.Comparator;
import java.util.Optional;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.DelegateOrMinKeyCollector;
import org.apache.druid.msq.statistics.DelegateOrMinKeyCollectorSnapshot;
import org.apache.druid.msq.statistics.KeyCollector;
import org.apache.druid.msq.statistics.KeyCollectorFactory;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;

public class DelegateOrMinKeyCollectorFactory<TDelegate extends KeyCollector<TDelegate>, TSnapshot extends KeyCollectorSnapshot>
implements KeyCollectorFactory<DelegateOrMinKeyCollector<TDelegate>, DelegateOrMinKeyCollectorSnapshot<TSnapshot>> {
    private final Comparator<RowKey> comparator;
    private final KeyCollectorFactory<TDelegate, TSnapshot> delegateFactory;

    public DelegateOrMinKeyCollectorFactory(Comparator<RowKey> comparator, KeyCollectorFactory<TDelegate, TSnapshot> delegateFactory) {
        this.comparator = comparator;
        this.delegateFactory = delegateFactory;
    }

    @Override
    public DelegateOrMinKeyCollector<TDelegate> newKeyCollector() {
        return new DelegateOrMinKeyCollector<TDelegate>(this.comparator, this.delegateFactory.newKeyCollector(), null);
    }

    @Override
    public DelegateOrMinKeyCollectorSnapshot<TSnapshot> toSnapshot(DelegateOrMinKeyCollector<TDelegate> collector) {
        RowKey minKeyForSnapshot = !collector.getDelegate().isPresent() && !collector.isEmpty() ? collector.minKey() : null;
        return new DelegateOrMinKeyCollectorSnapshot<KeyCollectorSnapshot>(collector.getDelegate().map(this.delegateFactory::toSnapshot).orElse(null), minKeyForSnapshot);
    }

    @Override
    public DelegateOrMinKeyCollector<TDelegate> fromSnapshot(DelegateOrMinKeyCollectorSnapshot<TSnapshot> snapshot) {
        return new DelegateOrMinKeyCollector<KeyCollector>(this.comparator, Optional.ofNullable(snapshot.getSnapshot()).map(this.delegateFactory::fromSnapshot).orElse(null), snapshot.getMinKey());
    }
}

