/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.event.legacy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.kubernetes.client.openapi.models.CoreV1Event;
import java.time.Duration;
import java.util.function.Function;

public class EventSpamFilter {
    public static final Duration DEFAULT_TOKEN_BUCKET_REFILLING_PERIOD = Duration.ofMinutes(5L);
    public static final int DEFAULT_TOKEN_BUCKET_REFILLING_TOKEN = 1;
    public static final int DEFAULT_TOKEN_BUCKET_CAPACITY = 25;
    private final long capacity;
    private final long refillingTokensPerPeriod;
    private final Duration refillingPeriod;
    private Cache<String, SpamRecord> spamRecordCache;
    private Function<CoreV1Event, String> spamKeyFunc;

    public EventSpamFilter(int maxLRUCacheEntries, Function<CoreV1Event, String> spamKeyFunc) {
        this(maxLRUCacheEntries, spamKeyFunc, 25L, DEFAULT_TOKEN_BUCKET_REFILLING_PERIOD, 1L);
    }

    public EventSpamFilter(int maxLRUCacheEntries, Function<CoreV1Event, String> spamKeyFunc, long tokenBucketCapacity, Duration refillingPeriod, long refillingTokensPerPeriod) {
        this.spamKeyFunc = spamKeyFunc;
        this.capacity = tokenBucketCapacity;
        this.refillingTokensPerPeriod = refillingTokensPerPeriod;
        this.refillingPeriod = refillingPeriod;
        this.spamRecordCache = Caffeine.newBuilder().maximumSize((long)maxLRUCacheEntries).build();
    }

    public boolean filter(CoreV1Event event) {
        String spamKey = this.spamKeyFunc.apply(event);
        SpamRecord record = (SpamRecord)this.spamRecordCache.get((Object)spamKey, k -> new SpamRecord());
        return record.tokenBucket.tryConsume(1L);
    }

    private class SpamRecord {
        private LocalBucket tokenBucket;

        private SpamRecord() {
            this.tokenBucket = Bucket4j.builder().addLimit(Bandwidth.classic((long)EventSpamFilter.this.capacity, (Refill)Refill.greedy((long)EventSpamFilter.this.refillingTokensPerPeriod, (Duration)EventSpamFilter.this.refillingPeriod))).withSynchronizationStrategy(SynchronizationStrategy.LOCK_FREE).build();
        }
    }
}

