/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.joda.time.DateTimeZone;

public class TimeExtractOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_EXTRACT").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperandCount(2).returnTypeCascadeNullable(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    public static DruidExpression applyTimeExtract(DruidExpression timeExpression, TimestampExtractExprMacro.Unit unit, DateTimeZone timeZone) {
        return DruidExpression.ofFunctionCall(timeExpression.getDruidType(), "timestamp_extract", (List<DruidExpression>)ImmutableList.of((Object)timeExpression, (Object)DruidExpression.ofStringLiteral(unit.name()), (Object)DruidExpression.ofStringLiteral(timeZone.getID())));
    }

    public static DruidExpression applyTimeExtract(DruidExpression timeExpression, TimestampExtractExprMacro.Unit unit, DruidExpression timeZoneExpression) {
        return DruidExpression.ofFunctionCall(timeExpression.getDruidType(), "timestamp_extract", (List<DruidExpression>)ImmutableList.of((Object)timeExpression, (Object)DruidExpression.ofStringLiteral(unit.name()), (Object)timeZoneExpression));
    }

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode timeArg = (RexNode)call.getOperands().get(0);
        DruidExpression timeExpression = Expressions.toDruidExpression(plannerContext, rowSignature, timeArg);
        if (timeExpression == null) {
            return null;
        }
        TimestampExtractExprMacro.Unit unit = TimestampExtractExprMacro.Unit.valueOf((String)StringUtils.toUpperCase((String)RexLiteral.stringValue((RexNode)((RexNode)call.getOperands().get(1)))));
        if (call.getOperands().size() > 2 && call.getOperands().get(2) instanceof RexInputRef) {
            RexNode timeZoneArg = (RexNode)call.getOperands().get(2);
            DruidExpression timeZoneExpression = Expressions.toDruidExpression(plannerContext, rowSignature, timeZoneArg);
            return TimeExtractOperatorConversion.applyTimeExtract(timeExpression, unit, timeZoneExpression);
        }
        DateTimeZone timeZone = OperatorConversions.getOperandWithDefault(call.getOperands(), 2, operand -> DateTimes.inferTzFromString((String)RexLiteral.stringValue((RexNode)operand)), plannerContext.getTimeZone());
        return TimeExtractOperatorConversion.applyTimeExtract(timeExpression, unit, timeZone);
    }
}

