/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.sql.calcite.planner.ExpressionParser;

public class ExpressionParserImpl
implements ExpressionParser {
    private static final int MAX_EXPRESSION_WEIGHT = 1000000;
    private final Cache<String, Expr> cache = Caffeine.newBuilder().maximumWeight(1000000L).weigher((key, value) -> key.length()).build();
    private final ExprMacroTable macroTable;

    public ExpressionParserImpl(ExprMacroTable macroTable) {
        this.macroTable = macroTable;
    }

    @Override
    public Expr parse(String expression) {
        return (Expr)this.cache.get((Object)expression, k -> Parser.parse((String)expression, (ExprMacroTable)this.macroTable));
    }
}

