/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.HttpEntity;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.data.input.impl.systemfield.SystemFieldInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.PasswordProvider;

public class HttpInputSource
extends AbstractInputSource
implements SplittableInputSource<URI>,
SystemFieldInputSource {
    public static final String TYPE_KEY = "http";
    private final List<URI> uris;
    @Nullable
    private final String httpAuthenticationUsername;
    @Nullable
    private final PasswordProvider httpAuthenticationPasswordProvider;
    private final SystemFields systemFields;
    private final HttpInputSourceConfig config;
    private final Map<String, String> requestHeaders;

    @JsonCreator
    public HttpInputSource(@JsonProperty(value="uris") List<URI> uris, @JsonProperty(value="httpAuthenticationUsername") @Nullable String httpAuthenticationUsername, @JsonProperty(value="httpAuthenticationPassword") @Nullable PasswordProvider httpAuthenticationPasswordProvider, @JsonProperty(value="systemFields") @Nullable SystemFields systemFields, @JsonProperty(value="requestHeaders") @Nullable Map<String, String> requestHeaders, @JacksonInject HttpInputSourceConfig config) {
        Preconditions.checkArgument((uris != null && !uris.isEmpty() ? 1 : 0) != 0, (Object)"Empty URIs");
        HttpInputSource.throwIfInvalidProtocols(config, uris);
        this.uris = uris;
        this.httpAuthenticationUsername = httpAuthenticationUsername;
        this.httpAuthenticationPasswordProvider = httpAuthenticationPasswordProvider;
        this.systemFields = systemFields == null ? SystemFields.none() : systemFields;
        this.requestHeaders = requestHeaders == null ? Collections.emptyMap() : requestHeaders;
        HttpInputSource.throwIfForbiddenHeaders(config, this.requestHeaders);
        this.config = config;
    }

    public static void throwIfInvalidProtocols(HttpInputSourceConfig config, List<URI> uris) {
        for (URI uri : uris) {
            if (config.getAllowedProtocols().contains(StringUtils.toLowerCase(uri.getScheme()))) continue;
            throw new IAE("Only %s protocols are allowed", config.getAllowedProtocols());
        }
    }

    public static void throwIfForbiddenHeaders(HttpInputSourceConfig config, Map<String, String> requestHeaders) {
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            if (config.getAllowedHeaders().contains(StringUtils.toLowerCase(entry.getKey()))) continue;
            throw InvalidInput.exception("Got forbidden header [%s], allowed headers are only [%s]. You can control the allowed headers by updating druid.ingestion.http.allowedHeaders", entry.getKey(), config.getAllowedHeaders());
        }
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    @Override
    public Set<SystemField> getConfiguredSystemFields() {
        return this.systemFields.getFields();
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHttpAuthenticationUsername() {
        return this.httpAuthenticationUsername;
    }

    @Nullable
    @JsonProperty(value="httpAuthenticationPassword")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PasswordProvider getHttpAuthenticationPasswordProvider() {
        return this.httpAuthenticationPasswordProvider;
    }

    @Nullable
    @JsonProperty(value="requestHeaders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Stream<InputSplit<URI>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.uris.stream().map(InputSplit::new);
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.uris.size();
    }

    public SplittableInputSource<URI> withSplit(InputSplit<URI> split) {
        return new HttpInputSource(Collections.singletonList(split.get()), this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider, this.systemFields, this.requestHeaders, this.config);
    }

    @Override
    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        HttpEntity httpEntity = (HttpEntity)entity;
        switch (field) {
            case URI: {
                return httpEntity.getUri().toString();
            }
            case PATH: {
                return httpEntity.getPath();
            }
        }
        return null;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, CloseableIterators.withEmptyBaggage(this.createSplits(inputFormat, null).map(split -> new HttpEntity((URI)split.get(), this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider, this.requestHeaders)).iterator()), SystemFieldDecoratorFactory.fromInputSource(this), temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpInputSource that = (HttpInputSource)o;
        return Objects.equals(this.uris, that.uris) && Objects.equals(this.httpAuthenticationUsername, that.httpAuthenticationUsername) && Objects.equals(this.httpAuthenticationPasswordProvider, that.httpAuthenticationPasswordProvider) && Objects.equals(this.systemFields, that.systemFields) && Objects.equals(this.requestHeaders, that.requestHeaders) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider, this.systemFields, this.requestHeaders, this.config);
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    public String toString() {
        return "HttpInputSource{uris=\"" + String.valueOf(this.uris) + "\", httpAuthenticationUsername=" + this.httpAuthenticationUsername + ", httpAuthenticationPasswordProvider=" + String.valueOf(this.httpAuthenticationPasswordProvider) + (String)(this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + String.valueOf(this.systemFields)) + ", requestHeaders = " + String.valueOf(this.requestHeaders) + "}";
    }
}

