/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class ComplexFieldWriter
implements FieldWriter {
    public static final byte NULL_BYTE = 0;
    public static final byte NOT_NULL_BYTE = 1;
    static final int HEADER_SIZE = 5;
    private final ComplexMetricSerde serde;
    private final BaseObjectColumnValueSelector<?> selector;

    ComplexFieldWriter(ComplexMetricSerde serde, BaseObjectColumnValueSelector<?> selector) {
        this.serde = serde;
        this.selector = selector;
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        Object complexObject = this.selector.getObject();
        if (maxSize < 5L) {
            return -1L;
        }
        if (complexObject == null) {
            memory.putByte(position, (byte)0);
            memory.putInt(position + 1L, 0);
            return 5L;
        }
        byte[] bytes = this.serde.toBytes(complexObject);
        int fieldLength = 5 + bytes.length;
        if (maxSize < (long)fieldLength) {
            return -1L;
        }
        memory.putByte(position, (byte)1);
        memory.putInt(position + 1L, bytes.length);
        memory.putByteArray(position + 5L, bytes, 0, bytes.length);
        return fieldLength;
    }

    @Override
    public void close() {
    }
}

