/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.NumericFieldWriter;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatFieldWriter
extends NumericFieldWriter {
    private final BaseFloatColumnValueSelector selector;
    private final FrameType frameType;

    public static FloatFieldWriter forPrimitive(BaseFloatColumnValueSelector selector, FrameType frameType) {
        return new FloatFieldWriter(selector, false, frameType);
    }

    public static FloatFieldWriter forArray(BaseFloatColumnValueSelector selector, FrameType frameType) {
        return new FloatFieldWriter(selector, true, frameType);
    }

    private FloatFieldWriter(BaseFloatColumnValueSelector selector, boolean forArray, FrameType frameType) {
        super(selector, forArray);
        this.selector = selector;
        this.frameType = frameType;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumericSizeBytes() {
        return 4;
    }

    @Override
    public void writeSelectorToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, this.selector.getFloat());
    }

    @Override
    public void writeNullToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, 0.0f);
    }

    private void writeToMemory(WritableMemory memory, long position, float value) {
        memory.putInt(position, TransformUtils.transformFromFloat(value, this.frameType));
    }
}

