/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.write.columnar.ComplexFrameMaker;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class ComplexFrameColumnWriter
implements FrameColumnWriter {
    private final ComplexMetricSerde serde;
    private final BaseObjectColumnValueSelector<?> selector;
    private final ComplexFrameMaker maker;

    ComplexFrameColumnWriter(BaseObjectColumnValueSelector<?> selector, MemoryAllocator allocator, ComplexMetricSerde serde) {
        this.selector = selector;
        this.serde = serde;
        this.maker = new ComplexFrameMaker(allocator, StringUtils.toUtf8(serde.getTypeName()));
    }

    @Override
    public boolean addSelection() {
        Object complexObject = this.selector.getObject();
        return this.maker.add(complexObject == null ? null : this.serde.toBytes(complexObject));
    }

    @Override
    public void undo() {
        this.maker.undo();
    }

    @Override
    public long size() {
        return this.maker.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        return this.maker.writeTo(memory, startPosition);
    }

    @Override
    public void close() {
        this.maker.close();
    }
}

