/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;
import java.util.Collection;

public class StrictTypeIdResolver
extends TypeIdResolverBase {
    protected final JavaType baseType;
    protected final TypeNameIdResolver delegate;

    StrictTypeIdResolver() {
        this.baseType = null;
        this.delegate = null;
    }

    StrictTypeIdResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        this.baseType = baseType;
        this.delegate = TypeNameIdResolver.construct(config, (JavaType)baseType, subtypes, (boolean)forSer, (boolean)forDeser);
    }

    public JavaType typeFromId(DatabindContext context, String id) throws JsonProcessingException {
        JavaType type = this.delegate.typeFromId(context, id);
        if (type == null) {
            throw ((DeserializationContext)context).invalidTypeIdException(this.baseType, id, "known type ids = " + this.delegate.getDescForKnownTypeIds());
        }
        return type;
    }

    public String idFromValue(Object value) {
        return this.delegate.idFromValue(value);
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.delegate.idFromValueAndType(value, suggestedType);
    }

    public String getDescForKnownTypeIds() {
        return this.delegate.getDescForKnownTypeIds();
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public static class Builder
    extends StdTypeResolverBuilder {
        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            this._customIdResolver = new StrictTypeIdResolver(config, baseType, subtypes, forSer, forDeser);
            return this._customIdResolver;
        }
    }
}

