/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import io.timeandspace.cronscheduler.CronScheduler;
import io.timeandspace.cronscheduler.CronTask;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;

public class ClockDriftSafeMonitorScheduler
extends MonitorScheduler {
    private static final Logger LOG = new Logger(ClockDriftSafeMonitorScheduler.class);
    private final CronScheduler monitorScheduler;
    private final ExecutorService monitorRunner;

    public ClockDriftSafeMonitorScheduler(DruidMonitorSchedulerConfig config, ServiceEmitter emitter, List<Monitor> monitors, CronScheduler monitorScheduler, ExecutorService monitorRunner) {
        super(config, emitter, monitors);
        this.monitorScheduler = monitorScheduler;
        this.monitorRunner = monitorRunner;
    }

    @Override
    void startMonitor(final Monitor monitor) {
        monitor.start();
        final long rate = this.getConfig().getEmissionDuration().getMillis();
        final AtomicReference<Future> futureReference = new AtomicReference<Future>();
        Future future = this.monitorScheduler.scheduleAtFixedRate(rate, rate, TimeUnit.MILLISECONDS, new CronTask(){
            private Future<?> cancellationFuture = null;
            private Future<Boolean> monitorFuture = null;

            public void run(long scheduledRunTimeMillis) {
                this.waitForScheduleFutureToBeSet();
                if (this.cancellationFuture == null) {
                    LOG.error("scheduleFuture is not set. Can't run monitor[%s]", monitor.getClass().getName());
                    return;
                }
                try {
                    if (this.monitorFuture == null || this.monitorFuture.isDone()) {
                        if (!(this.monitorFuture == null || this.monitorFuture.get().booleanValue() && ClockDriftSafeMonitorScheduler.this.hasMonitor(monitor))) {
                            this.stopMonitor(monitor);
                            return;
                        }
                        LOG.trace("Running monitor[%s]", monitor.getClass().getName());
                        this.monitorFuture = ClockDriftSafeMonitorScheduler.this.monitorRunner.submit(() -> {
                            try {
                                return monitor.monitor(ClockDriftSafeMonitorScheduler.this.getEmitter());
                            }
                            catch (Throwable e) {
                                LOG.error(e, "Exception while executing monitor[%s]. Rescheduling in %s ms", monitor.getClass().getName(), rate);
                                return Boolean.TRUE;
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    LOG.error(e, "Uncaught exception.", new Object[0]);
                }
            }

            private void waitForScheduleFutureToBeSet() {
                if (this.cancellationFuture == null) {
                    while (!Thread.currentThread().isInterrupted()) {
                        if (futureReference.get() == null) continue;
                        this.cancellationFuture = (Future)futureReference.get();
                        break;
                    }
                }
            }

            private void stopMonitor(Monitor monitor2) {
                ClockDriftSafeMonitorScheduler.this.removeMonitor(monitor2);
                this.cancellationFuture.cancel(false);
                LOG.debug("Stopped monitor[%s]", monitor2.getClass().getName());
            }
        });
        futureReference.set(future);
    }
}

