/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.primitives.Longs;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.CgroupUtil;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class Cpu {
    public static final String CGROUP = "cpu";
    private static final Logger LOG = new Logger(Cpu.class);
    private static final String CPUACCT_STAT_FILE = "cpuacct.stat";
    private static final String CPU_SHARES_FILE = "cpu.shares";
    private static final String CPU_QUOTA_FILE = "cpu.cfs_quota_us";
    private static final String CPU_PERIOD_FILE = "cpu.cfs_period_us";
    private final CgroupDiscoverer cgroupDiscoverer;

    public Cpu(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CpuMetrics snapshot() {
        long userJiffies = -1L;
        long systemJiffies = -1L;
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), CPUACCT_STAT_FILE));){
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(Pattern.quote(" "));
                if (parts.length == 2) {
                    switch (parts[0]) {
                        case "user": {
                            userJiffies = Longs.tryParse((String)parts[1]);
                            break;
                        }
                        case "system": {
                            systemJiffies = Longs.tryParse((String)parts[1]);
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.noStackTrace().warn(ex, "Unable to fetch CPU snapshot. Cgroup metrics will not be emitted.", new Object[0]);
        }
        return new CpuMetrics(CgroupUtil.readLongValue(this.cgroupDiscoverer, CGROUP, CPU_SHARES_FILE, -1L), CgroupUtil.readLongValue(this.cgroupDiscoverer, CGROUP, CPU_QUOTA_FILE, 0L), CgroupUtil.readLongValue(this.cgroupDiscoverer, CGROUP, CPU_PERIOD_FILE, 0L), systemJiffies, userJiffies);
    }

    public static class CpuMetrics {
        private final long shares;
        private final long quotaUs;
        private final long periodUs;
        private final long userJiffies;
        private final long systemJiffies;

        CpuMetrics(long shares, long quotaUs, long periodUs, long systemJiffis, long userJiffies) {
            this.shares = shares;
            this.quotaUs = quotaUs;
            this.periodUs = periodUs;
            this.userJiffies = userJiffies;
            this.systemJiffies = systemJiffis;
        }

        public final long getShares() {
            return this.shares;
        }

        public final long getQuotaUs() {
            return this.quotaUs;
        }

        public final long getPeriodUs() {
            return this.periodUs;
        }

        public long getUserJiffies() {
            return this.userJiffies;
        }

        public long getSystemJiffies() {
            return this.systemJiffies;
        }

        public long getTotalJiffies() {
            return this.userJiffies + this.systemJiffies;
        }
    }
}

