/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CoalesceFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.filter.vector.VectorMatch;

public final class CoalesceDoubleVectorProcessor
extends CoalesceFunctionVectorProcessor<double[]> {
    private final double[] output;
    private final boolean[] outputNulls;

    public CoalesceDoubleVectorProcessor(ExprVectorProcessor<double[]>[] processors) {
        super(ExpressionType.DOUBLE, processors);
        this.output = new double[processors[0].maxVectorSize()];
        this.outputNulls = new boolean[processors[0].maxVectorSize()];
    }

    @Override
    public ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding bindings) {
        this.inputBindingFilterer.setBindings(bindings);
        this.inputBindingFilterer.getVectorMatch().copyFrom(VectorMatch.allTrue(bindings.getCurrentVectorSize()));
        int[] selection = this.inputBindingFilterer.getVectorMatch().getSelection();
        int currentProcessor = 0;
        int notNull = 0;
        while (notNull < bindings.getCurrentVectorSize() && currentProcessor < this.processors.length) {
            ExprEvalVector<double[]> currentVector = this.processors[currentProcessor].evalVector(this.inputBindingFilterer);
            double[] currentValues = currentVector.getDoubleVector();
            boolean[] currentNulls = currentVector.getNullVector();
            if (currentProcessor == 0 && currentNulls == null) {
                return currentVector;
            }
            ++currentProcessor;
            int nulls = 0;
            for (int i = 0; i < this.inputBindingFilterer.getCurrentVectorSize(); ++i) {
                int outIndex = selection[i];
                if (currentNulls != null && currentNulls[i]) {
                    if (currentProcessor < this.processors.length) {
                        selection[nulls++] = selection[i];
                        continue;
                    }
                    this.outputNulls[outIndex] = true;
                    this.output[outIndex] = 0.0;
                    continue;
                }
                ++notNull;
                this.outputNulls[outIndex] = false;
                this.output[outIndex] = currentValues[i];
            }
            if (notNull == bindings.getCurrentVectorSize()) break;
            this.inputBindingFilterer.getVectorMatch().setSelectionSize(nulls);
        }
        return new ExprEvalDoubleVector(this.output, this.outputNulls);
    }
}

