/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.IfFunctionVectorProcessor;

public class IfDoubleVectorProcessor
extends IfFunctionVectorProcessor<double[]> {
    private final double[] output;
    private final boolean[] outputNulls;

    public IfDoubleVectorProcessor(ExprVectorProcessor<?> conditionProcessor, ExprVectorProcessor<double[]> thenProcessor, ExprVectorProcessor<double[]> elseProcessor) {
        super(ExpressionType.DOUBLE, conditionProcessor, CastToTypeVectorProcessor.cast(thenProcessor, ExpressionType.DOUBLE), CastToTypeVectorProcessor.cast(elseProcessor, ExpressionType.DOUBLE));
        this.output = new double[conditionProcessor.maxVectorSize()];
        this.outputNulls = new boolean[conditionProcessor.maxVectorSize()];
    }

    @Override
    public ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding bindings) {
        this.thenBindingFilterer.setBindings(bindings);
        this.elseBindingFilterer.setBindings(bindings);
        ExprEvalVector conditionVector = this.conditionProcessor.evalVector(bindings);
        int[] thenSelection = this.thenBindingFilterer.getVectorMatch().getSelection();
        int[] elseSelection = this.elseBindingFilterer.getVectorMatch().getSelection();
        int thens = 0;
        int elses = 0;
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            if (conditionVector.elementAsBoolean(i)) {
                thenSelection[thens++] = i;
                continue;
            }
            elseSelection[elses++] = i;
        }
        this.thenBindingFilterer.getVectorMatch().setSelectionSize(thens);
        this.elseBindingFilterer.getVectorMatch().setSelectionSize(elses);
        if (elses == 0) {
            return this.thenProcessor.evalVector(bindings);
        }
        if (thens == 0) {
            return this.elseProcessor.evalVector(bindings);
        }
        ExprEvalVector thenVector = this.thenProcessor.evalVector(this.thenBindingFilterer);
        double[] thenValues = thenVector.getDoubleVector();
        boolean[] thenNulls = thenVector.getNullVector();
        for (int i = 0; i < thens; ++i) {
            int outIndex = thenSelection[i];
            if (thenNulls != null && thenNulls[i]) {
                this.outputNulls[outIndex] = true;
                continue;
            }
            this.output[outIndex] = thenValues[i];
            this.outputNulls[outIndex] = false;
        }
        ExprEvalVector elseVector = this.elseProcessor.evalVector(this.elseBindingFilterer);
        double[] elseValues = elseVector.getDoubleVector();
        boolean[] elseNulls = elseVector.getNullVector();
        for (int i = 0; i < elses; ++i) {
            int outIndex = elseSelection[i];
            if (elseNulls != null && elseNulls[i]) {
                this.outputNulls[outIndex] = true;
                continue;
            }
            this.output[outIndex] = elseValues[i];
            this.outputNulls[outIndex] = false;
        }
        return new ExprEvalDoubleVector(this.output, this.outputNulls);
    }
}

