/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.any.NumericAnyBufferAggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleAnyBufferAggregator
extends NumericAnyBufferAggregator<BaseDoubleColumnValueSelector> {
    public DoubleAnyBufferAggregator(BaseDoubleColumnValueSelector valueSelector) {
        super(valueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putDouble(position + 1, 0.0);
    }

    @Override
    void putValue(ByteBuffer buf, int position) {
        buf.putDouble(position + 1, ((BaseDoubleColumnValueSelector)this.valueSelector).getDouble());
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean isNull = this.isValueNull(buf, position);
        return isNull ? null : Double.valueOf(buf.getDouble(position + 1));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position + 1);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position + 1);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getDouble(position + 1);
    }
}

