/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.mean;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.mean.DoubleMeanAggregator;
import org.apache.druid.query.aggregation.mean.DoubleMeanBufferAggregator;
import org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.apache.druid.query.aggregation.mean.DoubleMeanVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class DoubleMeanAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex("doubleMean");
    private final String name;
    private final String fieldName;

    @JsonCreator
    public DoubleMeanAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"null name");
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"null fieldName");
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    @Override
    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.DOUBLE;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 16;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new DoubleMeanAggregatorFactory(newName, this.getFieldName());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new DoubleMeanAggregator(metricFactory.makeColumnValueSelector(this.fieldName));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new DoubleMeanBufferAggregator(metricFactory.makeColumnValueSelector(this.fieldName));
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return new DoubleMeanVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(this.fieldName);
        return capabilities == null || capabilities.isNumeric();
    }

    @Override
    public Comparator getComparator() {
        return DoubleMeanHolder.COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs instanceof DoubleMeanHolder && rhs instanceof DoubleMeanHolder) {
            return ((DoubleMeanHolder)lhs).update((DoubleMeanHolder)rhs);
        }
        throw new IAE("lhs[%s] or rhs[%s] not of type [%s]", Utils.safeObjectClassGetName(lhs), Utils.safeObjectClassGetName(rhs), DoubleMeanHolder.class.getName());
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMeanAggregatorFactory(this.name, this.name);
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            return DoubleMeanHolder.fromBytes((byte[])object);
        }
        if (object instanceof String) {
            return DoubleMeanHolder.fromBytes(StringUtils.decodeBase64(StringUtils.toUtf8((String)object)));
        }
        if (object instanceof DoubleMeanHolder) {
            return object;
        }
        throw new IAE("Unknown object type [%s]", Utils.safeObjectClassGetName(object));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (object instanceof byte[]) {
            return DoubleMeanHolder.fromBytes((byte[])object).mean();
        }
        if (object instanceof DoubleMeanHolder) {
            return ((DoubleMeanHolder)object).mean();
        }
        if (object == null) {
            return null;
        }
        throw new IAE("Unknown object type [%s]", object.getClass().getName());
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(65).appendString(this.name).appendString(this.fieldName).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleMeanAggregatorFactory that = (DoubleMeanAggregatorFactory)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName);
    }
}

