/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.operator.window.ranking.WindowRankingProcessorBase;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;

public class WindowDenseRankProcessor
extends WindowRankingProcessorBase {
    @JsonCreator
    public WindowDenseRankProcessor(@JsonProperty(value="group") List<String> groupingCols, @JsonProperty(value="outputColumn") String outputColumn) {
        super(groupingCols, outputColumn);
    }

    @Override
    public RowsAndColumns process(RowsAndColumns incomingPartition) {
        return this.processInternal(incomingPartition, groupings -> {
            int[] ranks = new int[incomingPartition.numRows()];
            for (int i = 1; i < ((int[])groupings).length; ++i) {
                int start = groupings[i - 1];
                int end = groupings[i];
                Arrays.fill(ranks, start, end, i);
            }
            return new IntArrayColumn(ranks);
        });
    }
}

