/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.topn.AggregateTopNMetricFirstAlgorithm;
import org.apache.druid.query.topn.HeapBasedTopNAlgorithm;
import org.apache.druid.query.topn.PooledTopNAlgorithm;
import org.apache.druid.query.topn.TimeExtractionTopNAlgorithm;
import org.apache.druid.query.topn.TopNAlgorithm;
import org.apache.druid.query.topn.TopNAlgorithmSelector;
import org.apache.druid.query.topn.TopNCursorInspector;
import org.apache.druid.query.topn.TopNMapFn;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMissingException;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class TopNQueryEngine {
    private final NonBlockingPool<ByteBuffer> bufferPool;

    public TopNQueryEngine(NonBlockingPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Sequence<Result<TopNResultValue>> query(TopNQuery query, Segment segment, @Nullable TopNQueryMetrics queryMetrics) {
        CursorFactory cursorFactory = segment.as(CursorFactory.class);
        if (cursorFactory == null) {
            throw new SegmentMissingException("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        CursorBuildSpec buildSpec = TopNQueryEngine.makeCursorBuildSpec(query, queryMetrics);
        CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);
        try {
            Cursor cursor;
            if (cursorHolder.isPreAggregated()) {
                query = query.withAggregatorSpecs((List)Preconditions.checkNotNull(cursorHolder.getAggregatorsForPreAggregated()));
            }
            if ((cursor = cursorHolder.asCursor()) == null) {
                return Sequences.withBaggage(Sequences.empty(), cursorHolder);
            }
            TimeBoundaryInspector timeBoundaryInspector = segment.as(TimeBoundaryInspector.class);
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            ColumnSelectorPlus selectorPlus = DimensionHandlerUtils.createColumnSelectorPlus(new TopNColumnAggregatesProcessorFactory(query.getDimensionSpec().getOutputType()), query.getDimensionSpec(), factory);
            int cardinality = selectorPlus.getSelector() instanceof DimensionDictionarySelector ? ((DimensionDictionarySelector)((Object)selectorPlus.getSelector())).getValueCardinality() : -1;
            TopNCursorInspector cursorInspector = new TopNCursorInspector(factory, segment.as(TopNOptimizationInspector.class), segment.getDataInterval(), cardinality);
            CursorGranularizer granularizer = CursorGranularizer.create(cursor, timeBoundaryInspector, cursorHolder.getTimeOrder(), query.getGranularity(), buildSpec.getInterval());
            if (granularizer == null || selectorPlus.getSelector() == null) {
                return Sequences.withBaggage(Sequences.empty(), cursorHolder);
            }
            if (queryMetrics != null) {
                queryMetrics.cursor(cursor);
            }
            TopNMapFn mapFn = this.getMapFn(query, cursorInspector, queryMetrics);
            return Sequences.filter(Sequences.simple(granularizer.getBucketIterable()).map(bucketInterval -> {
                granularizer.advanceToBucket((Interval)bucketInterval);
                return mapFn.apply(cursor, selectorPlus, granularizer, queryMetrics);
            }), Predicates.notNull()).withBaggage(cursorHolder);
        }
        catch (Throwable t) {
            throw CloseableUtils.closeAndWrapInCatch(t, cursorHolder);
        }
    }

    private TopNMapFn getMapFn(TopNQuery query, TopNCursorInspector cursorInspector, @Nullable TopNQueryMetrics queryMetrics) {
        String dimension = query.getDimensionSpec().getDimension();
        if (queryMetrics != null) {
            queryMetrics.dimensionCardinality(cursorInspector.getDimensionCardinality());
        }
        int numBytesPerRecord = 0;
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            numBytesPerRecord += aggregatorFactory.getMaxIntermediateSizeWithNulls();
        }
        TopNAlgorithmSelector selector = new TopNAlgorithmSelector(cursorInspector.getDimensionCardinality(), numBytesPerRecord);
        query.initTopNAlgorithmSelector(selector);
        ColumnCapabilities columnCapabilities = query.getVirtualColumns().getColumnCapabilitiesWithFallback(cursorInspector.getColumnInspector(), dimension);
        TopNAlgorithm<Aggregator[][], TopNParams> topNAlgorithm = TopNQueryEngine.canUsePooledAlgorithm(selector, query, columnCapabilities, this.bufferPool, cursorInspector.getDimensionCardinality(), numBytesPerRecord) ? (selector.isAggregateAllMetrics() ? new PooledTopNAlgorithm(query, cursorInspector, this.bufferPool) : (TopNQueryEngine.shouldUseAggregateMetricFirstAlgorithm(query, selector) ? new AggregateTopNMetricFirstAlgorithm(query, cursorInspector, this.bufferPool) : new PooledTopNAlgorithm(query, cursorInspector, this.bufferPool))) : (selector.isHasExtractionFn() && dimension.equals("__time") ? new TimeExtractionTopNAlgorithm(query, cursorInspector) : new HeapBasedTopNAlgorithm(query, cursorInspector));
        if (queryMetrics != null) {
            queryMetrics.algorithm(topNAlgorithm);
        }
        return new TopNMapFn(query, topNAlgorithm);
    }

    private static boolean canUsePooledAlgorithm(TopNAlgorithmSelector selector, TopNQuery query, ColumnCapabilities capabilities, NonBlockingPool<ByteBuffer> bufferPool, int cardinality, int numBytesPerRecord) {
        if (cardinality < 0) {
            return false;
        }
        if (selector.isHasExtractionFn()) {
            return false;
        }
        if (!query.getDimensionSpec().getOutputType().is(ValueType.STRING)) {
            return false;
        }
        if (!Types.is(capabilities, ValueType.STRING)) {
            return false;
        }
        if (!capabilities.isDictionaryEncoded().isTrue() || !capabilities.areDictionaryValuesUnique().isTrue()) {
            return false;
        }
        try (ResourceHolder<ByteBuffer> resultsBufHolder = bufferPool.take();){
            ByteBuffer resultsBuf = resultsBufHolder.get();
            int numBytesToWorkWith = resultsBuf.capacity();
            int numValuesPerPass = numBytesPerRecord > 0 ? numBytesToWorkWith / numBytesPerRecord : cardinality;
            boolean allowMultiPassPooled = query.context().getBoolean("useTopNMultiPassPooledQueryGranularity", false);
            if (Granularities.ALL.equals(query.getGranularity()) || allowMultiPassPooled) {
                boolean bl = numValuesPerPass > 0;
                return bl;
            }
            boolean bl = numValuesPerPass >= cardinality;
            return bl;
        }
    }

    private static boolean shouldUseAggregateMetricFirstAlgorithm(TopNQuery query, TopNAlgorithmSelector selector) {
        if (Granularities.ALL.equals(query.getGranularity())) {
            return selector.isAggregateTopNMetricFirst() || query.context().getBoolean("doAggregateTopNMetricFirst", false);
        }
        return false;
    }

    public static CursorBuildSpec makeCursorBuildSpec(TopNQuery query, @Nullable QueryMetrics<?> queryMetrics) {
        return Granularities.decorateCursorBuildSpec(query, CursorBuildSpec.builder().setInterval(query.getSingleInterval()).setFilter(Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()))).setGroupingColumns(Collections.singletonList(query.getDimensionSpec().getDimension())).setVirtualColumns(query.getVirtualColumns()).setPhysicalColumns(query.getRequiredColumns()).setAggregators(query.getAggregatorSpecs()).setQueryContext(query.context()).setQueryMetrics(queryMetrics).build());
    }

    public static boolean canApplyExtractionInPost(TopNQuery query) {
        return query.getDimensionSpec() != null && query.getDimensionSpec().getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)query.getDimensionSpec().getExtractionFn().getExtractionType()) && query.getTopNMetricSpec().canBeOptimizedUnordered();
    }
}

