/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.BypassRestrictedSegment;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.RestrictedCursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.WrappedTimeBoundaryInspector;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class RestrictedSegment
implements Segment {
    protected final Segment delegate;
    protected final Policy policy;

    public RestrictedSegment(Segment delegate, Policy policy) {
        Preconditions.checkArgument((boolean)(delegate instanceof ReferenceCountedSegmentProvider.LeafReference), (Object)"delegate must be a Segment checked out from a ReferenceCountingObjectProvider");
        this.delegate = delegate;
        this.policy = policy;
    }

    @Override
    public SegmentId getId() {
        return this.delegate.getId();
    }

    @Override
    public Interval getDataInterval() {
        return this.delegate.getDataInterval();
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)new RestrictedCursorFactory(this.delegate.as(CursorFactory.class), this.policy);
        }
        if (QueryableIndex.class.equals(clazz)) {
            return null;
        }
        if (TimeBoundaryInspector.class.equals(clazz)) {
            return (T)WrappedTimeBoundaryInspector.create(this.delegate.as(TimeBoundaryInspector.class));
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(this.policy instanceof NoRestrictionPolicy);
        }
        if (BypassRestrictedSegment.class.equals(clazz)) {
            return (T)new BypassRestrictedSegment(this.delegate, this.policy);
        }
        if (this.policy instanceof NoRestrictionPolicy) {
            return this.delegate.as(clazz);
        }
        return null;
    }

    @Override
    public void validateOrElseThrow(PolicyEnforcer policyEnforcer) {
        policyEnforcer.validateOrElseThrow(this.delegate, this.policy);
    }

    @Override
    public boolean isTombstone() {
        return this.delegate.isTombstone();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public String getDebugString() {
        return "restricted->" + this.delegate.getDebugString();
    }
}

