/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import it.unimi.dsi.fastutil.Hash;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.ObjectStrategy;

public class ObjectStrategyComplexTypeStrategy<T>
implements TypeStrategy<T> {
    private final ObjectStrategy<T> objectStrategy;
    private final TypeSignature<?> typeSignature;
    @Nullable
    private final Hash.Strategy<T> hashStrategy;
    @Nullable
    private final Class<?> clazz;

    public ObjectStrategyComplexTypeStrategy(ObjectStrategy<T> objectStrategy, TypeSignature<?> signature) {
        this(objectStrategy, signature, null);
    }

    public ObjectStrategyComplexTypeStrategy(ObjectStrategy<T> objectStrategy, TypeSignature<?> signature, @Nullable Hash.Strategy<T> hashStrategy) {
        this.objectStrategy = objectStrategy;
        this.typeSignature = signature;
        this.hashStrategy = hashStrategy;
        this.clazz = hashStrategy == null ? null : objectStrategy.getClazz();
    }

    @Override
    public int estimateSizeBytes(@Nullable T value) {
        byte[] bytes = this.objectStrategy.toBytes(value);
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    @Override
    public T read(ByteBuffer buffer) {
        int complexLength = buffer.getInt();
        ByteBuffer dupe = buffer.duplicate();
        dupe.order(buffer.order());
        dupe.limit(dupe.position() + complexLength);
        T value = this.objectStrategy.fromByteBuffer(dupe, complexLength);
        buffer.position(buffer.position() + complexLength);
        return value;
    }

    @Override
    public boolean readRetainsBufferReference() {
        return this.objectStrategy.readRetainsBufferReference();
    }

    @Override
    public int write(ByteBuffer buffer, T value, int maxSizeBytes) {
        TypeStrategies.checkMaxSize(buffer.remaining(), maxSizeBytes, this.typeSignature);
        byte[] bytes = this.objectStrategy.toBytes(value);
        int sizeBytes = 4 + bytes.length;
        int remaining = maxSizeBytes - sizeBytes;
        if (remaining >= 0) {
            buffer.putInt(bytes.length);
            buffer.put(bytes, 0, bytes.length);
            return sizeBytes;
        }
        return remaining;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.objectStrategy.compare(o1, o2);
    }

    @Override
    public T fromBytes(byte[] value) {
        return this.objectStrategy.fromByteBufferSafe(ByteBuffer.wrap(value), value.length);
    }

    @Override
    public boolean groupable() {
        return this.hashStrategy != null;
    }

    @Override
    public int hashCode(T o) {
        if (this.hashStrategy == null) {
            throw DruidException.defensive("Type [%s] is not groupable", this.typeSignature.asTypeString());
        }
        return this.hashStrategy.hashCode(o);
    }

    @Override
    public boolean equals(T a, T b) {
        if (this.hashStrategy == null) {
            throw DruidException.defensive("Type [%s] is not groupable", this.typeSignature.asTypeString());
        }
        return this.hashStrategy.equals(a, b);
    }

    @Override
    public Class<?> getClazz() {
        if (this.clazz == null) {
            throw DruidException.defensive("Type [%s] is not groupable", this.typeSignature.asTypeString());
        }
        return this.clazz;
    }
}

